/*
 * Decompiled with CFR 0.152.
 */
package buffer;

import buffer.Wrapper;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Map;

public abstract class CanonicalWatched {
    private int _nbReferences = 0;

    public final void watch() {
        ++this._nbReferences;
    }

    public final <K extends CanonicalWatched> void unwatch() {
        --this._nbReferences;
        if (this._nbReferences < 0) {
            throw new IllegalStateException("Negative number of watchers " + this.getClass());
        }
        if (this._nbReferences == 0) {
            Wrapper<CanonicalWatched> w = new Wrapper<CanonicalWatched>(this);
            Map<Object, K> buffer = this.getBuffer();
            buffer.remove(w);
            this.destroy();
        }
    }

    public final boolean equals(Object obj) {
        return this == obj;
    }

    public abstract int hashCode();

    protected final <K extends CanonicalWatched> K getCanonical() {
        Wrapper<CanonicalWatched> w;
        CanonicalWatched k = this;
        Map<Object, Wrapper<CanonicalWatched>> buffer = this.getBuffer();
        CanonicalWatched result = (CanonicalWatched)buffer.get(w = new Wrapper<CanonicalWatched>(k));
        if (result != null) {
            return (K)result;
        }
        buffer.put(w, (Wrapper<CanonicalWatched>)((Object)k));
        return (K)k;
    }

    protected void destroy() {
    }

    protected abstract boolean equivalent(Object var1);

    protected abstract <K extends CanonicalWatched> Map<Object, K> getBuffer();

    public void print(PrintStream out) {
        out.println("</> " + this.getBuffer().size());
        int numberOfReferences = 0;
        for (Map.Entry ent : this.getBuffer().entrySet()) {
            CanonicalWatched watched = (CanonicalWatched)ent.getValue();
            int nbWatchedReferences = watched._nbReferences;
            numberOfReferences += nbWatchedReferences;
        }
        out.println("</> " + numberOfReferences);
        for (Map.Entry ent : this.getBuffer().entrySet()) {
            Object wrapper = ent.getKey();
            CanonicalWatched watched = (CanonicalWatched)ent.getValue();
            out.println(wrapper + " -> " + watched + " (" + watched._nbReferences + ")");
        }
    }

    public static void unwatchAll(Collection<? extends CanonicalWatched> coll) {
        for (CanonicalWatched canonicalWatched : coll) {
            if (canonicalWatched == null) continue;
            canonicalWatched.unwatch();
        }
    }

    public void verifyValidity() {
        if (this._nbReferences == 0) {
            throw new IllegalStateException("No reference to this object.");
        }
    }
}

