/*
 * Decompiled with CFR 0.152.
 */
package buffer;

import java.util.Map;

public abstract class ObjectWithParents<PC extends ObjectWithParents> {
    private Map<PC, PC> _parents;
    private int _nbWatchers;

    public PC getCanonicalObjectOfParent(PC prt) {
        if (prt == null) {
            return null;
        }
        ObjectWithParents result = (ObjectWithParents)this._parents.get(prt);
        if (result != null) {
            return (PC)result;
        }
        this._parents.put(prt, prt);
        Iterable<PC> it = ((ObjectWithParents)prt).getSecondaryChildren();
        for (ObjectWithParents child : it) {
            child.watch();
        }
        return prt;
    }

    public void removeParentFromPrimaryChild(PC prt) {
        this._parents.remove(prt);
        this.checkRemove();
    }

    public abstract PC getPrimaryChild();

    public abstract Iterable<PC> getSecondaryChildren();

    public void watch() {
        ++this._nbWatchers;
    }

    public void unwatch() {
        --this._nbWatchers;
    }

    private void checkRemove() {
        if (this.hasParents()) {
            this.removeCurrent();
        }
    }

    private void removeCurrent() {
        ObjectWithParents child = this.getPrimaryChild();
        if (child != null) {
            child.removeParentFromPrimaryChild((ObjectWithParents)this);
        }
        for (ObjectWithParents child2 : this.getSecondaryChildren()) {
            child2.unwatch();
        }
    }

    private boolean hasParents() {
        if (this._nbWatchers > 0) {
            return true;
        }
        return this._parents.isEmpty();
    }
}

