/*
 * Decompiled with CFR 0.152.
 */
package sdd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sdd.Variable;

public class Assignment {
    private final Map<Variable, Boolean> _ass;

    public Assignment(Variable var, boolean val) {
        this._ass = new HashMap<Variable, Boolean>();
        this._ass.put(var, val);
    }

    public Assignment(Map<Variable, Boolean> ass) {
        this._ass = new HashMap<Variable, Boolean>(ass);
    }

    public Assignment() {
        this._ass = new HashMap<Variable, Boolean>();
    }

    public Assignment(Assignment ass, Variable var, boolean val) {
        this._ass = new HashMap<Variable, Boolean>(ass._ass);
        this._ass.put(var, val);
    }

    public Assignment(Assignment ass1, Assignment ass2) {
        this._ass = new HashMap<Variable, Boolean>(ass1._ass);
        for (Map.Entry<Variable, Boolean> ent : ass2._ass.entrySet()) {
            Variable var = ent.getKey();
            Boolean val = ent.getValue();
            this._ass.put(var, val);
        }
    }

    public Set<Variable> assignedVariables() {
        return Collections.unmodifiableSet(this._ass.keySet());
    }

    public Boolean assignment(Variable var) {
        return this._ass.get(var);
    }

    public static List<Assignment> carthesianProduct(Collection<Assignment> asses1, Collection<Assignment> asses2) {
        ArrayList<Assignment> result = new ArrayList<Assignment>();
        for (Assignment ass1 : asses1) {
            for (Assignment ass2 : asses2) {
                Assignment ass = new Assignment(ass1, ass2);
                result.add(ass);
            }
        }
        return result;
    }

    public int hashCode() {
        return this._ass.hashCode();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof Assignment)) {
            return false;
        }
        Assignment ass = (Assignment)o;
        return this._ass.equals(ass._ass);
    }

    public String toString() {
        return this._ass.toString();
    }
}

