/*
 * Decompiled with CFR 0.152.
 */
package sdd;

import java.util.List;
import sdd.SDD;
import sdd.Vtree;
import util.PseudoRandom;

public class Random {
    public static SDD generateRandom3CNFFromList(PseudoRandom rand, List<SDD> base, int nbClauses) {
        SDD[] baseArray = new SDD[base.size()];
        for (int i = 0; i < base.size(); ++i) {
            baseArray[i] = base.get(i);
        }
        SDD result = Random.generateRandom3CNF(rand, baseArray, nbClauses);
        return result;
    }

    public static SDD generateRandom3CNF(PseudoRandom rand, SDD[] base, int nbClauses) {
        Vtree tree = base[0].getTree();
        SDD result = SDD.constant(true, tree);
        for (int i = 0; i < nbClauses; ++i) {
            int index1 = rand.rand(base.length);
            int index2 = rand.rand(base.length);
            int index3 = rand.rand(base.length);
            SDD sdd1 = base[index1];
            SDD sdd2 = base[index2];
            SDD sdd3 = base[index3];
            SDD clause = SDD.or(tree, sdd1, sdd2, sdd3);
            SDD toUnwatch = result;
            result = result.and(clause);
            toUnwatch.unwatch();
            clause.unwatch();
        }
        return result;
    }
}

