/*
 * Decompiled with CFR 0.152.
 */
package sdd;

import buffer.CanonicalWatched;
import java.io.PrintStream;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import sdd.Assignment;
import sdd.SDDConstant;
import sdd.SDDFunction;
import sdd.SDDMemory;
import sdd.SDDTree;
import sdd.SDDTreeConjunction;
import sdd.SDDTreeDisjunction;
import sdd.SDDTrees;
import sdd.SDDVariable;
import sdd.Variable;
import sdd.Vtree;
import sdd.VtreeLeaf;
import sdd.VtreeNode;
import sdd.VtreePath;
import sdd.ope.LeftRotation;
import sdd.ope.RightRotation;
import sdd.ope.Swap;
import util.DotStream;
import util.IntegerTokenizer;
import util.NumberedNameGenerator;

public class SDD
extends CanonicalWatched {
    private final SDDTree _sdd;
    private final Vtree _tree;
    private static final Map<Object, SDD> BUFFER = new HashMap<Object, SDD>();

    private SDD(SDDTree sdd, Vtree tree) {
        this._sdd = sdd;
        this._tree = tree;
    }

    public static SDD create(SDDTree sdd, Vtree tree) {
        SDD newSDD = new SDD(sdd, tree);
        SDD canon = (SDD)newSDD.getCanonical();
        if (newSDD == canon) {
            sdd.watch();
            tree.watch();
        }
        canon.watch();
        return canon;
    }

    public static SDD variable(Variable var, Vtree tree) {
        VtreeLeaf leaf = VtreeLeaf.create(var);
        VtreePath path = new VtreePath(tree, leaf);
        path.gotoLeaf();
        SDDMemory mem = new SDDMemory();
        SDDTree sddTree = SDDVariable.create(var, true);
        do {
            SDDTreeConjunction con1;
            HashSet<SDDTreeConjunction> set;
            Vtree previousVtree = path.get();
            path.up();
            boolean isVariableOnLeft = path.isDownLeft();
            if (isVariableOnLeft) {
                set = new HashSet<SDDTreeConjunction>();
                SDDTree prime = sddTree;
                SDDConstant sub = SDDConstant.getTrue();
                con1 = SDDTreeConjunction.create(prime, sub);
                sub.unwatch();
                prime = SDDTrees.not(sddTree, mem);
                sub = SDDConstant.getFalse();
                SDDTreeConjunction con2 = SDDTreeConjunction.create(prime, sub);
                prime.unwatch();
                sub.unwatch();
                set.add(con1);
                set.add(con2);
                sddTree.unwatch();
                sddTree = SDDTreeDisjunction.create(set);
                con1.unwatch();
                con2.unwatch();
                continue;
            }
            set = new HashSet();
            SDDConstant prime = SDDConstant.getTrue();
            SDDVariable sub = sddTree;
            con1 = SDDTreeConjunction.create(prime, sub);
            prime.unwatch();
            set.add(con1);
            sddTree.unwatch();
            sddTree = SDDTreeDisjunction.create(set);
            con1.unwatch();
        } while (!path.isAtRoot());
        SDD result = SDD.create(sddTree, tree);
        sddTree.unwatch();
        mem.empty();
        return result;
    }

    public static SDD constant(boolean constant, Vtree tree) {
        SDDConstant sddConstant = SDDConstant.get(constant);
        SDD result = SDD.create(sddConstant, tree);
        sddConstant.unwatch();
        return result;
    }

    @Override
    public int hashCode() {
        return this._sdd.hashCode();
    }

    @Override
    protected boolean equivalent(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SDD)) {
            return false;
        }
        SDD sdd = (SDD)obj;
        return this._sdd.equals(sdd._sdd);
    }

    protected Map<Object, SDD> getBuffer() {
        return BUFFER;
    }

    @Override
    protected void destroy() {
        this._sdd.unwatch();
        this._tree.unwatch();
    }

    public static SDD readCNF(Vtree vtree, List<SDD> vars, IntegerTokenizer tokizer) {
        SDD result = SDD.constant(true, vtree);
        while (!tokizer.isFinished()) {
            SDD clause = SDD.constant(false, vtree);
            while (true) {
                SDD sddLit;
                if (tokizer.isFinished()) {
                    throw new IllegalStateException("Clause not ended");
                }
                int intLit = tokizer.nextToken();
                if (intLit == 0) break;
                int intVar = Math.abs(intLit);
                SDD sddVar = vars.get(intVar);
                sddVar.watch();
                if (intLit > 0) {
                    sddLit = sddVar;
                } else {
                    sddLit = sddVar.neg();
                    sddVar.unwatch();
                }
                SDD oldClause = clause;
                clause = clause.or(sddLit);
                oldClause.unwatch();
                sddLit.unwatch();
            }
            SDD oldResult = result;
            result = result.and(clause);
            oldResult.unwatch();
        }
        return result;
    }

    public Vtree getTree() {
        return this._tree;
    }

    public SDDTree getSDDTree() {
        return this._sdd;
    }

    public String toString() {
        StringBuilder bui = new StringBuilder();
        bui.append("SDD:{");
        HashMap<SDDTree, String> treeNames = new HashMap<SDDTree, String>();
        HashMap<SDDTreeConjunction, String> conjNames = new HashMap<SDDTreeConjunction, String>();
        this._sdd.saveToString(bui, treeNames, conjNames, 1);
        bui.append("}");
        return bui.toString();
    }

    public void toDot() {
        DotStream out = new DotStream(System.out);
        this.toDot(out);
        out.end();
    }

    public void toDot(String filename) {
        DotStream out = new DotStream(filename);
        this.toDot(out);
        out.end();
    }

    private void toDot(DotStream out) {
        HashMap<SDDTree, String> treeNames = new HashMap<SDDTree, String>();
        HashMap<SDDTreeConjunction, String> conjNames = new HashMap<SDDTreeConjunction, String>();
        NumberedNameGenerator gen = new NumberedNameGenerator("N_");
        this._sdd.saveToDot(out, treeNames, conjNames, gen);
        out.end();
    }

    public static void toDot(String filename, SDD ... sdds) {
        DotStream out = new DotStream(filename);
        HashMap<SDDTree, String> treeNames = new HashMap<SDDTree, String>();
        HashMap<SDDTreeConjunction, String> conjNames = new HashMap<SDDTreeConjunction, String>();
        NumberedNameGenerator genRoot = new NumberedNameGenerator("R_");
        for (SDD sdd : sdds) {
            treeNames.put(sdd._sdd, genRoot.generateName());
        }
        NumberedNameGenerator gen = new NumberedNameGenerator("N_");
        for (SDD sdd : sdds) {
            sdd._sdd.saveToDot(out, treeNames, conjNames, gen);
        }
        out.end();
    }

    public static void printBuffer(PrintStream out) {
        block0: {
            Iterator<Map.Entry<Object, SDD>> i$ = BUFFER.entrySet().iterator();
            if (!i$.hasNext()) break block0;
            Map.Entry<Object, SDD> ent = i$.next();
            CanonicalWatched watched = ent.getValue();
            watched.print(out);
        }
    }

    public SDD and(SDD other) {
        SDDMemory mem = new SDDMemory();
        SDDTree sddTree = SDDTrees.and(this._sdd, other._sdd, mem);
        SDD result = SDD.create(sddTree, this._tree);
        sddTree.unwatch();
        mem.empty();
        return result;
    }

    public SDD or(SDD other) {
        SDDMemory mem = new SDDMemory();
        SDDTree sddTree = SDDTrees.or(this._sdd, other._sdd, mem);
        SDD result = SDD.create(sddTree, this._tree);
        sddTree.unwatch();
        mem.empty();
        return result;
    }

    public static SDD or(Vtree tree, SDD ... sdds) {
        SDD result = SDD.constant(false, tree);
        for (SDD sdd : sdds) {
            SDD toUnwatch = result;
            result = result.or(sdd);
            toUnwatch.unwatch();
        }
        return result;
    }

    public SDD neg() {
        SDDMemory mem = new SDDMemory();
        SDDTree sddTree = SDDTrees.not(this._sdd, mem);
        SDD result = SDD.create(sddTree, this._tree);
        sddTree.unwatch();
        mem.empty();
        return result;
    }

    public SDD exists(Variable vr) {
        SDDMemory mem = new SDDMemory();
        VtreeLeaf vt = VtreeLeaf.create(vr);
        VtreePath path = new VtreePath(this._tree, vt);
        path.gotoRoot();
        SDDTree sddTree = SDDTrees.exists(this._sdd, vr, mem, path);
        SDD result = SDD.create(sddTree, this._tree);
        sddTree.unwatch();
        mem.empty();
        return result;
    }

    public SDD forall(Variable vr) {
        SDDMemory mem = new SDDMemory();
        VtreeLeaf vt = VtreeLeaf.create(vr);
        VtreePath path = new VtreePath(this._tree, vt);
        path.gotoRoot();
        SDDTree sddTree = SDDTrees.forall(this._sdd, vr, mem, path);
        SDD result = SDD.create(sddTree, this._tree);
        sddTree.unwatch();
        mem.empty();
        return result;
    }

    public SDD replace(Variable var1, Variable var2) {
        SDD sddVar1 = SDD.variable(var1, this._tree);
        SDD sddVar2 = SDD.variable(var1, this._tree);
        SDD and = sddVar1.and(sddVar2);
        SDD not1 = sddVar1.neg();
        SDD not2 = sddVar2.neg();
        SDD andNot = not1.and(not2);
        SDD equiv = and.or(andNot);
        sddVar1.unwatch();
        sddVar2.unwatch();
        and.unwatch();
        not1.unwatch();
        not2.unwatch();
        andNot.unwatch();
        SDD sdd2 = this.and(equiv);
        SDD result = sdd2.exists(var1);
        equiv.unwatch();
        sdd2.unwatch();
        return result;
    }

    public SDD rightRotationOnRoot() {
        SDD result;
        VtreeNode tree = (VtreeNode)this._tree;
        Vtree a = tree.getLeft();
        VtreeNode bc = (VtreeNode)tree.getRight();
        Vtree b = bc.getLeft();
        Vtree c = bc.getRight();
        VtreeNode ab = VtreeNode.create(a, b);
        VtreeNode newTree = VtreeNode.create(ab, c);
        if (this._sdd.isDisjunction()) {
            SDDMemory mem = new SDDMemory();
            SDDTreeDisjunction disj = this._sdd.getDisjunction();
            SDDTree newSDD = RightRotation.rightRotationOnCurrentNode(mem, disj);
            result = SDD.create(newSDD, newTree);
            newSDD.unwatch();
            mem.empty();
        } else {
            SDDConstant con = this._sdd.getConstant();
            result = SDD.create(con, newTree);
        }
        newTree.unwatch();
        ab.unwatch();
        return result;
    }

    public SDD rightRotation(VtreeNode nodeWhereRightRotationIsPerformed) {
        Vtree left = nodeWhereRightRotationIsPerformed.getLeft();
        Vtree right = nodeWhereRightRotationIsPerformed.getRight();
        if (right.isLeaf()) {
            return this;
        }
        VtreeNode rightNode = (VtreeNode)right;
        Vtree rleft = rightNode.getLeft();
        Vtree rright = rightNode.getRight();
        VtreeNode newLeft = VtreeNode.create(left, rleft);
        VtreeNode newTree = VtreeNode.create(newLeft, rright);
        newLeft.unwatch();
        SDDMemory mem = new SDDMemory();
        VtreePath path = new VtreePath(this._tree, nodeWhereRightRotationIsPerformed);
        SDDTree resultSDDTree = RightRotation.rightRotation(this._sdd, mem, path);
        SDD result = SDD.create(resultSDDTree, newTree);
        newTree.unwatch();
        resultSDDTree.unwatch();
        mem.empty();
        return result;
    }

    public SDD leftRotationOnRoot() {
        SDD result;
        VtreeNode tree = (VtreeNode)this._tree;
        VtreeNode ab = (VtreeNode)tree.getLeft();
        Vtree c = tree.getRight();
        Vtree a = ab.getLeft();
        Vtree b = ab.getRight();
        VtreeNode bc = VtreeNode.create(b, c);
        VtreeNode newTree = VtreeNode.create(a, bc);
        if (this._sdd.isDisjunction()) {
            SDDTreeDisjunction disj = this._sdd.getDisjunction();
            SDDMemory mem = new SDDMemory();
            SDDTree newSDD = LeftRotation.leftRotationOnCurrentNode(mem, disj);
            result = SDD.create(newSDD, newTree);
            newSDD.unwatch();
            mem.empty();
        } else {
            SDDConstant con = this._sdd.getConstant();
            result = SDD.create(con, newTree);
        }
        newTree.unwatch();
        bc.unwatch();
        return result;
    }

    public SDD leftRotation(VtreeNode nodeWhereLeftRotationIsPerformed) {
        Vtree left = nodeWhereLeftRotationIsPerformed.getLeft();
        Vtree right = nodeWhereLeftRotationIsPerformed.getRight();
        if (left.isLeaf()) {
            return this;
        }
        VtreeNode leftNode = (VtreeNode)left;
        Vtree lleft = leftNode.getLeft();
        Vtree lright = leftNode.getRight();
        VtreeNode newRight = VtreeNode.create(lright, right);
        VtreeNode newTree = VtreeNode.create(lleft, newRight);
        newRight.unwatch();
        SDDMemory mem = new SDDMemory();
        VtreePath path = new VtreePath(this._tree, nodeWhereLeftRotationIsPerformed);
        SDDTree resultSDDTree = LeftRotation.leftRotation(this._sdd, mem, path);
        SDD result = SDD.create(resultSDDTree, newTree);
        newTree.unwatch();
        resultSDDTree.unwatch();
        mem.empty();
        return result;
    }

    public SDD swapVnodeOnRoot() {
        SDD result;
        VtreeNode tree = (VtreeNode)this._tree;
        Vtree a = tree.getLeft();
        Vtree b = tree.getRight();
        VtreeNode newTree = VtreeNode.create(b, a);
        if (this._sdd.isDisjunction()) {
            SDDTreeDisjunction disj = this._sdd.getDisjunction();
            SDDMemory mem = new SDDMemory();
            SDDTree newSDD = Swap.swapVnodeOnCurrentNode(mem, disj);
            result = SDD.create(newSDD, newTree);
            newSDD.unwatch();
            mem.empty();
        } else {
            SDDConstant con = this._sdd.getConstant();
            result = SDD.create(con, newTree);
        }
        newTree.unwatch();
        return result;
    }

    public List<Assignment> getAssignments() {
        return this._sdd.getAssignmentList(this._tree);
    }

    public Assignment getOneAssignment() {
        return this._sdd.getOneAssignment(this._tree);
    }

    public boolean isConstant() {
        return this._sdd.isConstant();
    }

    public int size() {
        HashSet<CanonicalWatched> set = new HashSet<CanonicalWatched>();
        this._sdd.insertSubSDDTrees(set);
        return set.size();
    }

    public boolean isValid() {
        return this._sdd.isTrue();
    }

    public boolean isSat() {
        return !this._sdd.isFalse();
    }

    public BigInteger nbModels() {
        HashMap<SDDTreeDisjunction, BigInteger> records = new HashMap<SDDTreeDisjunction, BigInteger>();
        BigInteger result = this._sdd.nbModels(this._tree, records);
        records.clear();
        return result;
    }

    public <X> X apply(SDDFunction<X> f) {
        HashMap m = new HashMap();
        X result = this._sdd.apply(f, this._tree, m);
        m.clear();
        return result;
    }
}

