/*
 * Decompiled with CFR 0.152.
 */
package sdd;

import buffer.CanonicalWatched;
import java.io.PrintStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sdd.Assignment;
import sdd.SDDFunction;
import sdd.SDDTree;
import sdd.SDDTreeConjunction;
import sdd.SDDTreeDisjunction;
import sdd.SDDVariable;
import sdd.Variable;
import sdd.Vtree;
import util.DotStream;
import util.NameGenerator;

public final class SDDConstant
extends SDDTree {
    private final boolean _constant;
    private static final Map<Object, SDDConstant> BUFFER = new HashMap<Object, SDDConstant>();
    private static final SDDConstant TRUE = SDDConstant.create(true);
    private static final SDDConstant FALSE = SDDConstant.create(false);

    private SDDConstant(boolean b) {
        this._constant = b;
    }

    private static SDDConstant create(boolean b) {
        SDDConstant newConstant = new SDDConstant(b);
        SDDConstant canon = (SDDConstant)newConstant.getCanonical();
        canon.watch();
        return canon;
    }

    public static SDDConstant getTrue() {
        TRUE.watch();
        return TRUE;
    }

    public static SDDConstant getFalse() {
        FALSE.watch();
        return FALSE;
    }

    public static SDDConstant get(boolean b) {
        if (b) {
            return SDDConstant.getTrue();
        }
        return SDDConstant.getFalse();
    }

    @Override
    public int hashCode() {
        return this._constant ? -1 : -2;
    }

    @Override
    protected boolean equivalent(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SDDConstant)) {
            return false;
        }
        SDDConstant other = (SDDConstant)obj;
        return this._constant == other._constant;
    }

    @Override
    public int saveToString(StringBuilder bui, Map<SDDTree, String> sddTrees, Map<SDDTreeConjunction, String> conjs, int counter) {
        String name = sddTrees.get(this);
        if (this._constant) {
            bui.append(name).append("=").append("TRUE;");
        } else {
            bui.append(name).append("=").append("FALSE;");
        }
        return counter;
    }

    @Override
    public void saveToDot(DotStream out, Map<SDDTree, String> sddTrees, Map<SDDTreeConjunction, String> conjs, NameGenerator gen) {
        String name = sddTrees.get(this);
        String val = this._constant ? "TRUE" : "FALSE";
        out.addNodeOption("label", val);
        out.defineNode(name);
    }

    protected Map<Object, SDDConstant> getBuffer() {
        return BUFFER;
    }

    @Override
    public boolean isConstant() {
        return true;
    }

    @Override
    public boolean isFalse() {
        return !this._constant;
    }

    @Override
    public SDDConstant getConstant() {
        return this;
    }

    @Override
    public boolean isLiteral() {
        return false;
    }

    @Override
    public SDDVariable getLiteral() {
        this.isNot("literal");
        return null;
    }

    @Override
    public boolean isDisjunction() {
        return false;
    }

    @Override
    public SDDTreeDisjunction getDisjunction() {
        this.isNot("disjunction");
        return null;
    }

    @Override
    public List<Assignment> getAssignmentList(Vtree tree) {
        List<Assignment> result = new ArrayList<Assignment>();
        if (!this._constant) {
            return result;
        }
        result.add(new Assignment());
        for (Variable var : tree.getVariables()) {
            ArrayList<Assignment> varAssignments = new ArrayList<Assignment>();
            varAssignments.add(new Assignment(var, true));
            varAssignments.add(new Assignment(var, false));
            result = Assignment.carthesianProduct(result, varAssignments);
        }
        return result;
    }

    @Override
    public Assignment getOneAssignment(Vtree tree) {
        if (!this._constant) {
            return null;
        }
        HashMap<Variable, Boolean> assignmentMap = new HashMap<Variable, Boolean>();
        for (Variable var : tree.getVariables()) {
            assignmentMap.put(var, true);
        }
        Assignment result = new Assignment(assignmentMap);
        return result;
    }

    public static void printBuffer(PrintStream out) {
        Collection<SDDConstant> set = BUFFER.values();
        Iterator<SDDConstant> it = set.iterator();
        if (it.hasNext()) {
            CanonicalWatched watched = it.next();
            watched.print(out);
        }
    }

    @Override
    public void insertSubSDDTrees(Set<CanonicalWatched> set) {
        set.add(this);
    }

    @Override
    public BigInteger nbModels(Vtree tree, Map<SDDTreeDisjunction, BigInteger> records) {
        Set<Variable> variables = tree.getVariables();
        int nbVariables = variables.size();
        BigInteger result = new BigInteger("2").pow(nbVariables);
        return result;
    }

    @Override
    public <X> X apply(SDDFunction<X> f, Vtree tree, Map<SDDTree, X> m) {
        Set<Variable> vars = tree.getVariables();
        if (this._constant) {
            return f.trueValue(vars);
        }
        return f.falseValue(vars);
    }
}

