/*
 * Decompiled with CFR 0.152.
 */
package sdd;

import java.util.HashMap;
import java.util.Map;
import sdd.SDDTree;
import sdd.SDDTreeDisjunction;
import util.Pair;

public class SDDMemory {
    private final Map<Pair<SDDTreeDisjunction, SDDTreeDisjunction>, SDDTree> _ands = new HashMap<Pair<SDDTreeDisjunction, SDDTreeDisjunction>, SDDTree>();
    private final Map<Pair<SDDTreeDisjunction, SDDTreeDisjunction>, SDDTree> _ors = new HashMap<Pair<SDDTreeDisjunction, SDDTreeDisjunction>, SDDTree>();
    private final Map<SDDTreeDisjunction, SDDTreeDisjunction> _nots = new HashMap<SDDTreeDisjunction, SDDTreeDisjunction>();
    private final Map<SDDTreeDisjunction, SDDTree> _exists = new HashMap<SDDTreeDisjunction, SDDTree>();
    private final Map<SDDTreeDisjunction, SDDTree> _foralls = new HashMap<SDDTreeDisjunction, SDDTree>();
    private final Map<SDDTreeDisjunction, SDDTree> _treeOperations = new HashMap<SDDTreeDisjunction, SDDTree>();

    private Pair<SDDTreeDisjunction, SDDTreeDisjunction> buildPair(SDDTreeDisjunction t1, SDDTreeDisjunction t2) {
        if (t1.compareTo(t2) < 0) {
            return new Pair<SDDTreeDisjunction, SDDTreeDisjunction>(t1, t2);
        }
        return new Pair<SDDTreeDisjunction, SDDTreeDisjunction>(t2, t1);
    }

    public SDDTree and(SDDTreeDisjunction t1, SDDTreeDisjunction t2) {
        Pair<SDDTreeDisjunction, SDDTreeDisjunction> pair = this.buildPair(t1, t2);
        SDDTree result = this._ands.get(pair);
        return result;
    }

    public void addAnd(SDDTreeDisjunction c1, SDDTreeDisjunction c2, SDDTree c) {
        c1.watch();
        c2.watch();
        c.watch();
        Pair<SDDTreeDisjunction, SDDTreeDisjunction> pair = this.buildPair(c1, c2);
        this._ands.put(pair, c);
    }

    public SDDTree or(SDDTreeDisjunction t1, SDDTreeDisjunction t2) {
        Pair<SDDTreeDisjunction, SDDTreeDisjunction> pair = this.buildPair(t1, t2);
        SDDTree result = this._ors.get(pair);
        return result;
    }

    public void addOr(SDDTreeDisjunction d1, SDDTreeDisjunction d2, SDDTree d) {
        d1.watch();
        d2.watch();
        d.watch();
        Pair<SDDTreeDisjunction, SDDTreeDisjunction> pair = this.buildPair(d1, d2);
        this._ors.put(pair, d);
    }

    public SDDTree not(SDDTreeDisjunction t) {
        SDDTree result = this._nots.get(t);
        return result;
    }

    public void addNot(SDDTreeDisjunction t, SDDTreeDisjunction n) {
        t.watch();
        n.watch();
        this._nots.put(t, n);
    }

    public SDDTree exists(SDDTreeDisjunction t) {
        SDDTree result = this._exists.get(t);
        return result;
    }

    public void addExists(SDDTreeDisjunction t, SDDTreeDisjunction e) {
        t.watch();
        e.watch();
        this._exists.put(t, e);
    }

    public SDDTree forall(SDDTreeDisjunction t) {
        SDDTree result = this._foralls.get(t);
        return result;
    }

    public void addForall(SDDTreeDisjunction t, SDDTreeDisjunction f) {
        t.watch();
        f.watch();
        this._foralls.put(t, f);
    }

    public SDDTree tree(SDDTreeDisjunction t) {
        SDDTree result = this._treeOperations.get(t);
        return result;
    }

    public void addTree(SDDTreeDisjunction t, SDDTreeDisjunction f) {
        t.watch();
        f.watch();
        this._treeOperations.put(t, f);
    }

    public void empty() {
        Pair<SDDTreeDisjunction, SDDTreeDisjunction> pair;
        for (Map.Entry<Pair<SDDTreeDisjunction, SDDTreeDisjunction>, SDDTree> entry : this._ands.entrySet()) {
            pair = entry.getKey();
            pair.first().unwatch();
            pair.second().unwatch();
            entry.getValue().unwatch();
        }
        this._ands.clear();
        for (Map.Entry<Pair<SDDTreeDisjunction, SDDTreeDisjunction>, SDDTree> entry : this._ors.entrySet()) {
            pair = entry.getKey();
            pair.first().unwatch();
            pair.second().unwatch();
            entry.getValue().unwatch();
        }
        this._ors.clear();
        for (Map.Entry entry : this._nots.entrySet()) {
            ((SDDTreeDisjunction)entry.getKey()).unwatch();
            ((SDDTreeDisjunction)entry.getValue()).unwatch();
        }
        this._nots.clear();
        for (Map.Entry entry : this._exists.entrySet()) {
            ((SDDTreeDisjunction)entry.getKey()).unwatch();
            entry.getValue().unwatch();
        }
        this._exists.clear();
        for (Map.Entry entry : this._foralls.entrySet()) {
            ((SDDTreeDisjunction)entry.getKey()).unwatch();
            entry.getValue().unwatch();
        }
        this._foralls.clear();
        for (Map.Entry entry : this._treeOperations.entrySet()) {
            ((SDDTreeDisjunction)entry.getKey()).unwatch();
            entry.getValue().unwatch();
        }
        this._treeOperations.clear();
    }
}

