/*
 * Decompiled with CFR 0.152.
 */
package sdd;

import java.util.Collection;
import java.util.Map;
import sdd.SDDFunction;
import sdd.Variable;

public class SDDProbabilityFunction
implements SDDFunction<Double> {
    private final Map<Variable, Double> _apriori;

    public SDDProbabilityFunction(Map<Variable, Double> apriori) {
        this._apriori = apriori;
    }

    @Override
    public Double trueValue(Collection<Variable> vars) {
        return 1.0;
    }

    @Override
    public Double falseValue(Collection<Variable> vars) {
        return 0.0;
    }

    @Override
    public Double positiveLiteralValue(Variable var) {
        return this._apriori.get(var);
    }

    @Override
    public Double negativeLiteralValue(Variable var) {
        return 1.0 - this.positiveLiteralValue(var);
    }

    @Override
    public Double conjunctionValue(Double primeX, Double subX) {
        return primeX * subX;
    }

    @Override
    public Double disjunctionValue(Collection<Double> xs) {
        double result = 0.0;
        for (Double x : xs) {
            result += x.doubleValue();
        }
        return result;
    }
}

