/*
 * Decompiled with CFR 0.152.
 */
package sdd;

import buffer.CanonicalWatched;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sdd.Assignment;
import sdd.SDDConstant;
import sdd.SDDFunction;
import sdd.SDDTreeConjunction;
import sdd.SDDTreeDisjunction;
import sdd.SDDTrees;
import sdd.SDDVariable;
import sdd.Variable;
import sdd.Vtree;
import sdd.VtreeLeaf;
import sdd.VtreeNode;
import util.DotStream;
import util.NameGenerator;

public abstract class SDDTree
extends CanonicalWatched
implements Comparable<SDDTree> {
    protected final String CONSTANT_TYPE = "constant";
    protected final String DISJUNCTION_TYPE = "disjunction";
    protected final String LITERAL_TYPE = "literal";

    public abstract boolean isConstant();

    public abstract boolean isFalse();

    public final boolean isTrue() {
        return this.isConstant() && !this.isFalse();
    }

    public abstract SDDConstant getConstant();

    public abstract boolean isLiteral();

    public abstract SDDVariable getLiteral();

    public abstract boolean isDisjunction();

    public abstract SDDTreeDisjunction getDisjunction();

    protected void isNot(String type) {
        throw new UnsupportedOperationException("Is not a " + type + ": " + this);
    }

    public abstract List<Assignment> getAssignmentList(Vtree var1);

    public abstract Assignment getOneAssignment(Vtree var1);

    public abstract BigInteger nbModels(Vtree var1, Map<SDDTreeDisjunction, BigInteger> var2);

    public abstract void insertSubSDDTrees(Set<CanonicalWatched> var1);

    public abstract int saveToString(StringBuilder var1, Map<SDDTree, String> var2, Map<SDDTreeConjunction, String> var3, int var4);

    public abstract void saveToDot(DotStream var1, Map<SDDTree, String> var2, Map<SDDTreeConjunction, String> var3, NameGenerator var4);

    @Override
    public int compareTo(SDDTree t) {
        return SDDTrees.compare(this, t);
    }

    public static void DEBUG_VERIFY_VTREE(Vtree tree, SDDTree sdd) {
        if (sdd.isConstant()) {
            return;
        }
        if (tree.isLeaf()) {
            if (!sdd.isLiteral()) {
                System.err.println("!!! " + tree);
                System.err.println("!!! " + sdd);
                throw new IllegalStateException();
            }
            SDDVariable lit = sdd.getLiteral();
            Variable var = lit.getVariable();
            VtreeLeaf leaf = (VtreeLeaf)tree;
            if (leaf.getVariable() != var) {
                System.err.println("!!! " + tree);
                System.err.println("!!! " + sdd);
                throw new IllegalStateException();
            }
            return;
        }
        SDDTreeDisjunction disj = sdd.getDisjunction();
        VtreeNode node = (VtreeNode)tree;
        Vtree primeTree = node.getLeft();
        Vtree subTree = node.getRight();
        for (SDDTreeConjunction con : disj.getDisjuncts()) {
            SDDTree prime = con.getPrime();
            SDDTree sub = con.getSub();
            SDDTree.DEBUG_VERIFY_VTREE(primeTree, prime);
            SDDTree.DEBUG_VERIFY_VTREE(subTree, sub);
        }
    }

    public abstract <X> X apply(SDDFunction<X> var1, Vtree var2, Map<SDDTree, X> var3);
}

