/*
 * Decompiled with CFR 0.152.
 */
package sdd;

import buffer.CanonicalWatched;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import sdd.SDDTree;
import util.DotStream;
import util.NameGenerator;
import util.Pair;

public final class SDDTreeConjunction
extends CanonicalWatched
implements Comparable<SDDTreeConjunction> {
    private final SDDTree _prime;
    private final SDDTree _sub;
    private final int _hashcode;
    private static final Map<Object, SDDTreeConjunction> BUFFER = new HashMap<Object, SDDTreeConjunction>();

    private SDDTreeConjunction(SDDTree prime, SDDTree sub) {
        if (prime.isFalse()) {
            throw new IllegalArgumentException();
        }
        this._prime = prime;
        this._sub = sub;
        this._hashcode = this.computeHashCode();
    }

    public static SDDTreeConjunction create(SDDTree prime, SDDTree sub) {
        SDDTreeConjunction newNode = new SDDTreeConjunction(prime, sub);
        SDDTreeConjunction canon = (SDDTreeConjunction)newNode.getCanonical();
        if (newNode == canon) {
            prime.watch();
            sub.watch();
        }
        canon.watch();
        return canon;
    }

    @Override
    public int hashCode() {
        return this._hashcode;
    }

    private int computeHashCode() {
        return Pair.hashCode(this._prime, this._sub);
    }

    @Override
    protected boolean equivalent(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SDDTreeConjunction)) {
            return false;
        }
        SDDTreeConjunction other = (SDDTreeConjunction)obj;
        if (other._prime != this._prime) {
            return false;
        }
        return other._sub == this._sub;
    }

    protected Map<Object, SDDTreeConjunction> getBuffer() {
        return BUFFER;
    }

    @Override
    protected void destroy() {
        this._prime.unwatch();
        this._sub.unwatch();
    }

    public String toString() {
        return "Conj@" + this._hashcode + ": <" + this._prime.hashCode() + "," + this._sub.hashCode() + ">";
    }

    public int saveToString(StringBuilder bui, Map<SDDTree, String> sddTrees, Map<SDDTreeConjunction, String> conjs, int counter) {
        SDDTree[] trees;
        ArrayList<SDDTree> todo = new ArrayList<SDDTree>();
        for (SDDTree sddTree : trees = new SDDTree[]{this._prime, this._sub}) {
            if (sddTrees.containsKey(sddTree)) continue;
            String name = "N_" + counter;
            ++counter;
            sddTrees.put(sddTree, name);
            todo.add(sddTree);
        }
        String name = conjs.get(this);
        bui.append(name).append("=");
        bui.append(sddTrees.get(this._prime));
        bui.append("/\\");
        bui.append(sddTrees.get(this._sub));
        bui.append(";");
        int result = counter;
        for (SDDTree sddTree : todo) {
            result = sddTree.saveToString(bui, sddTrees, conjs, result);
        }
        return result;
    }

    public void saveToDot(DotStream out, Map<SDDTree, String> sddTrees, Map<SDDTreeConjunction, String> conjs, NameGenerator gen) {
        SDDTree[] trees;
        ArrayList<SDDTree> todo = new ArrayList<SDDTree>();
        for (SDDTree sddTree : trees = new SDDTree[]{this._prime, this._sub}) {
            if (sddTrees.containsKey(sddTree)) continue;
            String name = gen.generateName();
            sddTrees.put(sddTree, name);
            todo.add(sddTree);
        }
        String name = conjs.get(this);
        out.addNodeOption("shape", "box");
        out.defineNode(name);
        String preName = sddTrees.get(this._prime);
        out.addEdgeOption("color", "blue");
        out.defineEdge(name, preName);
        String effName = sddTrees.get(this._sub);
        out.addEdgeOption("color", "red");
        out.defineEdge(name, effName);
        for (SDDTree sddTree : todo) {
            sddTree.saveToDot(out, sddTrees, conjs, gen);
        }
    }

    public SDDTree getPrime() {
        return this._prime;
    }

    public SDDTree getSub() {
        return this._sub;
    }

    public static void printBuffer(PrintStream out) {
        block0: {
            Iterator<Map.Entry<Object, SDDTreeConjunction>> i$ = BUFFER.entrySet().iterator();
            if (!i$.hasNext()) break block0;
            Map.Entry<Object, SDDTreeConjunction> ent = i$.next();
            CanonicalWatched watched = ent.getValue();
            watched.print(out);
        }
    }

    @Override
    public int compareTo(SDDTreeConjunction t) {
        if (this == t) {
            return 0;
        }
        int result = this._prime.compareTo(t._prime);
        if (result != 0) {
            return result;
        }
        return this._sub.compareTo(t._sub);
    }
}

