/*
 * Decompiled with CFR 0.152.
 */
package sdd;

import buffer.CanonicalWatched;
import java.io.PrintStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sdd.Assignment;
import sdd.SDDConstant;
import sdd.SDDFunction;
import sdd.SDDTree;
import sdd.SDDTreeConjunction;
import sdd.SDDVariable;
import sdd.Vtree;
import sdd.VtreeNode;
import util.DotStream;
import util.NameGenerator;

public final class SDDTreeDisjunction
extends SDDTree {
    private final Set<SDDTreeConjunction> _disjuncts;
    private final int _hashCode;
    private static final Map<Object, SDDTreeDisjunction> BUFFER = new HashMap<Object, SDDTreeDisjunction>();

    private SDDTreeDisjunction(Set<SDDTreeConjunction> disjuncts) {
        SDDTreeConjunction conj;
        if (disjuncts.size() == 1 && (conj = disjuncts.iterator().next()).getSub().isFalse()) {
            throw new Error("This Disjunction should be replaced by FALSE");
        }
        this._disjuncts = Collections.unmodifiableSet(disjuncts);
        this._hashCode = this.computeHashCode();
    }

    public static SDDTreeDisjunction create(Set<SDDTreeConjunction> conjuncts) {
        SDDTreeDisjunction newNode = new SDDTreeDisjunction(conjuncts);
        SDDTreeDisjunction canon = (SDDTreeDisjunction)newNode.getCanonical();
        if (newNode == canon) {
            for (SDDTreeConjunction c : conjuncts) {
                c.watch();
            }
        }
        canon.watch();
        return canon;
    }

    @Override
    public int hashCode() {
        return this._hashCode;
    }

    public String toString() {
        StringBuilder bui = new StringBuilder();
        bui.append("Disj@").append(this.hashCode());
        bui.append(": {");
        Iterator<SDDTreeConjunction> it = this._disjuncts.iterator();
        while (it.hasNext()) {
            bui.append(it.next().hashCode());
            if (!it.hasNext()) continue;
            bui.append("; ");
        }
        bui.append("}");
        return bui.toString();
    }

    private int computeHashCode() {
        return this._disjuncts.hashCode();
    }

    @Override
    protected boolean equivalent(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SDDTreeDisjunction)) {
            return false;
        }
        SDDTreeDisjunction other = (SDDTreeDisjunction)obj;
        return other._disjuncts.equals(this._disjuncts);
    }

    @Override
    public void destroy() {
        CanonicalWatched.unwatchAll(this._disjuncts);
    }

    protected Map<Object, SDDTreeDisjunction> getBuffer() {
        return BUFFER;
    }

    public Collection<SDDTreeConjunction> getDisjuncts() {
        return this._disjuncts;
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    @Override
    public boolean isFalse() {
        return false;
    }

    @Override
    public SDDConstant getConstant() {
        this.isNot("constant");
        return null;
    }

    @Override
    public boolean isLiteral() {
        return false;
    }

    @Override
    public SDDVariable getLiteral() {
        this.isNot("literal");
        return null;
    }

    @Override
    public boolean isDisjunction() {
        return true;
    }

    @Override
    public SDDTreeDisjunction getDisjunction() {
        return this;
    }

    @Override
    public int saveToString(StringBuilder bui, Map<SDDTree, String> sddTrees, Map<SDDTreeConjunction, String> conjs, int counter) {
        ArrayList<SDDTreeConjunction> todo = new ArrayList<SDDTreeConjunction>();
        ArrayList<String> names = new ArrayList<String>();
        for (SDDTreeConjunction conj : this._disjuncts) {
            if (!conjs.containsKey(conj)) {
                String name = "N_" + counter;
                ++counter;
                conjs.put(conj, name);
                todo.add(conj);
            }
            names.add(conjs.get(conj));
        }
        String name = sddTrees.get(this);
        bui.append(name).append("=");
        bui.append(names);
        bui.append(";");
        int result = counter;
        for (SDDTreeConjunction sddTree : todo) {
            result = sddTree.saveToString(bui, sddTrees, conjs, result);
        }
        return result;
    }

    @Override
    public void saveToDot(DotStream out, Map<SDDTree, String> sddTrees, Map<SDDTreeConjunction, String> conjs, NameGenerator gen) {
        ArrayList<SDDTreeConjunction> todo = new ArrayList<SDDTreeConjunction>();
        ArrayList<String> names = new ArrayList<String>();
        for (SDDTreeConjunction conj : this._disjuncts) {
            if (!conjs.containsKey(conj)) {
                String name = gen.generateName();
                conjs.put(conj, name);
                todo.add(conj);
            }
            names.add(conjs.get(conj));
        }
        String name = sddTrees.get(this);
        for (String child : names) {
            out.defineEdge(name, child);
        }
        for (SDDTreeConjunction sddTree : todo) {
            sddTree.saveToDot(out, sddTrees, conjs, gen);
        }
    }

    @Override
    public List<Assignment> getAssignmentList(Vtree tree) {
        VtreeNode nTree = (VtreeNode)tree;
        ArrayList<Assignment> result = new ArrayList<Assignment>();
        Vtree tp = nTree.getLeft();
        Vtree ts = nTree.getRight();
        for (SDDTreeConjunction conj : this._disjuncts) {
            SDDTree p = conj.getPrime();
            SDDTree s = conj.getSub();
            List<Assignment> listp = p.getAssignmentList(tp);
            List<Assignment> lists = s.getAssignmentList(ts);
            List<Assignment> cList = Assignment.carthesianProduct(listp, lists);
            result.addAll(cList);
        }
        return result;
    }

    @Override
    public Assignment getOneAssignment(Vtree tree) {
        VtreeNode node = (VtreeNode)tree;
        Vtree primeTree = node.getLeft();
        Vtree subTree = node.getRight();
        for (SDDTreeConjunction con : this._disjuncts) {
            SDDTree sub = con.getSub();
            Assignment subAss = sub.getOneAssignment(subTree);
            if (subAss == null) continue;
            SDDTree prime = con.getPrime();
            Assignment primeAss = prime.getOneAssignment(primeTree);
            Assignment result = new Assignment(primeAss, subAss);
            return result;
        }
        throw new Error("Could not find an assignment.  Please report bug.");
    }

    public int nbDisjuncts() {
        return this._disjuncts.size();
    }

    public static void printBuffer(PrintStream out) {
        block0: {
            Iterator<Map.Entry<Object, SDDTreeDisjunction>> i$ = BUFFER.entrySet().iterator();
            if (!i$.hasNext()) break block0;
            Map.Entry<Object, SDDTreeDisjunction> ent = i$.next();
            CanonicalWatched watched = ent.getValue();
            watched.print(out);
        }
    }

    @Override
    public void insertSubSDDTrees(Set<CanonicalWatched> set) {
        if (!set.add(this)) {
            return;
        }
        for (SDDTreeConjunction conj : this.getDisjuncts()) {
            if (!set.add(conj)) continue;
            conj.getPrime().insertSubSDDTrees(set);
            conj.getSub().insertSubSDDTrees(set);
        }
    }

    @Override
    public BigInteger nbModels(Vtree tree, Map<SDDTreeDisjunction, BigInteger> records) {
        BigInteger result = records.get(this);
        if (result != null) {
            return result;
        }
        VtreeNode nTree = (VtreeNode)tree;
        BigInteger result2 = new BigInteger("0");
        Vtree tp = nTree.getLeft();
        Vtree ts = nTree.getRight();
        for (SDDTreeConjunction conj : this._disjuncts) {
            SDDTree p = conj.getPrime();
            SDDTree s = conj.getSub();
            BigInteger nbP = p.nbModels(tp, records);
            BigInteger nbS = s.nbModels(ts, records);
            BigInteger local = nbP.multiply(nbS);
            result2 = result2.add(local);
        }
        records.put(this, result2);
        return result2;
    }

    @Override
    public <X> X apply(SDDFunction<X> f, Vtree tree, Map<SDDTree, X> m) {
        X result = m.get(this);
        if (result != null) {
            return result;
        }
        ArrayList<X> xs = new ArrayList<X>();
        VtreeNode node = (VtreeNode)tree;
        for (SDDTreeConjunction con : this._disjuncts) {
            SDDTree prime = con.getPrime();
            X primeX = prime.apply(f, node.getLeft(), m);
            SDDTree sub = con.getSub();
            X subX = sub.apply(f, tree, m);
            X x = f.conjunctionValue(primeX, subX);
            xs.add(x);
        }
        X result2 = f.disjunctionValue(xs);
        return result2;
    }
}

