/*
 * Decompiled with CFR 0.152.
 */
package sdd;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import sdd.SDDMemory;
import sdd.SDDTree;
import sdd.SDDTreeConjunction;
import sdd.SDDTreeDisjunction;
import sdd.SDDTrees;

public class SDDTreeDisjunctionConstructor {
    private final SDDMemory _mem;
    private final Map<SDDTree, SDDTree> _subToPrime;

    public SDDTreeDisjunctionConstructor(SDDMemory mem) {
        this._mem = mem;
        this._subToPrime = new HashMap<SDDTree, SDDTree>();
    }

    public void add(SDDTree prime, SDDTree sub) {
        if (prime.isFalse()) {
            return;
        }
        SDDTree oldPrime = this._subToPrime.get(sub);
        if (oldPrime != null) {
            SDDTree newPrime = SDDTrees.or(prime, oldPrime, this._mem);
            oldPrime.unwatch();
            this._subToPrime.put(sub, newPrime);
            return;
        }
        prime.watch();
        sub.watch();
        this._subToPrime.put(sub, prime);
    }

    public SDDTree get() {
        SDDTree sub;
        SDDTree result = null;
        if (this._subToPrime.size() == 1 && (sub = this._subToPrime.keySet().iterator().next()).isConstant()) {
            SDDTree prime = this._subToPrime.get(sub);
            prime.unwatch();
            result = sub;
        }
        if (result == null) {
            HashSet<SDDTreeConjunction> conjs = new HashSet<SDDTreeConjunction>();
            for (Map.Entry<SDDTree, SDDTree> element : this._subToPrime.entrySet()) {
                SDDTree prime = element.getValue();
                SDDTree sub2 = element.getKey();
                SDDTreeConjunction conj = SDDTreeConjunction.create(prime, sub2);
                prime.unwatch();
                sub2.unwatch();
                conjs.add(conj);
            }
            result = SDDTreeDisjunction.create(conjs);
            for (SDDTreeConjunction conj : conjs) {
                conj.unwatch();
            }
        }
        return result;
    }
}

