/*
 * Decompiled with CFR 0.152.
 */
package sdd;

import buffer.CanonicalWatched;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import sdd.SDDConstant;
import sdd.SDDMemory;
import sdd.SDDTree;
import sdd.SDDTreeConjunction;
import sdd.SDDTreeDisjunction;
import sdd.SDDTreeDisjunctionConstructor;
import sdd.SDDVariable;
import sdd.Variable;
import sdd.VtreePath;

public class SDDTrees {
    public static SDDTree and(SDDTree tr1, SDDTree tr2, SDDMemory mem) {
        return SDDTrees.ban_and(tr1, tr2, mem);
    }

    private static SDDTree ban_andConstant(SDDConstant tr1, SDDTree tr2) {
        if (tr1.isTrue()) {
            tr2.watch();
            return tr2;
        }
        tr1.watch();
        return tr1;
    }

    public static SDDTree ban_and(SDDTree tr1, SDDTree tr2, SDDMemory mem) {
        if (tr1 == tr2) {
            tr1.watch();
            return tr1;
        }
        if (tr1.isConstant()) {
            SDDConstant cons = tr1.getConstant();
            return SDDTrees.ban_andConstant(cons, tr2);
        }
        if (tr2.isConstant()) {
            SDDConstant cons = tr2.getConstant();
            return SDDTrees.ban_andConstant(cons, tr1);
        }
        if (tr1.isLiteral() && tr2.isLiteral()) {
            return SDDConstant.getFalse();
        }
        if (tr1.isDisjunction() && tr2.isDisjunction()) {
            SDDTreeDisjunction d1 = tr1.getDisjunction();
            SDDTreeDisjunction d2 = tr2.getDisjunction();
            return SDDTrees.ban_andDisjunctions(d1, d2, mem);
        }
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private static SDDTree ban_andDisjunctions(SDDTreeDisjunction sdd1, SDDTreeDisjunction sdd2, SDDMemory mem) {
        SDDTree result = mem.and(sdd1, sdd2);
        if (result != null) {
            result.watch();
            return result;
        }
        SDDTreeDisjunctionConstructor con = new SDDTreeDisjunctionConstructor(mem);
        for (SDDTreeConjunction c1 : sdd1.getDisjuncts()) {
            for (SDDTreeConjunction c2 : sdd2.getDisjuncts()) {
                SDDTree prime2;
                SDDTree prime1 = c1.getPrime();
                SDDTree prime = SDDTrees.and(prime1, prime2 = c2.getPrime(), mem);
                if (prime.isFalse()) {
                    prime.unwatch();
                    continue;
                }
                SDDTree sub1 = c1.getSub();
                SDDTree sub2 = c2.getSub();
                SDDTree sub = SDDTrees.and(sub1, sub2, mem);
                con.add(prime, sub);
                prime.unwatch();
                sub.unwatch();
            }
        }
        SDDTree result2 = con.get();
        mem.addAnd(sdd1, sdd2, result2);
        return result2;
    }

    public static SDDTree or(SDDTree tr1, SDDTree tr2, SDDMemory mem) {
        return SDDTrees.ban_or(tr1, tr2, mem);
    }

    private static SDDTree ban_orConstant(SDDConstant tr1, SDDTree tr2) {
        if (tr1.isTrue()) {
            tr1.watch();
            return tr1;
        }
        tr2.watch();
        return tr2;
    }

    public static SDDTree ban_or(SDDTree tr1, SDDTree tr2, SDDMemory mem) {
        if (tr1 == tr2) {
            tr1.watch();
            return tr1;
        }
        if (tr1.isConstant()) {
            SDDConstant cons = tr1.getConstant();
            return SDDTrees.ban_orConstant(cons, tr2);
        }
        if (tr2.isConstant()) {
            SDDConstant cons = tr2.getConstant();
            return SDDTrees.ban_orConstant(cons, tr1);
        }
        if (tr1.isLiteral() && tr2.isLiteral()) {
            return SDDConstant.getTrue();
        }
        if (tr1.isDisjunction() && tr2.isDisjunction()) {
            SDDTreeDisjunction d1 = tr1.getDisjunction();
            SDDTreeDisjunction d2 = tr2.getDisjunction();
            return SDDTrees.ban_orDisjunctions(d1, d2, mem);
        }
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private static SDDTree ban_orDisjunctions(SDDTreeDisjunction sdd1, SDDTreeDisjunction sdd2, SDDMemory mem) {
        SDDTree result = mem.or(sdd1, sdd2);
        if (result != null) {
            result.watch();
            return result;
        }
        SDDTreeDisjunctionConstructor con = new SDDTreeDisjunctionConstructor(mem);
        for (SDDTreeConjunction c1 : sdd1.getDisjuncts()) {
            for (SDDTreeConjunction c2 : sdd2.getDisjuncts()) {
                SDDTree prime2;
                SDDTree prime1 = c1.getPrime();
                SDDTree prime = SDDTrees.and(prime1, prime2 = c2.getPrime(), mem);
                if (prime.isFalse()) {
                    prime.unwatch();
                    continue;
                }
                SDDTree sub1 = c1.getSub();
                SDDTree sub2 = c2.getSub();
                SDDTree sub = SDDTrees.or(sub1, sub2, mem);
                con.add(prime, sub);
                prime.unwatch();
                sub.unwatch();
            }
        }
        SDDTree result2 = con.get();
        mem.addOr(sdd1, sdd2, result2);
        return result2;
    }

    public static SDDTree not(SDDTree sdd, SDDMemory mem) {
        return SDDTrees.ban_not(sdd, mem);
    }

    private static SDDTree ban_notConstant(SDDConstant tr) {
        if (tr.isTrue()) {
            return SDDConstant.getFalse();
        }
        return SDDConstant.getTrue();
    }

    public static SDDTree ban_not(SDDTree sdd, SDDMemory mem) {
        if (sdd.isConstant()) {
            SDDConstant cons = sdd.getConstant();
            return SDDTrees.ban_notConstant(cons);
        }
        if (sdd.isLiteral()) {
            SDDVariable lit = sdd.getLiteral();
            return lit.not();
        }
        if (sdd.isDisjunction()) {
            SDDTreeDisjunction d = sdd.getDisjunction();
            return SDDTrees.ban_notDisjunction(d, mem);
        }
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    private static SDDTree ban_notDisjunction(SDDTreeDisjunction d, SDDMemory mem) {
        SDDTree result = mem.not(d);
        if (result != null) {
            result.watch();
            return result;
        }
        HashSet<SDDTreeConjunction> conjs = new HashSet<SDDTreeConjunction>();
        for (SDDTreeConjunction c : d.getDisjuncts()) {
            SDDTree prime = c.getPrime();
            SDDTree sub = c.getSub();
            SDDTree newSub = SDDTrees.not(sub, mem);
            SDDTreeConjunction newC = SDDTreeConjunction.create(prime, newSub);
            newSub.unwatch();
            conjs.add(newC);
        }
        SDDTreeDisjunction result2 = SDDTreeDisjunction.create(conjs);
        for (SDDTreeConjunction conj : conjs) {
            conj.unwatch();
        }
        mem.addNot(d, result2);
        return result2;
    }

    public static SDDTree exists(SDDTree sdd, Variable var, SDDMemory mem, VtreePath path) {
        return SDDTrees.ban_exists(sdd, var, mem, path);
    }

    public static SDDTree ban_exists(SDDTree sdd, Variable var, SDDMemory mem, VtreePath path) {
        if (sdd.isConstant()) {
            sdd.watch();
            return sdd;
        }
        if (sdd.isLiteral()) {
            SDDVariable lit = sdd.getLiteral();
            Variable sddVar = lit.getVariable();
            if (var.equals(sddVar)) {
                return SDDConstant.getTrue();
            }
            lit.watch();
            return lit;
        }
        if (sdd.isDisjunction()) {
            SDDTreeDisjunction d = sdd.getDisjunction();
            return SDDTrees.ban_existsDisjunction(d, var, mem, path);
        }
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    private static SDDTree ban_existsDisjunction(SDDTreeDisjunction sdd, Variable var, SDDMemory mem, VtreePath path) {
        SDDTree result = mem.exists(sdd);
        if (result != null) {
            return result;
        }
        boolean variableIsOnLeft = path.isDownLeft();
        path.down();
        if (variableIsOnLeft) {
            ArrayList<SDDTreeConjunction> unchangedConj = new ArrayList<SDDTreeConjunction>();
            ArrayList<SDDTreeConjunction> changedConj = new ArrayList<SDDTreeConjunction>();
            for (SDDTreeConjunction conj : sdd.getDisjuncts()) {
                SDDTree prime = conj.getPrime();
                SDDTree sub = conj.getSub();
                SDDTree newPrime = SDDTrees.exists(prime, var, mem, path);
                if (prime.equals(newPrime)) {
                    conj.watch();
                    unchangedConj.add(conj);
                } else {
                    SDDTreeConjunction newConj = SDDTreeConjunction.create(newPrime, sub);
                    changedConj.add(newConj);
                }
                newPrime.unwatch();
            }
            if (changedConj.isEmpty()) {
                CanonicalWatched.unwatchAll(unchangedConj);
                sdd.watch();
                path.up();
                return sdd;
            }
            SDDTreeDisjunctionConstructor con = new SDDTreeDisjunctionConstructor(mem);
            for (SDDTreeConjunction conj : unchangedConj) {
                con.add(conj.getPrime(), conj.getSub());
            }
            for (int index1 = 0; index1 < changedConj.size(); ++index1) {
                for (int index2 = index1 + 1; index2 < changedConj.size(); ++index2) {
                    SDDTreeConjunction conj1 = (SDDTreeConjunction)changedConj.get(index1);
                    if (conj1 == null) continue;
                    SDDTree prime1 = conj1.getPrime();
                    SDDTree sub1 = conj1.getSub();
                    SDDTreeConjunction conj2 = (SDDTreeConjunction)changedConj.get(index2);
                    if (conj2 == null) continue;
                    SDDTree prime2 = conj2.getPrime();
                    SDDTree sub2 = conj2.getSub();
                    SDDTree newPrime = SDDTrees.and(prime1, prime2, mem);
                    if (newPrime.isFalse()) {
                        newPrime.unwatch();
                        continue;
                    }
                    SDDTree newSub = SDDTrees.or(sub1, sub2, mem);
                    con.add(newPrime, newSub);
                    newSub.unwatch();
                    SDDTree negPrime2 = SDDTrees.not(prime2, mem);
                    SDDTree newPrime1 = SDDTrees.and(prime1, negPrime2, mem);
                    SDDTreeConjunction newConj = newPrime1.isFalse() ? null : SDDTreeConjunction.create(newPrime1, sub1);
                    changedConj.set(index1, newConj);
                    negPrime2.unwatch();
                    newPrime1.unwatch();
                    SDDTree negPrime1 = SDDTrees.not(prime1, mem);
                    SDDTree newPrime2 = SDDTrees.and(prime2, negPrime1, mem);
                    newConj = newPrime2.isFalse() ? null : SDDTreeConjunction.create(newPrime2, sub2);
                    changedConj.set(index2, newConj);
                    negPrime1.unwatch();
                    newPrime2.unwatch();
                    newPrime.unwatch();
                    conj1.unwatch();
                    conj2.unwatch();
                }
            }
            for (SDDTreeConjunction conj : changedConj) {
                if (conj == null) continue;
                SDDTree prime = conj.getPrime();
                SDDTree sub = conj.getSub();
                con.add(prime, sub);
            }
            CanonicalWatched.unwatchAll(unchangedConj);
            CanonicalWatched.unwatchAll(changedConj);
            SDDTree result2 = con.get();
            path.up();
            return result2;
        }
        SDDTreeDisjunctionConstructor con = new SDDTreeDisjunctionConstructor(mem);
        for (SDDTreeConjunction conj : sdd.getDisjuncts()) {
            SDDTree prime = conj.getPrime();
            SDDTree sub = conj.getSub();
            SDDTree newSub = SDDTrees.exists(sub, var, mem, path);
            con.add(prime, newSub);
            newSub.unwatch();
        }
        SDDTree result3 = con.get();
        path.up();
        return result3;
    }

    public static SDDTree forall(SDDTree sdd, Variable var, SDDMemory mem, VtreePath path) {
        return SDDTrees.ban_forall(sdd, var, mem, path);
    }

    public static SDDTree ban_forall(SDDTree sdd, Variable var, SDDMemory mem, VtreePath path) {
        if (sdd.isConstant()) {
            sdd.watch();
            return sdd;
        }
        if (sdd.isLiteral()) {
            SDDVariable lit = sdd.getLiteral();
            Variable sddVar = lit.getVariable();
            if (var.equals(sddVar)) {
                return SDDConstant.getFalse();
            }
            lit.watch();
            return lit;
        }
        if (sdd.isDisjunction()) {
            SDDTreeDisjunction d = sdd.getDisjunction();
            return SDDTrees.ban_forallDisjunction(d, var, mem, path);
        }
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    private static SDDTree ban_forallDisjunction(SDDTreeDisjunction sdd, Variable var, SDDMemory mem, VtreePath path) {
        SDDTree result;
        SDDTree result2 = mem.exists(sdd);
        if (result2 != null) {
            return result2;
        }
        boolean variableIsOnLeft = path.isDownLeft();
        path.down();
        if (variableIsOnLeft) {
            SDDTreeConjunction conj1;
            int i;
            ArrayList<SDDTreeConjunction> conjs = new ArrayList<SDDTreeConjunction>(sdd.getDisjuncts());
            SDDTree tmpResult = SDDConstant.getFalse();
            for (i = 0; i < conjs.size(); ++i) {
                conj1 = (SDDTreeConjunction)conjs.get(i);
                SDDTree prime = conj1.getPrime();
                SDDTree sub = conj1.getSub();
                SDDTree newPrime = SDDTrees.forall(prime, var, mem, path);
                SDDTree newSDD = SDDTrees.buildSimpleSDDNode(newPrime, sub, mem);
                SDDConstant oldTmpResult = tmpResult;
                tmpResult = SDDTrees.or(oldTmpResult, newSDD, mem);
                newPrime.unwatch();
                newSDD.unwatch();
                oldTmpResult.unwatch();
            }
            for (i = 0; i < conjs.size(); ++i) {
                conj1 = (SDDTreeConjunction)conjs.get(i);
                SDDTree prime1 = conj1.getPrime();
                SDDTree sub1 = conj1.getSub();
                for (int j = i + 1; j < conjs.size(); ++j) {
                    SDDTreeConjunction conj2 = (SDDTreeConjunction)conjs.get(j);
                    SDDTree prime2 = conj2.getPrime();
                    SDDTree sub2 = conj2.getSub();
                    SDDTree primeDisjunction = SDDTrees.or(prime1, prime2, mem);
                    SDDTree newSub = SDDTrees.and(sub1, sub2, mem);
                    SDDTree newPrime = SDDTrees.forall(primeDisjunction, var, mem, path);
                    SDDTree newSDD = SDDTrees.buildSimpleSDDNode(newPrime, newSub, mem);
                    SDDTree oldTmpResult = tmpResult;
                    tmpResult = SDDTrees.or(oldTmpResult, newSDD, mem);
                    primeDisjunction.unwatch();
                    newSub.unwatch();
                    newPrime.unwatch();
                    newSDD.unwatch();
                    oldTmpResult.unwatch();
                }
            }
            result = tmpResult;
        } else {
            SDDTreeDisjunctionConstructor con = new SDDTreeDisjunctionConstructor(mem);
            for (SDDTreeConjunction conj : sdd.getDisjuncts()) {
                SDDTree prime = conj.getPrime();
                SDDTree sub = conj.getSub();
                SDDTree newSub = SDDTrees.forall(sub, var, mem, path);
                con.add(prime, newSub);
                newSub.unwatch();
            }
            result = con.get();
        }
        path.up();
        return result;
    }

    public static SDDTree buildSimpleSDDNode(SDDTree prime, SDDTree sub, SDDMemory mem) {
        if (prime.isTrue() && sub.isConstant()) {
            sub.watch();
            return sub;
        }
        if (prime.isFalse()) {
            return SDDConstant.getFalse();
        }
        HashSet<SDDTreeConjunction> conjs = new HashSet<SDDTreeConjunction>();
        SDDTreeConjunction conj1 = SDDTreeConjunction.create(prime, sub);
        conjs.add(conj1);
        if (!prime.isTrue()) {
            SDDTree prime2 = SDDTrees.not(prime, mem);
            SDDConstant sub2 = SDDConstant.getFalse();
            SDDTreeConjunction conj2 = SDDTreeConjunction.create(prime2, sub2);
            conjs.add(conj2);
            prime2.unwatch();
            sub2.unwatch();
        }
        SDDTreeDisjunction result = SDDTreeDisjunction.create(conjs);
        CanonicalWatched.unwatchAll(conjs);
        return result;
    }

    public static int compare(SDDTree t1, SDDTree t2) {
        int nb2;
        boolean l2;
        int h2;
        if (t1 == t2) {
            return 0;
        }
        int h1 = t1.hashCode();
        if (h1 < (h2 = t2.hashCode())) {
            return -1;
        }
        if (h2 < h1) {
            return 1;
        }
        if (t1.isConstant()) {
            return -1;
        }
        if (t2.isConstant()) {
            return 1;
        }
        boolean l1 = t1.isLiteral();
        if (l1 != (l2 = t2.isLiteral())) {
            if (l1) {
                return -1;
            }
            return 1;
        }
        if (l1 && l2) {
            SDDVariable sv1 = t1.getLiteral();
            SDDVariable sv2 = t2.getLiteral();
            int comp = sv1.getVariable().compareTo(sv2.getVariable());
            if (comp != 0) {
                return comp;
            }
            if (sv1.getSign()) {
                return -1;
            }
            return 1;
        }
        SDDTreeDisjunction d1 = t1.getDisjunction();
        SDDTreeDisjunction d2 = t2.getDisjunction();
        int nb1 = d1.nbDisjuncts();
        if (nb1 < (nb2 = d2.nbDisjuncts())) {
            return -1;
        }
        if (nb1 > nb2) {
            return 1;
        }
        ArrayList<SDDTreeConjunction> l12 = new ArrayList<SDDTreeConjunction>();
        ArrayList<SDDTreeConjunction> l22 = new ArrayList<SDDTreeConjunction>();
        for (SDDTreeConjunction conj : d1.getDisjuncts()) {
            l12.add(conj);
        }
        for (SDDTreeConjunction conj : d2.getDisjuncts()) {
            l22.add(conj);
        }
        Collections.sort(l12);
        Collections.sort(l22);
        for (int index = 0; index < l12.size(); ++index) {
            SDDTreeConjunction c2;
            SDDTreeConjunction c1 = (SDDTreeConjunction)l12.get(index);
            int comparison = c1.compareTo(c2 = (SDDTreeConjunction)l22.get(index));
            if (comparison == 0) continue;
            return comparison;
        }
        throw new IllegalStateException("These SDDTrees seem to be equivalent.");
    }
}

