/*
 * Decompiled with CFR 0.152.
 */
package sdd;

import buffer.CanonicalWatched;
import java.io.PrintStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sdd.Assignment;
import sdd.SDDConstant;
import sdd.SDDFunction;
import sdd.SDDTree;
import sdd.SDDTreeConjunction;
import sdd.SDDTreeDisjunction;
import sdd.Variable;
import sdd.Vtree;
import util.DotStream;
import util.NameGenerator;
import util.Pair;

public final class SDDVariable
extends SDDTree {
    private final Variable _var;
    private final boolean _val;
    private static final Map<Object, SDDVariable> BUFFER = new HashMap<Object, SDDVariable>();

    private SDDVariable(Variable var, boolean val) {
        this._var = var;
        this._val = val;
    }

    public static SDDVariable create(Variable var, boolean val) {
        SDDVariable newVariable = new SDDVariable(var, val);
        SDDVariable canon = (SDDVariable)newVariable.getCanonical();
        canon.watch();
        return canon;
    }

    @Override
    public int hashCode() {
        return Pair.hashCode(this._var, this._val);
    }

    @Override
    protected boolean equivalent(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SDDVariable)) {
            return false;
        }
        SDDVariable other = (SDDVariable)obj;
        if (other._val != this._val) {
            return false;
        }
        return other._var == this._var;
    }

    @Override
    public int saveToString(StringBuilder bui, Map<SDDTree, String> sddTrees, Map<SDDTreeConjunction, String> conjs, int counter) {
        String name = sddTrees.get(this);
        bui.append(name).append("=");
        if (!this._val) {
            bui.append("!");
        }
        bui.append(this._var).append(";");
        return counter;
    }

    @Override
    public void saveToDot(DotStream out, Map<SDDTree, String> sddTrees, Map<SDDTreeConjunction, String> conjs, NameGenerator gen) {
        String label = this._val ? this._var.toString() : "!" + this._var.toString();
        out.addNodeOption("label", label);
        String name = sddTrees.get(this);
        out.defineNode(name);
    }

    @Override
    public void destroy() {
    }

    protected Map<Object, SDDVariable> getBuffer() {
        return BUFFER;
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    @Override
    public boolean isFalse() {
        return false;
    }

    @Override
    public SDDConstant getConstant() {
        this.isNot("constant");
        return null;
    }

    @Override
    public boolean isLiteral() {
        return true;
    }

    @Override
    public SDDVariable getLiteral() {
        return this;
    }

    @Override
    public boolean isDisjunction() {
        return false;
    }

    @Override
    public SDDTreeDisjunction getDisjunction() {
        this.isNot("disjunction");
        return null;
    }

    public String toString() {
        return "Var@" + this.hashCode() + "(" + (this._val ? "" : "-") + this._var + ")";
    }

    @Override
    public List<Assignment> getAssignmentList(Vtree tree) {
        ArrayList<Assignment> result = new ArrayList<Assignment>();
        result.add(new Assignment(this._var, this._val));
        return result;
    }

    @Override
    public Assignment getOneAssignment(Vtree tree) {
        Assignment result = new Assignment(this._var, this._val);
        return result;
    }

    public SDDVariable not() {
        return SDDVariable.create(this._var, !this._val);
    }

    public Variable getVariable() {
        return this._var;
    }

    public boolean getSign() {
        return this._val;
    }

    public static void printBuffer(PrintStream out) {
        block0: {
            Iterator<Map.Entry<Object, SDDVariable>> i$ = BUFFER.entrySet().iterator();
            if (!i$.hasNext()) break block0;
            Map.Entry<Object, SDDVariable> ent = i$.next();
            CanonicalWatched watched = ent.getValue();
            watched.print(out);
        }
    }

    @Override
    public void insertSubSDDTrees(Set<CanonicalWatched> set) {
        set.add(this);
    }

    @Override
    public BigInteger nbModels(Vtree tree, Map<SDDTreeDisjunction, BigInteger> records) {
        return new BigInteger("1");
    }

    @Override
    public <X> X apply(SDDFunction<X> f, Vtree tree, Map<SDDTree, X> m) {
        X result = m.get(this);
        if (result != null) {
            return result;
        }
        if (this._val) {
            return f.positiveLiteralValue(this._var);
        }
        return f.negativeLiteralValue(this._var);
    }
}

