/*
 * Decompiled with CFR 0.152.
 */
package sdd;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public final class Singleton<X>
implements Set<X> {
    private final X _element;
    public static final String UNMODIFIABLE_MESSAGE = "Not implemented (unmodifiable)";

    public Singleton(X x) {
        this._element = x;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean contains(Object o) {
        if (this._element == o) {
            return true;
        }
        if (this._element == null) {
            return false;
        }
        if (o == null) {
            return false;
        }
        return this._element.equals(o);
    }

    @Override
    public Iterator<X> iterator() {
        return new Iterator<X>(){
            boolean _elementWasRead = false;

            @Override
            public boolean hasNext() {
                return !this._elementWasRead;
            }

            @Override
            public X next() {
                if (this._elementWasRead) {
                    throw new NoSuchElementException();
                }
                this._elementWasRead = true;
                return Singleton.this._element;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException(Singleton.UNMODIFIABLE_MESSAGE);
            }
        };
    }

    @Override
    public Object[] toArray() {
        Object[] result = new Object[]{this._element};
        return result;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (a.length == 0) {
            return this.toArray();
        }
        a[0] = this._element;
        if (a.length > 1) {
            a[1] = null;
        }
        return a;
    }

    @Override
    public boolean add(X e) {
        throw new UnsupportedOperationException(UNMODIFIABLE_MESSAGE);
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException(UNMODIFIABLE_MESSAGE);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends X> c) {
        throw new UnsupportedOperationException(UNMODIFIABLE_MESSAGE);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException(UNMODIFIABLE_MESSAGE);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException(UNMODIFIABLE_MESSAGE);
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException(UNMODIFIABLE_MESSAGE);
    }
}

