/*
 * Decompiled with CFR 0.152.
 */
package sdd;

import buffer.CanonicalWatched;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sdd.Variable;
import sdd.Vtree;
import util.Pair;

public final class VtreeNode
extends Vtree {
    private final int _hashCode;
    private final Vtree _left;
    private final Vtree _right;
    private final int _depth;
    private static Map<Object, VtreeNode> BUFFER = new HashMap<Object, VtreeNode>();

    private VtreeNode(Vtree l, Vtree r) {
        this._left = l;
        this._right = r;
        this._hashCode = this.computeHashCode();
        this._depth = Math.max(l.getDepth(), r.getDepth()) + 1;
    }

    public static VtreeNode create(Vtree l, Vtree r) {
        VtreeNode newTree = new VtreeNode(l, r);
        VtreeNode canon = (VtreeNode)newTree.getCanonical();
        if (canon == newTree) {
            l.watch();
            r.watch();
        }
        canon.watch();
        return canon;
    }

    @Override
    public int hashCode() {
        return this._hashCode;
    }

    private int computeHashCode() {
        return Pair.hashCode(this._left, this._right);
    }

    @Override
    public boolean equivalent(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof VtreeNode)) {
            return false;
        }
        VtreeNode other = (VtreeNode)o;
        if (other._left != this._left) {
            return false;
        }
        return other._right == this._right;
    }

    public String toString() {
        return "<" + this._left + "," + this._right + ">";
    }

    @Override
    public Set<Variable> getVariables() {
        HashSet<Variable> result = new HashSet<Variable>();
        if (!this.addVariables(result)) {
            throw new IllegalStateException("Vtree " + this + " has same variable twice.");
        }
        return result;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public boolean addVariables(Set<Variable> s) {
        return this._left.addVariables(s) && this._right.addVariables(s);
    }

    public Vtree getLeft() {
        return this._left;
    }

    public Vtree getRight() {
        return this._right;
    }

    protected Map<Object, VtreeNode> getBuffer() {
        return BUFFER;
    }

    @Override
    protected void destroy() {
        this._left.unwatch();
        this._right.unwatch();
    }

    @Override
    public int getDepth() {
        return this._depth;
    }

    @Override
    public boolean contains(Vtree vt) {
        if (this == vt) {
            return true;
        }
        if (this.getDepth() <= vt.getDepth()) {
            return false;
        }
        if (this._left.contains(vt)) {
            return true;
        }
        return this._right.contains(vt);
    }

    @Override
    public boolean findPathTo(Vtree vt, List<VtreeNode> path) {
        if (this.getDepth() < vt.getDepth()) {
            return false;
        }
        if (vt != this && !this._left.findPathTo(vt, path) && !this._right.findPathTo(vt, path)) {
            return false;
        }
        path.add(this);
        return true;
    }

    public static void printBuffer(PrintStream out) {
        block0: {
            Iterator<Map.Entry<Object, VtreeNode>> i$ = BUFFER.entrySet().iterator();
            if (!i$.hasNext()) break block0;
            Map.Entry<Object, VtreeNode> ent = i$.next();
            CanonicalWatched watched = ent.getValue();
            watched.print(out);
        }
    }
}

