/*
 * Decompiled with CFR 0.152.
 */
package sdd;

import java.util.ArrayList;
import java.util.List;
import sdd.Vtree;
import sdd.VtreeLeaf;
import sdd.VtreeNode;

public class VtreePath {
    private final List<Vtree> _trees = new ArrayList<Vtree>();
    private int _pos = 0;

    public VtreePath(Vtree r, Vtree l) {
        if (!VtreePath.calculatePath(r, l, this._trees)) {
            throw new IllegalStateException("No path from root to leaf.");
        }
    }

    private static boolean calculatePath(Vtree r, Vtree l, List<Vtree> trees) {
        if (r.equals(l)) {
            trees.add(l);
            return true;
        }
        if (r instanceof VtreeLeaf) {
            return false;
        }
        VtreeNode n = (VtreeNode)r;
        if (VtreePath.calculatePath(n.getLeft(), l, trees) || VtreePath.calculatePath(n.getRight(), l, trees)) {
            trees.add(r);
            return true;
        }
        return false;
    }

    public void gotoRoot() {
        this._pos = this._trees.size() - 1;
    }

    public void gotoLeaf() {
        this._pos = 0;
    }

    public void up() {
        ++this._pos;
    }

    public void down() {
        --this._pos;
    }

    public boolean isAtRoot() {
        return this._pos == this._trees.size() - 1;
    }

    public boolean isAtLeaf() {
        return this._pos == 0;
    }

    public Vtree get() {
        return this._trees.get(this._pos);
    }

    public boolean isDownLeft() {
        VtreeNode current = (VtreeNode)this.get();
        this.down();
        Vtree down = this.get();
        this.up();
        return current.getLeft().equals(down);
    }

    public String toString() {
        return this._trees.toString();
    }
}

