/*
 * Decompiled with CFR 0.152.
 */
package sdd.ope;

import buffer.CanonicalWatched;
import java.util.HashSet;
import sdd.SDDMemory;
import sdd.SDDTree;
import sdd.SDDTreeConjunction;
import sdd.SDDTreeDisjunction;
import sdd.Vtree;
import sdd.VtreeNode;
import sdd.ope.VtreeOperation;

public class ChildrenOperation
implements VtreeOperation {
    private final VtreeOperation _primeOperation;
    private final VtreeOperation _subOperation;

    public ChildrenOperation(VtreeOperation op1, VtreeOperation op2) {
        this._primeOperation = op1;
        this._subOperation = op2;
    }

    @Override
    public boolean isApplicable(Vtree tree) {
        if (tree.isLeaf()) {
            return false;
        }
        VtreeNode node = (VtreeNode)tree;
        Vtree primeTree = node.getLeft();
        if (!this._primeOperation.isApplicable(primeTree)) {
            return false;
        }
        Vtree subTree = node.getRight();
        return this._subOperation.isApplicable(subTree);
    }

    @Override
    public Vtree apply(Vtree tree) {
        VtreeNode node = (VtreeNode)tree;
        Vtree primeTree = node.getLeft();
        Vtree newPrime = this._primeOperation.apply(primeTree);
        Vtree subTree = node.getRight();
        Vtree newSub = this._subOperation.apply(subTree);
        VtreeNode result = VtreeNode.create(newPrime, newSub);
        newPrime.unwatch();
        newSub.unwatch();
        return result;
    }

    @Override
    public SDDTree applyToSDD(SDDTree sdd, SDDMemory mem) {
        if (sdd.isConstant()) {
            sdd.watch();
            return sdd;
        }
        SDDTreeDisjunction disj = sdd.getDisjunction();
        HashSet<SDDTreeConjunction> newConjs = new HashSet<SDDTreeConjunction>();
        for (SDDTreeConjunction con : disj.getDisjuncts()) {
            SDDTree prime = con.getPrime();
            SDDTree newPrime = this._primeOperation.applyToSDD(prime, mem);
            SDDTree sub = con.getSub();
            SDDTree newSub = this._subOperation.applyToSDD(sub, mem);
            SDDTreeConjunction newCon = SDDTreeConjunction.create(newPrime, newSub);
            newConjs.add(newCon);
        }
        SDDTreeDisjunction result = SDDTreeDisjunction.create(newConjs);
        CanonicalWatched.unwatchAll(newConjs);
        return result;
    }
}

