/*
 * Decompiled with CFR 0.152.
 */
package sdd.ope;

import java.util.ArrayList;
import java.util.List;
import sdd.SDDMemory;
import sdd.SDDTree;
import sdd.Vtree;
import sdd.ope.VtreeOperation;

public class ConsecutiveOperations
implements VtreeOperation {
    private final List<VtreeOperation> _ops;

    public ConsecutiveOperations(List<VtreeOperation> ops) {
        this._ops = new ArrayList<VtreeOperation>(ops);
    }

    @Override
    public boolean isApplicable(Vtree tree) {
        Vtree currentTree = tree;
        currentTree.watch();
        for (VtreeOperation op : this._ops) {
            if (op.isApplicable(currentTree)) {
                currentTree.unwatch();
                return false;
            }
            Vtree newTree = op.apply(currentTree);
            currentTree.unwatch();
            currentTree = newTree;
        }
        currentTree.unwatch();
        return true;
    }

    @Override
    public Vtree apply(Vtree tree) {
        Vtree currentTree = tree;
        currentTree.watch();
        for (VtreeOperation op : this._ops) {
            Vtree newTree = op.apply(currentTree);
            currentTree.unwatch();
            currentTree = newTree;
        }
        return currentTree;
    }

    @Override
    public SDDTree applyToSDD(SDDTree sdd, SDDMemory mem) {
        SDDTree currentSDD = sdd;
        currentSDD.watch();
        for (VtreeOperation op : this._ops) {
            SDDTree newSDD = op.applyToSDD(currentSDD, mem);
            currentSDD.unwatch();
            currentSDD = newSDD;
        }
        return currentSDD;
    }
}

