/*
 * Decompiled with CFR 0.152.
 */
package sdd.ope;

import buffer.CanonicalWatched;
import java.util.HashSet;
import sdd.SDDConstant;
import sdd.SDDMemory;
import sdd.SDDTree;
import sdd.SDDTreeConjunction;
import sdd.SDDTreeDisjunction;
import sdd.SDDTrees;
import sdd.Vtree;
import sdd.VtreeNode;
import sdd.VtreePath;
import sdd.ope.VtreeOperation;

public class LeftRotation
implements VtreeOperation {
    @Override
    public boolean isApplicable(Vtree tree) {
        if (tree.isLeaf()) {
            return false;
        }
        VtreeNode node = (VtreeNode)tree;
        return !node.getLeft().isLeaf();
    }

    @Override
    public VtreeNode apply(Vtree tree) {
        VtreeNode node = (VtreeNode)tree;
        VtreeNode ab = (VtreeNode)node.getLeft();
        Vtree a = ab.getLeft();
        Vtree b = ab.getRight();
        Vtree c = node.getRight();
        VtreeNode bc = VtreeNode.create(b, c);
        VtreeNode result = VtreeNode.create(a, bc);
        bc.unwatch();
        return result;
    }

    public static SDDTree leftRotation(SDDTree sdd, SDDMemory mem, VtreePath path) {
        if (sdd.isConstant()) {
            sdd.watch();
            return sdd;
        }
        SDDTreeDisjunction disj = sdd.getDisjunction();
        SDDTree result = mem.tree(disj);
        if (result != null) {
            result.watch();
            return result;
        }
        if (path.isAtLeaf()) {
            return LeftRotation.leftRotationOnCurrentNode(mem, disj);
        }
        HashSet<SDDTreeConjunction> newSetOfConjunctions = new HashSet<SDDTreeConjunction>();
        if (path.isDownLeft()) {
            path.down();
            for (SDDTreeConjunction conj : disj.getDisjuncts()) {
                SDDTree prime = conj.getPrime();
                SDDTree sub = conj.getSub();
                SDDTree newPrime = LeftRotation.leftRotation(prime, mem, path);
                SDDTreeConjunction newConj = SDDTreeConjunction.create(newPrime, sub);
                newSetOfConjunctions.add(newConj);
                newPrime.unwatch();
            }
        } else {
            path.down();
            for (SDDTreeConjunction conj : disj.getDisjuncts()) {
                SDDTree prime = conj.getPrime();
                SDDTree sub = conj.getSub();
                SDDTree newSub = LeftRotation.leftRotation(sub, mem, path);
                SDDTreeConjunction newConj = SDDTreeConjunction.create(prime, newSub);
                newSetOfConjunctions.add(newConj);
                newSub.unwatch();
            }
        }
        path.up();
        SDDTreeDisjunction result2 = SDDTreeDisjunction.create(newSetOfConjunctions);
        CanonicalWatched.unwatchAll(newSetOfConjunctions);
        mem.addTree(disj, result2);
        return result2;
    }

    public static SDDTree leftRotationOnCurrentNode(SDDMemory mem, SDDTreeDisjunction sdd) {
        SDDTree result = SDDConstant.getFalse();
        for (SDDTreeConjunction conj : sdd.getDisjuncts()) {
            SDDTree p = conj.getPrime();
            SDDTree s = conj.getSub();
            if (p.isConstant()) {
                if (p.isTrue()) {
                    SDDConstant newP1 = SDDConstant.getTrue();
                    SDDConstant newSP1 = SDDConstant.getTrue();
                    SDDTreeConjunction sNewConj = SDDTreeConjunction.create(newSP1, s);
                    HashSet<SDDTreeConjunction> sNewConjuncts = new HashSet<SDDTreeConjunction>();
                    sNewConjuncts.add(sNewConj);
                    SDDTreeDisjunction newS1 = SDDTreeDisjunction.create(sNewConjuncts);
                    newSP1.unwatch();
                    sNewConj.unwatch();
                    SDDTreeConjunction newConj = SDDTreeConjunction.create(newP1, newS1);
                    HashSet<SDDTreeConjunction> newConjuncts = new HashSet<SDDTreeConjunction>();
                    newConjuncts.add(newConj);
                    SDDTreeDisjunction sddToAddToResult = SDDTreeDisjunction.create(newConjuncts);
                    newP1.unwatch();
                    newS1.unwatch();
                    newConj.unwatch();
                    SDDTree newResult = SDDTrees.or(result, sddToAddToResult, mem);
                    result.unwatch();
                    sddToAddToResult.unwatch();
                    result = newResult;
                    continue;
                }
                throw new IllegalStateException("A prime should not be false");
            }
            SDDTreeDisjunction pdisj = (SDDTreeDisjunction)p;
            for (SDDTreeConjunction pconj : pdisj.getDisjuncts()) {
                SDDTree pp = pconj.getPrime();
                SDDTree ps = pconj.getSub();
                if (ps.isFalse()) continue;
                SDDTree newP = pp;
                SDDTree newSP = ps;
                SDDTree newSS = s;
                SDDTree newS = SDDTrees.buildSimpleSDDNode(newSP, newSS, mem);
                SDDTree sddToAddToResult = SDDTrees.buildSimpleSDDNode(newP, newS, mem);
                SDDTree newResult = SDDTrees.or(result, sddToAddToResult, mem);
                result.unwatch();
                sddToAddToResult.unwatch();
                newS.unwatch();
                result = newResult;
            }
        }
        return result;
    }

    @Override
    public SDDTree applyToSDD(SDDTree sdd, SDDMemory mem) {
        if (sdd.isConstant()) {
            sdd.watch();
            return sdd;
        }
        SDDTreeDisjunction disj = (SDDTreeDisjunction)sdd;
        SDDTree result = LeftRotation.leftRotationOnCurrentNode(mem, disj);
        return result;
    }
}

