/*
 * Decompiled with CFR 0.152.
 */
package sdd.ope;

import buffer.CanonicalWatched;
import java.util.HashSet;
import sdd.SDDConstant;
import sdd.SDDMemory;
import sdd.SDDTree;
import sdd.SDDTreeConjunction;
import sdd.SDDTreeDisjunction;
import sdd.SDDTreeDisjunctionConstructor;
import sdd.SDDTrees;
import sdd.Vtree;
import sdd.VtreeNode;
import sdd.VtreePath;
import sdd.ope.VtreeOperation;

public class RightRotation
implements VtreeOperation {
    @Override
    public boolean isApplicable(Vtree tree) {
        if (tree.isLeaf()) {
            return false;
        }
        VtreeNode node = (VtreeNode)tree;
        return !node.getRight().isLeaf();
    }

    @Override
    public VtreeNode apply(Vtree tree) {
        VtreeNode node = (VtreeNode)tree;
        Vtree a = node.getLeft();
        VtreeNode bc = (VtreeNode)node.getRight();
        Vtree b = bc.getLeft();
        Vtree c = bc.getRight();
        VtreeNode ab = VtreeNode.create(a, b);
        VtreeNode result = VtreeNode.create(ab, c);
        ab.unwatch();
        return result;
    }

    public static SDDTree rightRotation(SDDTree sdd, SDDMemory mem, VtreePath path) {
        if (sdd.isConstant()) {
            sdd.watch();
            return sdd;
        }
        SDDTreeDisjunction disj = sdd.getDisjunction();
        SDDTree result = mem.tree(disj);
        if (result != null) {
            result.watch();
            return result;
        }
        if (path.isAtLeaf()) {
            return RightRotation.rightRotationOnCurrentNode(mem, disj);
        }
        HashSet<SDDTreeConjunction> newSetOfConjunctions = new HashSet<SDDTreeConjunction>();
        if (path.isDownLeft()) {
            path.down();
            for (SDDTreeConjunction conj : disj.getDisjuncts()) {
                SDDTree prime = conj.getPrime();
                SDDTree sub = conj.getSub();
                SDDTree newPrime = RightRotation.rightRotation(prime, mem, path);
                SDDTreeConjunction newConj = SDDTreeConjunction.create(newPrime, sub);
                newSetOfConjunctions.add(newConj);
                newPrime.unwatch();
            }
        } else {
            path.down();
            for (SDDTreeConjunction conj : disj.getDisjuncts()) {
                SDDTree prime = conj.getPrime();
                SDDTree sub = conj.getSub();
                SDDTree newSub = RightRotation.rightRotation(sub, mem, path);
                SDDTreeConjunction newConj = SDDTreeConjunction.create(prime, newSub);
                newSetOfConjunctions.add(newConj);
                newSub.unwatch();
            }
        }
        SDDTreeDisjunction result2 = SDDTreeDisjunction.create(newSetOfConjunctions);
        CanonicalWatched.unwatchAll(newSetOfConjunctions);
        mem.addTree(disj, result2);
        path.up();
        return result2;
    }

    public static SDDTree rightRotationOnCurrentNode(SDDMemory mem, SDDTreeDisjunction sdd) {
        SDDConstant sddTrue = SDDConstant.getTrue();
        SDDConstant sddFalse = SDDConstant.getFalse();
        SDDTreeDisjunctionConstructor con = new SDDTreeDisjunctionConstructor(mem);
        for (SDDTreeConjunction conj : sdd.getDisjuncts()) {
            SDDTree p = conj.getPrime();
            SDDTree pn = SDDTrees.not(p, mem);
            SDDTree s = conj.getSub();
            if (s.isConstant()) {
                SDDTreeDisjunctionConstructor localCon = new SDDTreeDisjunctionConstructor(mem);
                localCon.add(p, sddTrue);
                localCon.add(pn, sddFalse);
                SDDTree pAndTrue = localCon.get();
                con.add(pAndTrue, s);
                pAndTrue.unwatch();
                pn.unwatch();
                continue;
            }
            SDDTreeDisjunction sDisj = s.getDisjunction();
            for (SDDTreeConjunction sConj : sDisj.getDisjuncts()) {
                SDDTree b = sConj.getPrime();
                SDDTree c = sConj.getSub();
                SDDTreeDisjunctionConstructor localCon = new SDDTreeDisjunctionConstructor(mem);
                localCon.add(p, b);
                localCon.add(pn, sddFalse);
                SDDTree pAndB = localCon.get();
                con.add(pAndB, c);
                pAndB.unwatch();
            }
            pn.unwatch();
        }
        sddTrue.unwatch();
        sddFalse.unwatch();
        return con.get();
    }

    public static SDDTree rightRotationOnCurrentNode2(SDDMemory mem, SDDTreeDisjunction sdd) {
        SDDTree result = SDDConstant.getFalse();
        for (SDDTreeConjunction con : sdd.getDisjuncts()) {
            SDDTree p = con.getPrime();
            SDDTree s = con.getSub();
            if (s.isFalse()) continue;
            if (s.isTrue()) {
                SDDTree sp = s;
                SDDTree ss = s;
                SDDTree newP = SDDTrees.buildSimpleSDDNode(p, sp, mem);
                SDDTree newS = ss;
                SDDTree newSDD = SDDTrees.buildSimpleSDDNode(newP, newS, mem);
                SDDConstant old = result;
                result = SDDTrees.or(result, newSDD, mem);
                old.unwatch();
                newSDD.unwatch();
                newP.unwatch();
                continue;
            }
            SDDTreeDisjunction sDisj = s.getDisjunction();
            for (SDDTreeConjunction sCon : sDisj.getDisjuncts()) {
                SDDTree sp = sCon.getPrime();
                SDDTree ss = sCon.getSub();
                SDDTree newP = SDDTrees.buildSimpleSDDNode(p, sp, mem);
                SDDTree newS = ss;
                SDDTree newSDD = SDDTrees.buildSimpleSDDNode(newP, newS, mem);
                SDDTree old = result;
                result = SDDTrees.or(result, newSDD, mem);
                old.unwatch();
                newSDD.unwatch();
                newP.unwatch();
            }
        }
        return result;
    }

    @Override
    public SDDTree applyToSDD(SDDTree sdd, SDDMemory mem) {
        if (sdd.isConstant()) {
            sdd.watch();
            return sdd;
        }
        SDDTreeDisjunction disj = (SDDTreeDisjunction)sdd;
        SDDTree result = RightRotation.rightRotationOnCurrentNode(mem, disj);
        return result;
    }
}

