/*
 * Decompiled with CFR 0.152.
 */
package sdd.ope;

import sdd.SDDConstant;
import sdd.SDDMemory;
import sdd.SDDTree;
import sdd.SDDTreeConjunction;
import sdd.SDDTreeDisjunction;
import sdd.SDDTrees;
import sdd.Vtree;
import sdd.VtreeNode;
import sdd.ope.VtreeOperation;

public class Swap
implements VtreeOperation {
    @Override
    public boolean isApplicable(Vtree tree) {
        return !tree.isLeaf();
    }

    @Override
    public VtreeNode apply(Vtree tree) {
        VtreeNode node = (VtreeNode)tree;
        Vtree a = node.getLeft();
        Vtree b = node.getRight();
        VtreeNode result = VtreeNode.create(b, a);
        return result;
    }

    public static SDDTree swapVnodeOnCurrentNode(SDDMemory mem, SDDTreeDisjunction sdd) {
        SDDTree result = SDDConstant.getFalse();
        for (SDDTreeConjunction conj : sdd.getDisjuncts()) {
            SDDTree p = conj.getPrime();
            SDDTree s = conj.getSub();
            if (s.isFalse()) continue;
            SDDTree newP = s;
            SDDTree newS = p;
            SDDTree newSDD = SDDTrees.buildSimpleSDDNode(newP, newS, mem);
            SDDConstant old = result;
            result = SDDTrees.or(result, newSDD, mem);
            newSDD.unwatch();
            old.unwatch();
        }
        return result;
    }

    @Override
    public SDDTree applyToSDD(SDDTree sdd, SDDMemory mem) {
        if (sdd.isConstant()) {
            sdd.watch();
            return sdd;
        }
        SDDTreeDisjunction disj = (SDDTreeDisjunction)sdd;
        SDDTree result = Swap.swapVnodeOnCurrentNode(mem, disj);
        return result;
    }
}

