/*
 * Decompiled with CFR 0.152.
 */
package sdd.opt;

import buffer.CanonicalWatched;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import sdd.SDDTree;
import sdd.Vtree;
import sdd.opt.OptimisationProblem;

public class ExplicitOptimisationProblem
implements OptimisationProblem {
    private final Collection<SDDTree> _sdds;
    private final Vtree _tree;
    private Set<CanonicalWatched> _subnodes;

    public ExplicitOptimisationProblem(Collection<SDDTree> sdds, Vtree tree) {
        this._sdds = sdds;
        this._tree = tree;
        this._subnodes = null;
    }

    @Override
    public Collection<SDDTree> getSDDs() {
        return this._sdds;
    }

    @Override
    public Vtree getTree() {
        return this._tree;
    }

    @Override
    public int size() {
        this.computeSubnodes();
        return this._subnodes.size();
    }

    @Override
    public Set<CanonicalWatched> getSubnodes() {
        this.computeSubnodes();
        return this._subnodes;
    }

    private void computeSubnodes() {
        if (this._subnodes != null) {
            return;
        }
        this._subnodes = new HashSet<CanonicalWatched>();
        for (SDDTree sdd : this._sdds) {
            sdd.insertSubSDDTrees(this._subnodes);
        }
    }
}

