/*
 * Decompiled with CFR 0.152.
 */
package sdd.opt;

import buffer.CanonicalWatched;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import sdd.SDD;
import sdd.SDDMemory;
import sdd.SDDTree;
import sdd.SDDTreeConjunction;
import sdd.SDDTreeDisjunction;
import sdd.Vtree;
import sdd.VtreeNode;
import sdd.ope.LeftRotation;
import sdd.ope.RightRotation;
import sdd.ope.Swap;
import sdd.ope.VtreeOperation;
import sdd.opt.ExplicitOptimisationProblem;
import sdd.opt.OptimisationProblem;
import sdd.opt.OptimisationReport;

public class Optimisation {
    private final Set<Vtree> _testedTrees;
    private final List<SDD> _bestSDDs;
    static final VtreeOperation[] OPERATIONS = new VtreeOperation[]{new LeftRotation(), new RightRotation(), new Swap()};

    public Optimisation(List<SDD> sdds) {
        if (sdds.isEmpty()) {
            throw new IllegalArgumentException("Cannot optimise an empty list of SDDs.");
        }
        this._testedTrees = new HashSet<Vtree>();
        this._bestSDDs = new ArrayList<SDD>(sdds);
    }

    public List<SDD> getSDDs() {
        return new ArrayList<SDD>(this._bestSDDs);
    }

    public void localOptimal() {
        Vtree originalTree = this._bestSDDs.get(0).getTree();
        ArrayList<SDDTree> sddTrees = new ArrayList<SDDTree>();
        for (SDD sdd : this._bestSDDs) {
            SDDTree sddTree = sdd.getSDDTree();
            sddTrees.add(sddTree);
        }
        ExplicitOptimisationProblem pb = new ExplicitOptimisationProblem(sddTrees, originalTree);
        OptimisationReport report = this.localOptimal(pb);
        Vtree newTree = report.getVtree();
        for (int i = 0; i < this._bestSDDs.size(); ++i) {
            SDD sdd = this._bestSDDs.get(i);
            SDDTree sddTree = sdd.getSDDTree();
            SDDTree newSDDTree = report._replacementMap.get(sddTree);
            SDD newSdd = SDD.create(newSDDTree, newTree);
            this._bestSDDs.set(i, newSdd);
        }
        CanonicalWatched.unwatchAll(this._testedTrees);
        this._testedTrees.clear();
        report.unwatch();
    }

    private OptimisationReport optimiseChildren(OptimisationProblem pb) {
        HashSet<SDDTree> primes = new HashSet<SDDTree>();
        HashSet<SDDTree> subs = new HashSet<SDDTree>();
        for (SDDTree sdd : pb.getSDDs()) {
            if (!sdd.isDisjunction()) continue;
            SDDTreeDisjunction disj = sdd.getDisjunction();
            for (SDDTreeConjunction con : disj.getDisjuncts()) {
                SDDTree prime = con.getPrime();
                primes.add(prime);
                SDDTree sub = con.getSub();
                subs.add(sub);
            }
        }
        VtreeNode treeNode = (VtreeNode)pb.getTree();
        Vtree primeTree = treeNode.getLeft();
        Vtree subTree = treeNode.getRight();
        ExplicitOptimisationProblem primeProb = new ExplicitOptimisationProblem(primes, primeTree);
        ExplicitOptimisationProblem subProb = new ExplicitOptimisationProblem(subs, subTree);
        OptimisationReport primeReport = this.localOptimal(primeProb);
        OptimisationReport subReport = this.localOptimal(subProb);
        OptimisationReport result = OptimisationReport.applyChildren(primeReport, subReport, pb);
        primeReport.unwatch();
        subReport.unwatch();
        return result;
    }

    private OptimisationReport optimiseLocalNode(OptimisationProblem pb) {
        OptimisationReport bestOptimisationSoFar = OptimisationReport.noChange(pb);
        int currentSize = pb.size();
        SDDMemory mem = new SDDMemory();
        for (VtreeOperation op : OPERATIONS) {
            OptimisationReport report = this.applyOperation(op, pb, currentSize, mem);
            if (!report.vtreeChanged()) {
                report.unwatch();
                continue;
            }
            bestOptimisationSoFar.unwatch();
            bestOptimisationSoFar = report;
            currentSize = report.size();
        }
        mem.empty();
        return bestOptimisationSoFar;
    }

    private OptimisationReport localOptimal(OptimisationProblem pb) {
        OptimisationProblem currentProblem;
        OptimisationReport oneStepOptimisation;
        Vtree tree = pb.getTree();
        if (tree.isLeaf()) {
            return OptimisationReport.noChange(pb);
        }
        OptimisationReport currentReport = OptimisationReport.noChange(pb);
        while ((oneStepOptimisation = this.oneStepLocalOptimal(currentProblem = currentReport.getNewProblem())).vtreeChanged()) {
            OptimisationReport newReport = OptimisationReport.applyIterative(currentReport, oneStepOptimisation);
            currentReport.unwatch();
            oneStepOptimisation.unwatch();
            currentReport = newReport;
        }
        oneStepOptimisation.unwatch();
        return currentReport;
    }

    private OptimisationReport oneStepLocalOptimal(OptimisationProblem pb) {
        for (SDDTree sdd : pb.getSDDs()) {
            SDDTree.DEBUG_VERIFY_VTREE(pb.getTree(), sdd);
        }
        Vtree tree = pb.getTree();
        if (tree.isLeaf()) {
            return OptimisationReport.noChange(pb);
        }
        OptimisationReport childrenOptimisation = this.optimiseChildren(pb);
        OptimisationReport nodeOptimisation = this.optimiseLocalNode(childrenOptimisation.getNewProblem());
        OptimisationReport result = OptimisationReport.applyIterative(childrenOptimisation, nodeOptimisation);
        childrenOptimisation.unwatch();
        nodeOptimisation.unwatch();
        for (SDDTree sdd : result.getSDDs()) {
            sdd.verifyValidity();
        }
        return result;
    }

    private OptimisationReport applyOperation(VtreeOperation op, OptimisationProblem pb, int maxSize, SDDMemory mem) {
        for (SDDTree sdd : pb.getSDDs()) {
            SDDTree.DEBUG_VERIFY_VTREE(pb.getTree(), sdd);
        }
        Vtree tree = pb.getTree();
        if (!op.isApplicable(tree)) {
            return OptimisationReport.noChange(pb);
        }
        Vtree newTree = op.apply(tree);
        if (!this._testedTrees.add(newTree)) {
            newTree.unwatch();
            return OptimisationReport.noChange(pb);
        }
        HashMap<SDDTree, SDDTree> result = new HashMap<SDDTree, SDDTree>();
        HashSet<CanonicalWatched> newSubtrees = new HashSet<CanonicalWatched>();
        ArrayList<SDDTree> newSDDs = new ArrayList<SDDTree>();
        for (SDDTree sdd : pb.getSDDs()) {
            SDDTree newSDD = op.applyToSDD(sdd, mem);
            newSDD.insertSubSDDTrees(newSubtrees);
            result.put(sdd, newSDD);
            newSDDs.add(newSDD);
            if (newSubtrees.size() < maxSize) continue;
            CanonicalWatched.unwatchAll(newSDDs);
            return OptimisationReport.noChange(pb);
        }
        newTree.watch();
        return OptimisationReport.optimisationChange(result, newSubtrees, newTree, newSDDs);
    }

    public static SDD optimiseSingleSDD(SDD sdd) {
        ArrayList<SDD> sddsToOptimise = new ArrayList<SDD>();
        sddsToOptimise.add(sdd);
        Optimisation opt = new Optimisation(sddsToOptimise);
        opt.localOptimal();
        List<SDD> optimisedSDDs = opt.getSDDs();
        SDD result = optimisedSDDs.get(0);
        return result;
    }
}

