/*
 * Decompiled with CFR 0.152.
 */
package sdd.opt;

import buffer.CanonicalWatched;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import sdd.SDDTree;
import sdd.SDDTreeConjunction;
import sdd.SDDTreeDisjunction;
import sdd.Vtree;
import sdd.VtreeNode;
import sdd.opt.OptimisationProblem;
import util.IdentityMap;

public class OptimisationReport {
    private final boolean _modified;
    public final Map<SDDTree, SDDTree> _replacementMap;
    private final Set<CanonicalWatched> _subnodes;
    private int _nbSubNodes;
    private final Vtree _newVtree;
    private final Collection<SDDTree> _optimisedSDDs;

    public boolean vtreeChanged() {
        return this._modified;
    }

    public Vtree getVtree() {
        return this._newVtree;
    }

    private OptimisationReport(boolean optimised, Map<SDDTree, SDDTree> replacementMap, Set<CanonicalWatched> subnodes, Vtree tree, Collection<SDDTree> optimisedSDDs) {
        if (optimisedSDDs == null) {
            throw new IllegalArgumentException("Null collection of SDDs.");
        }
        if (tree == null) {
            throw new IllegalArgumentException("Null tree.");
        }
        this._modified = optimised;
        this._replacementMap = replacementMap;
        this._newVtree = tree;
        this._subnodes = subnodes;
        this._nbSubNodes = this._subnodes.size();
        this._optimisedSDDs = optimisedSDDs;
        for (SDDTree sdd : optimisedSDDs) {
            SDDTree.DEBUG_VERIFY_VTREE(tree, sdd);
        }
    }

    public static OptimisationReport noChange(OptimisationProblem pb) {
        for (SDDTree sdd : pb.getSDDs()) {
            sdd.watch();
        }
        pb.getTree().watch();
        return new OptimisationReport(false, new IdentityMap<SDDTree>(), pb.getSubnodes(), pb.getTree(), pb.getSDDs());
    }

    public static OptimisationReport optimisationChange(Map<SDDTree, SDDTree> replacementMap, Set<CanonicalWatched> subnodes, Vtree tree, Collection<SDDTree> newSDDs) {
        return new OptimisationReport(true, replacementMap, subnodes, tree, newSDDs);
    }

    public Map<SDDTree, SDDTree> getNonNullMap() {
        if (this._modified) {
            return this._replacementMap;
        }
        return new IdentityMap<SDDTree>();
    }

    public int size() {
        return this._nbSubNodes;
    }

    public static OptimisationReport applyIterative(OptimisationReport rep1, OptimisationReport rep2) {
        if (!rep1._modified) {
            for (SDDTree sdd : rep2.getSDDs()) {
                sdd.watch();
            }
            rep2.getVtree().watch();
            return rep2;
        }
        if (!rep2._modified) {
            for (SDDTree sdd : rep1.getSDDs()) {
                sdd.watch();
            }
            rep1.getVtree().watch();
            return rep1;
        }
        HashMap<SDDTree, SDDTree> newMap = new HashMap<SDDTree, SDDTree>();
        ArrayList<SDDTree> newSDDs = new ArrayList<SDDTree>();
        for (Map.Entry<SDDTree, SDDTree> ent : rep1._replacementMap.entrySet()) {
            SDDTree sdd1 = ent.getKey();
            SDDTree sdd2 = ent.getValue();
            SDDTree sdd3 = rep2._replacementMap.get(sdd2);
            newMap.put(sdd1, sdd3);
            newSDDs.add(sdd3);
        }
        for (SDDTree sdd : newSDDs) {
            sdd.watch();
        }
        Vtree newVtree = rep2._newVtree;
        newVtree.watch();
        return OptimisationReport.optimisationChange(newMap, rep2._subnodes, newVtree, newSDDs);
    }

    public static OptimisationReport applyChildren(OptimisationReport primeRep, OptimisationReport subRep, OptimisationProblem pb) {
        if (!primeRep.vtreeChanged() && !subRep.vtreeChanged()) {
            return OptimisationReport.noChange(pb);
        }
        VtreeNode newTree = VtreeNode.create(primeRep.getVtree(), subRep.getVtree());
        HashMap<SDDTree, SDDTree> newMap = new HashMap<SDDTree, SDDTree>();
        HashSet<CanonicalWatched> subNodes = new HashSet<CanonicalWatched>();
        HashSet<SDDTree> optimisedSDDs = new HashSet<SDDTree>();
        for (SDDTree sdd : pb.getSDDs()) {
            if (sdd.isConstant()) {
                newMap.put(sdd, sdd);
                optimisedSDDs.add(sdd);
                subNodes.add(sdd);
                sdd.watch();
                continue;
            }
            SDDTreeDisjunction disj = sdd.getDisjunction();
            HashSet<SDDTreeConjunction> newCons = new HashSet<SDDTreeConjunction>();
            for (SDDTreeConjunction con : disj.getDisjuncts()) {
                SDDTree prime = con.getPrime();
                SDDTree sub = con.getSub();
                SDDTree newPrime = primeRep._replacementMap.get(prime);
                SDDTree newSub = subRep._replacementMap.get(sub);
                SDDTreeConjunction newCon = SDDTreeConjunction.create(newPrime, newSub);
                newCons.add(newCon);
            }
            SDDTreeDisjunction newDisj = SDDTreeDisjunction.create(newCons);
            CanonicalWatched.unwatchAll(newCons);
            newMap.put(sdd, newDisj);
            optimisedSDDs.add(newDisj);
            newDisj.insertSubSDDTrees(subNodes);
        }
        return OptimisationReport.optimisationChange(newMap, subNodes, newTree, optimisedSDDs);
    }

    public Collection<SDDTree> getSDDs() {
        return this._optimisedSDDs;
    }

    public void unwatch() {
        CanonicalWatched.unwatchAll(this._optimisedSDDs);
        this._newVtree.unwatch();
    }

    public OptimisationProblem getNewProblem() {
        return new OptimisationProblem(){

            @Override
            public Collection<SDDTree> getSDDs() {
                return OptimisationReport.this._optimisedSDDs;
            }

            @Override
            public Vtree getTree() {
                return OptimisationReport.this._newVtree;
            }

            @Override
            public int size() {
                return OptimisationReport.this._nbSubNodes;
            }

            @Override
            public Set<CanonicalWatched> getSubnodes() {
                return OptimisationReport.this._subnodes;
            }
        };
    }
}

