/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.BufferedReader;
import java.io.IOException;
import util.IntegerTokenizer;

public class DimacsTokenizer
implements IntegerTokenizer {
    private final BufferedReader _reader;
    private String _currentLine;
    private int _currentPosition;
    private int _nextToken;
    private boolean _finished;

    public DimacsTokenizer(BufferedReader reader) throws IOException {
        this._reader = reader;
        this._currentLine = this._reader.readLine();
        this._currentPosition = 0;
        this._finished = false;
        this.findNextToken();
    }

    private void findNextToken() throws IOException {
        boolean tokenFinished;
        char nextChar;
        while (true) {
            boolean readNewLine;
            if (this.endOfLine()) {
                nextChar = '0';
                readNewLine = true;
            } else {
                nextChar = this.nextChar();
                readNewLine = nextChar == 'c';
            }
            if (readNewLine) {
                if (this._reader.ready()) {
                    this._currentLine = this._reader.readLine();
                    this._currentPosition = 0;
                    continue;
                }
                this._finished = true;
                return;
            }
            if (!Character.isWhitespace(nextChar)) break;
        }
        int value = 0;
        boolean negative = false;
        if (nextChar == '-') {
            negative = true;
        } else {
            value = Character.digit(nextChar, 10);
        }
        do {
            if (this.endOfLine()) {
                tokenFinished = true;
                continue;
            }
            char newChar = this.nextChar();
            if (Character.isDigit(newChar)) {
                value = value * 10 + Character.digit(newChar, 10);
                tokenFinished = false;
                continue;
            }
            tokenFinished = true;
        } while (!tokenFinished);
        this._nextToken = negative ? -value : value;
    }

    private boolean endOfLine() {
        return this._currentPosition == this._currentLine.length();
    }

    private char nextChar() {
        char result = this._currentLine.charAt(this._currentPosition);
        ++this._currentPosition;
        return result;
    }

    @Override
    public boolean isFinished() {
        return this._finished;
    }

    @Override
    public int nextToken() {
        int result = this._nextToken;
        try {
            this.findNextToken();
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        return result;
    }
}

