/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class DotStream {
    private final PrintStream _out;
    private final Map<String, String> _nextNodeOptions;
    private final Map<String, String> _nextEdgeOptions;
    private final boolean _closeAtEndTime;

    public DotStream(PrintStream out) {
        this._out = out;
        this._nextNodeOptions = new HashMap<String, String>();
        this._nextEdgeOptions = new HashMap<String, String>();
        this._closeAtEndTime = false;
        this.start();
    }

    public DotStream(String filename) {
        PrintStream out = null;
        try {
            out = new PrintStream(filename);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        this._out = out;
        this._nextNodeOptions = new HashMap<String, String>();
        this._nextEdgeOptions = new HashMap<String, String>();
        this._closeAtEndTime = true;
        this.start();
    }

    private void start() {
        this._out.println("digraph {");
    }

    public void end() {
        this._out.println("}");
        if (this._closeAtEndTime) {
            this._out.close();
        }
    }

    public void addNodeOption(String key, String val) {
        this._nextNodeOptions.put(key, val);
    }

    public void defineNode(String name) {
        this._out.print("  ");
        this._out.print(name);
        this.printOptions(this._nextNodeOptions);
        this._nextNodeOptions.clear();
        this._out.println(";");
    }

    public void addEdgeOption(String key, String val) {
        this._nextEdgeOptions.put(key, val);
    }

    public void defineEdge(String source, String target) {
        this._out.print("  ");
        this._out.print(source);
        this._out.print(" -> ");
        this._out.print(target);
        this.printOptions(this._nextEdgeOptions);
        this._nextEdgeOptions.clear();
        this._out.println(";");
    }

    private void printOptions(Map<String, String> options) {
        if (!options.isEmpty()) {
            this._out.print(" ");
            this._out.print("[");
            Iterator<Map.Entry<String, String>> it = options.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, String> ent = it.next();
                String key = ent.getKey();
                String val = ent.getValue();
                this._out.print(key);
                this._out.print("=");
                this._out.print("\"");
                this._out.print(val);
                this._out.print("\"");
                if (!it.hasNext()) continue;
                this._out.print(",");
            }
            this._out.print("]");
        }
    }
}

