/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.util.List;
import util.PseudoRandom;

public class Mersenne
implements PseudoRandom {
    private final int[] _state;
    private int _index = 0;
    private static final int TWOPOWER32 = (int)Math.pow(2.0, 32.0);

    public Mersenne(List<Integer> list) {
        this._state = new int[list.size()];
        for (int i = 0; i < this._state.length; ++i) {
            this._state[i] = list.get(i);
        }
    }

    public Mersenne(int seed) {
        int STATE_SIZE = 624;
        this._state = new int[624];
        this._state[0] = seed;
        for (int i = 1; i < 624; ++i) {
            this._state[i] = 1812433253 * (this._state[i - 1] ^ this._state[i - 1] >> 30) + i & TWOPOWER32 - 1;
        }
    }

    public void generateNumbers() {
        for (int i = 0; i < this._state.length; ++i) {
            int y = ((this._state[i] & TWOPOWER32) == 0 ? 0 : 1) + (this._state[(i + 1) % this._state.length] & TWOPOWER32 - 1);
            this._state[i] = this._state[(i + 397) % this._state.length] ^ y >> 1;
            if (y % 2 != 0) continue;
            this._state[i] = this._state[i] ^ 0x9908B0DF;
        }
    }

    public int extractNumber() {
        if (this._index == 0) {
            this.generateNumbers();
        }
        int y = this._state[this._index];
        y ^= y >> 11;
        y ^= y << 7 & 0x9D2C5680;
        y ^= y << 15 & 0xEFC60000;
        y ^= y >> 18;
        this._index = (this._index + 1) % this._state.length;
        return y;
    }

    @Override
    public int rand(int n) {
        int nb = this.extractNumber();
        return nb % n;
    }
}

