/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.util.Iterator;
import java.util.List;

public class Pair<C1, C2>
implements Comparable<Pair<C1, C2>> {
    private C1 _a;
    private C2 _b;

    public Pair(C1 e1, C2 e2) {
        this._a = e1;
        this._b = e2;
    }

    public static <C1, C2> Pair<C1, C2> newPair(C1 e1, C2 e2) {
        return new Pair<C1, C2>(e1, e2);
    }

    public int hashCode() {
        return Pair.hashCode(this._a, this._b);
    }

    public boolean equals(Object o) {
        if (!(o instanceof Pair)) {
            return false;
        }
        Pair pair = (Pair)o;
        if (this._a != pair._a) {
            if (this._a == null) {
                return false;
            }
            if (pair._a == null) {
                return false;
            }
            if (!this._a.equals(pair._a)) {
                return false;
            }
        }
        if (this._b != pair._b) {
            if (this._b == null) {
                return false;
            }
            if (pair._b == null) {
                return false;
            }
            if (!this._b.equals(pair._b)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public int compareTo(Pair<C1, C2> pair) {
        int result = ((Comparable)this._a).compareTo(pair._a);
        if (result == 0) {
            result = ((Comparable)this._b).compareTo(pair._b);
        }
        return result;
    }

    public C1 first() {
        return this._a;
    }

    public C2 second() {
        return this._b;
    }

    public void setFirst(C1 e) {
        this._a = e;
    }

    public void setSecond(C2 e) {
        this._b = e;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("<");
        if (this._a != null) {
            buf.append(this._a.toString());
        } else {
            buf.append("null");
        }
        buf.append(",");
        if (this._b != null) {
            buf.append(this._b.toString());
        } else {
            buf.append("null");
        }
        buf.append(">");
        return buf.toString();
    }

    public static int hashCode(Object e1, Object e2) {
        int x = e1 == null ? 0 : e1.hashCode();
        int y = e2 == null ? 0 : e2.hashCode();
        int sum = x + y;
        return (sum + (sum + 1) >> 1) + x;
    }

    public static <O> Iterable<Pair<O, O>> allPairs(final List<? extends O> l) {
        return new Iterable<Pair<O, O>>(){
            final int size;
            {
                this.size = l.size();
            }

            @Override
            public Iterator<Pair<O, O>> iterator() {
                return new AllPairIterator();
            }

            class AllPairIterator
            implements Iterator<Pair<O, O>> {
                int i = 0;
                int j = 1;

                AllPairIterator() {
                }

                @Override
                public boolean hasNext() {
                    return this.i < size - 1;
                }

                @Override
                public Pair<O, O> next() {
                    Pair result = new Pair(l.get(this.i), l.get(this.j));
                    ++this.j;
                    if (this.j >= size) {
                        ++this.i;
                        this.j = this.i + 1;
                    }
                    return result;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            }
        };
    }
}

