/*
 * Decompiled with CFR 0.152.
 */
package edu.supercom.csdl;

import edu.supercom.csdl.Component;
import edu.supercom.csdl.ComponentRule;
import edu.supercom.csdl.ExplicitSubsystem;
import edu.supercom.csdl.Rule;
import edu.supercom.csdl.Subsystem;
import edu.supercom.csdl.SubsystemRule;
import edu.supercom.util.UnmodifiableSetConstructor;
import java.util.Collection;

public abstract class AbstractSubsystemRule
implements SubsystemRule {
    @Override
    public ComponentRule getComponentRule(Component component) {
        return component.getComponentRule(this.getRule(component));
    }

    @Override
    public void copyAffectedComponents(Collection<Component> collection) {
        for (Component component : this.getSubsystem()) {
            if (!this.isAffected(component)) continue;
            collection.add(component);
        }
    }

    @Override
    public Subsystem getAffectedComponents() {
        UnmodifiableSetConstructor<Component> unmodifiableSetConstructor = new UnmodifiableSetConstructor<Component>();
        for (Component component : this.getSubsystem()) {
            if (!this.isAffected(component)) continue;
            unmodifiableSetConstructor.add(component);
        }
        return new ExplicitSubsystem(unmodifiableSetConstructor.getSet());
    }

    public static int hashCode(SubsystemRule subsystemRule) {
        int n = subsystemRule.getSubsystem().hashCode();
        for (Component component : subsystemRule.getAffectedComponents()) {
            ComponentRule componentRule = subsystemRule.getComponentRule(component);
            if (componentRule == null) continue;
            n += componentRule.hashCode();
        }
        return n;
    }

    @Override
    public int hashCode() {
        return AbstractSubsystemRule.hashCode(this);
    }

    public static boolean equals(SubsystemRule subsystemRule, SubsystemRule subsystemRule2) {
        Object object;
        if (subsystemRule == subsystemRule2) {
            return true;
        }
        if (subsystemRule == null || subsystemRule2 == null) {
            return false;
        }
        Subsystem subsystem = subsystemRule.getSubsystem();
        if (!subsystem.equals(object = subsystemRule2.getSubsystem())) {
            return false;
        }
        subsystem = subsystemRule.getAffectedComponents();
        if (!subsystem.equals(object = subsystemRule2.getAffectedComponents())) {
            return false;
        }
        for (Component component : subsystem) {
            Rule rule;
            Rule rule2 = subsystemRule.getRule(component);
            if (rule2 == (rule = subsystemRule2.getRule(component))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof SubsystemRule) {
            SubsystemRule subsystemRule = (SubsystemRule)object;
            AbstractSubsystemRule.equals(this, subsystemRule);
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (Component component : this.getAffectedComponents()) {
            ComponentRule componentRule = this.getComponentRule(component);
            stringBuffer.append(component.getName()).append(" -> ").append(componentRule.getRule().toString()).append(";");
        }
        return stringBuffer.toString();
    }

    @Override
    public boolean isNull() {
        return this.getAffectedComponents().isEmpty();
    }
}

