/*
 * Decompiled with CFR 0.152.
 */
package edu.supercom.csdl;

import edu.supercom.csdl.Component;
import edu.supercom.csdl.ComponentEvent;
import edu.supercom.csdl.ComponentPort;
import edu.supercom.csdl.ComponentRule;
import edu.supercom.csdl.CompositeSystem;
import edu.supercom.csdl.Connection;
import edu.supercom.csdl.Event;
import edu.supercom.csdl.Message;
import edu.supercom.csdl.NotApplicableReconfiguration;
import edu.supercom.csdl.Port;
import edu.supercom.csdl.ReconfigurationPattern;
import edu.supercom.csdl.Rule;
import edu.supercom.csdl.Subsystem;
import edu.supercom.csdl.SubsystemRule;
import edu.supercom.csdl.Topology;
import edu.supercom.util.UnmodifiableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class AbstractTopology
implements Topology {
    @Override
    public Component getComponent(String string) {
        for (Component component : this.activeComponents()) {
            if (!component.getName().equals(string)) continue;
            return component;
        }
        return null;
    }

    @Override
    @Deprecated
    public Iterator<Component> activeComponentIterator() {
        return this.activeComponents().iterator();
    }

    @Override
    @Deprecated
    public UnmodifiableSet<Component> activeComponents() {
        return this.activeSubsystem().getComponents();
    }

    @Override
    public boolean isActive(Component component) {
        return this.getComponent(component.getName()) == component;
    }

    @Override
    @Deprecated
    public Iterator<Connection> connectionIterator() {
        return this.connections().iterator();
    }

    @Override
    public abstract Collection<Connection> connections();

    @Override
    @Deprecated
    public Iterator<Connection> connectionIterator(Component component) {
        return this.connections(component).iterator();
    }

    @Override
    public Collection<Connection> connections(Component component) {
        ArrayList<Connection> arrayList = new ArrayList<Connection>();
        for (Connection connection : this.connections()) {
            if (connection.getTargetComponent() != component && connection.getSourceComponent() != component) continue;
            arrayList.add(connection);
        }
        return Collections.unmodifiableCollection(arrayList);
    }

    @Override
    @Deprecated
    public Iterator<Connection> targetConnectionIterator(Component component) {
        return this.targetConnections(component).iterator();
    }

    @Override
    public Collection<Connection> targetConnections(Component component) {
        ArrayList<Connection> arrayList = new ArrayList<Connection>();
        for (Connection connection : this.connections()) {
            if (connection.getTargetComponent() != component) continue;
            arrayList.add(connection);
        }
        return Collections.unmodifiableCollection(arrayList);
    }

    @Override
    @Deprecated
    public Iterator<Connection> sourceConnectionIterator(Component component) {
        return this.sourceConnections(component).iterator();
    }

    @Override
    public Collection<Connection> sourceConnections(Component component) {
        ArrayList<Connection> arrayList = new ArrayList<Connection>();
        for (Connection connection : this.connections()) {
            if (connection.getSourceComponent() != component) continue;
            arrayList.add(connection);
        }
        return Collections.unmodifiableCollection(arrayList);
    }

    @Override
    @Deprecated
    public Iterator<Connection> connectionIterator(Component component, Port port) {
        return this.connections(component, port).iterator();
    }

    @Override
    public Collection<Connection> connections(Component component, Port port) {
        ArrayList<Connection> arrayList = new ArrayList<Connection>();
        for (Connection connection : this.connections()) {
            if (connection.getSourceComponent() != component || connection.getSourcePort() != port) continue;
            arrayList.add(connection);
        }
        return Collections.unmodifiableCollection(arrayList);
    }

    @Override
    public Connection getConnection(Component component, Port port) {
        ArrayList arrayList = new ArrayList();
        for (Connection connection : this.connections()) {
            if (connection.getSourceComponent() != component || connection.getSourcePort() != port) continue;
            return connection;
        }
        return null;
    }

    @Override
    @Deprecated
    public Iterator<ComponentPort> observablePortIterator() {
        return this.observablePorts().iterator();
    }

    @Override
    public abstract Collection<ComponentPort> observablePorts();

    @Override
    @Deprecated
    public Iterator<Port> observablePortIterator(Component component) {
        return this.observablePorts(component).iterator();
    }

    @Override
    public Collection<Port> observablePorts(Component component) {
        ArrayList<Port> arrayList = new ArrayList<Port>();
        Iterator<ComponentPort> iterator = this.observablePortIterator();
        while (iterator.hasNext()) {
            ComponentPort componentPort = iterator.next();
            if (componentPort.getComponent() != component) continue;
            arrayList.add(componentPort.getPort());
        }
        return Collections.unmodifiableCollection(arrayList);
    }

    @Override
    public boolean isObservable(Component component, Port port) {
        Iterator<ComponentPort> iterator = this.observablePortIterator();
        while (iterator.hasNext()) {
            ComponentPort componentPort = iterator.next();
            if (componentPort.getComponent() != component || componentPort.getPort() != port) continue;
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int n = 0;
        Iterator<Comparable> iterator = this.activeComponentIterator();
        while (iterator.hasNext()) {
            n += iterator.next().hashCode();
        }
        iterator = this.connectionIterator();
        while (iterator.hasNext()) {
            n += ((Connection)iterator.next()).hashCode();
        }
        iterator = this.observablePortIterator();
        while (iterator.hasNext()) {
            n += ((ComponentPort)iterator.next()).hashCode();
        }
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof Topology)) {
            return false;
        }
        Topology topology = (Topology)object;
        if (!this.activeSubsystem().equals(topology.activeSubsystem())) {
            return false;
        }
        if (!this.connections().equals(topology.connections())) {
            return false;
        }
        return topology.observablePorts().equals(this.observablePorts());
    }

    @Override
    public abstract Topology apply(CompositeSystem var1, ReconfigurationPattern var2, Map<String, String> var3);

    @Override
    public boolean canBeApplied(CompositeSystem compositeSystem, ReconfigurationPattern reconfigurationPattern, Map<String, String> map) {
        try {
            this.apply(compositeSystem, reconfigurationPattern, map);
            return true;
        }
        catch (NotApplicableReconfiguration notApplicableReconfiguration) {
            return false;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    @Override
    public boolean canBeTriggered(Component component, Event event) {
        if (event == null) {
            throw new NullPointerException();
        }
        return true;
    }

    @Override
    public boolean canBeTriggered(Component component, Rule rule) {
        Event event = rule.getTriggeringEvent();
        if (!this.canBeTriggered(component, event)) {
            return false;
        }
        for (Event event2 : rule.outputEvents()) {
            if (this.canBeTriggered(component, event2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public ComponentEvent generatingEvent(Component component, Event event) {
        if (component == null) {
            throw new NullPointerException("Null component.");
        }
        if (!this.isActive(component)) {
            throw new IllegalArgumentException("Component " + component.getName() + " is not active.");
        }
        if (component.isActionEvent(event) || component.isSpontaneousEvent(event) || !event.getPort().isInputPort()) {
            ComponentEvent componentEvent = component.getComponentEvent(event);
            if (componentEvent == null) {
                throw new IllegalArgumentException("Unknown event " + event.getLabel() + ".");
            }
            return componentEvent;
        }
        Connection connection = this.getConnection(component, event.getPort());
        if (connection == null) {
            return null;
        }
        Component component2 = connection.getSourceComponent();
        Port port = connection.getSourcePort();
        Event event2 = port.getEvent(event.getMessage());
        return component2.getComponentEvent(event2);
    }

    @Override
    public boolean isConnected(Component component, Port port) {
        if (port.isInputPort()) {
            return this.getConnection(component, port) != null;
        }
        return this.connectionIterator(component, port).hasNext();
    }

    @Override
    public boolean isObservable(Component component, Rule rule) {
        for (Event event : rule.outputEvents()) {
            Port port = event.getPort();
            if (!this.isObservable(component, port)) continue;
            return true;
        }
        return false;
    }

    public Collection<ComponentEvent> observableEvents(Collection<Component> collection) {
        return AbstractTopology.observableEvents(this, collection);
    }

    public static Collection<ComponentEvent> observableEvents(Topology topology, Collection<Component> collection) {
        HashSet<ComponentEvent> hashSet = new HashSet<ComponentEvent>();
        for (ComponentPort componentPort : topology.observablePorts()) {
            Port port = componentPort.getPort();
            Component component = componentPort.getComponent();
            if (!collection.contains(component)) continue;
            for (Event event : port.events()) {
                hashSet.add(component.getComponentEvent(event));
            }
        }
        return hashSet;
    }

    public static Collection<ComponentEvent> observableEvents(Topology topology) {
        return AbstractTopology.observableEvents(topology, topology.activeSubsystem().getComponents());
    }

    @Override
    @Deprecated
    public boolean checkConsistency(Subsystem subsystem, Map<Component, ComponentRule> map) {
        for (Connection connection : subsystem.getInternalConnections(this)) {
            Message message;
            Event event;
            Component component = connection.getSourceComponent();
            Component component2 = connection.getTargetComponent();
            Port port = connection.getSourcePort();
            Port port2 = connection.getTargetPort();
            ComponentRule componentRule = map.get(component);
            ComponentRule componentRule2 = map.get(component2);
            Event event2 = componentRule == null ? null : componentRule.getRule().getEvent(port);
            Event event3 = event = componentRule2 == null ? null : componentRule2.getRule().getEvent(port2);
            if (event2 == null || event == null) {
                if (event2 == null && event == null) continue;
                return false;
            }
            Message message2 = event2.getMessage();
            if (message2.equals(message = event.getMessage())) continue;
            return false;
        }
        return true;
    }

    @Override
    public Set<Connection> internalConnections(Subsystem subsystem) {
        HashSet<Connection> hashSet = new HashSet<Connection>();
        for (Component component : subsystem.getComponents()) {
            Iterator<Connection> iterator = this.connectionIterator(component);
            while (iterator.hasNext()) {
                Connection connection = iterator.next();
                Component component2 = connection.getSourceComponent();
                Component component3 = connection.getTargetComponent();
                if (component2 != component && !subsystem.containsComponent(component2) || component3 != component && !subsystem.containsComponent(component3)) continue;
                hashSet.add(connection);
            }
        }
        return hashSet;
    }

    @Override
    public Set<Connection> externalConnections(Subsystem subsystem) {
        HashSet<Connection> hashSet = new HashSet<Connection>();
        for (Component component : subsystem.getComponents()) {
            Iterator<Connection> iterator = this.connectionIterator(component);
            while (iterator.hasNext()) {
                Connection connection = iterator.next();
                Component component2 = connection.getSourceComponent();
                Component component3 = connection.getTargetComponent();
                if ((component2 == component || subsystem.containsComponent(component2)) && (component3 == component || subsystem.containsComponent(component3))) continue;
                hashSet.add(connection);
            }
        }
        return hashSet;
    }

    @Override
    public boolean isObservable(SubsystemRule subsystemRule) {
        for (Component component : this.activeComponents()) {
            Rule rule;
            ComponentRule componentRule = subsystemRule.getComponentRule(component);
            if (componentRule == null || !this.isObservable(component, rule = componentRule.getRule())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean checkConsistency(SubsystemRule subsystemRule) {
        for (Connection connection : subsystemRule.getSubsystem().getInternalConnections(this)) {
            Message message;
            Component component = connection.getSourceComponent();
            Component component2 = connection.getTargetComponent();
            Port port = connection.getSourcePort();
            Port port2 = connection.getTargetPort();
            Rule rule = subsystemRule.getRule(component);
            Rule rule2 = subsystemRule.getRule(component2);
            if (rule == null) {
                if (rule2 == null) continue;
                return false;
            }
            if (rule2 == null) {
                return false;
            }
            Event event = rule.getEvent(port);
            Event event2 = rule2.getEvent(port2);
            Message message2 = event.getMessage();
            if (message2 == (message = event2.getMessage())) continue;
            return false;
        }
        return true;
    }
}

