/*
 * Decompiled with CFR 0.152.
 */
package edu.supercom.csdl;

import edu.supercom.csdl.AbstractSubsystemRule;
import edu.supercom.csdl.Component;
import edu.supercom.csdl.ComponentRule;
import edu.supercom.csdl.ExplicitSubsystem;
import edu.supercom.csdl.Rule;
import edu.supercom.csdl.Subsystem;
import edu.supercom.csdl.SubsystemRule;
import edu.supercom.util.UnmodifiableMap;
import edu.supercom.util.UnmodifiableMapConstructor;
import edu.supercom.util.UnmodifiableSetConstructor;
import java.util.Collection;
import java.util.Map;

public class AffectedSubsystemAwareSubsystemRule
extends AbstractSubsystemRule
implements SubsystemRule {
    private final Subsystem _sub;
    private final Subsystem _aff;
    private final UnmodifiableMap<Component, Rule> _rules;

    public AffectedSubsystemAwareSubsystemRule(Subsystem subsystem, Map<Component, Rule> map) {
        this._sub = subsystem;
        Object object = new UnmodifiableSetConstructor();
        for (Component component : subsystem) {
            Rule rule = map.get(component);
            if (rule == null) continue;
            ((UnmodifiableSetConstructor)object).add(component);
        }
        this._aff = new ExplicitSubsystem(((UnmodifiableSetConstructor)object).getSet());
        object = new UnmodifiableMapConstructor();
        for (Component component : this._aff) {
            ((UnmodifiableMapConstructor)object).addMapping(component, map.get(component));
        }
        this._rules = ((UnmodifiableMapConstructor)object).getMap();
    }

    public AffectedSubsystemAwareSubsystemRule(Subsystem subsystem, UnmodifiableMap<Component, Rule> unmodifiableMap) {
        this._sub = subsystem;
        UnmodifiableSetConstructor<Component> unmodifiableSetConstructor = new UnmodifiableSetConstructor<Component>();
        for (Component component : subsystem) {
            Rule rule = unmodifiableMap.get(component);
            if (rule == null) continue;
            unmodifiableSetConstructor.add(component);
        }
        this._aff = new ExplicitSubsystem(unmodifiableSetConstructor.getSet());
        this._rules = unmodifiableMap;
    }

    public AffectedSubsystemAwareSubsystemRule(Subsystem subsystem, UnmodifiableMap<Component, Rule> unmodifiableMap, Map<Subsystem, Subsystem> map) {
        Object object2;
        this._sub = subsystem;
        UnmodifiableSetConstructor<Object> unmodifiableSetConstructor = new UnmodifiableSetConstructor<Object>();
        for (Object object2 : subsystem) {
            Rule rule = unmodifiableMap.get(object2);
            if (rule == null) continue;
            unmodifiableSetConstructor.add(object2);
        }
        ExplicitSubsystem explicitSubsystem = new ExplicitSubsystem(unmodifiableSetConstructor.getSet());
        object2 = map.get(explicitSubsystem);
        if (object2 != null) {
            this._aff = object2;
        } else {
            this._aff = explicitSubsystem;
            map.put(explicitSubsystem, explicitSubsystem);
        }
        this._rules = unmodifiableMap;
    }

    private AffectedSubsystemAwareSubsystemRule(Subsystem subsystem, Subsystem subsystem2, UnmodifiableMap<Component, Rule> unmodifiableMap) {
        this._sub = subsystem;
        this._aff = subsystem2;
        this._rules = unmodifiableMap;
    }

    @Override
    public Subsystem getSubsystem() {
        return this._sub;
    }

    @Override
    public ComponentRule getComponentRule(Component component) {
        Rule rule = this.getRule(component);
        if (rule == null) {
            return null;
        }
        return component.getComponentRule(rule);
    }

    @Override
    public Rule getRule(Component component) {
        return this._rules.get(component);
    }

    @Override
    public AffectedSubsystemAwareSubsystemRule project(Subsystem subsystem) {
        Subsystem subsystem2 = this._sub.intersection(subsystem);
        Subsystem subsystem3 = this._aff.intersection(subsystem);
        UnmodifiableMapConstructor<Component, Rule> unmodifiableMapConstructor = new UnmodifiableMapConstructor<Component, Rule>();
        for (Component component : subsystem3) {
            unmodifiableMapConstructor.addMapping(component, this._rules.get(component));
        }
        return new AffectedSubsystemAwareSubsystemRule(subsystem2, subsystem3, unmodifiableMapConstructor.getMap());
    }

    @Override
    public SubsystemRule merge(SubsystemRule subsystemRule) {
        Subsystem subsystem = this._sub.merge(subsystemRule.getSubsystem());
        Subsystem subsystem2 = this._aff.merge(subsystemRule.getAffectedComponents());
        UnmodifiableMapConstructor<Component, Rule> unmodifiableMapConstructor = new UnmodifiableMapConstructor<Component, Rule>();
        for (Component component : this.getAffectedComponents()) {
            unmodifiableMapConstructor.addMapping(component, this.getRule(component));
        }
        for (Component component : subsystemRule.getAffectedComponents()) {
            unmodifiableMapConstructor.addMapping(component, subsystemRule.getRule(component));
        }
        return new AffectedSubsystemAwareSubsystemRule(subsystem, subsystem2, unmodifiableMapConstructor.getMap());
    }

    @Override
    public SubsystemRule merge(Subsystem subsystem, SubsystemRule subsystemRule) {
        Subsystem subsystem2 = this._aff.intersection(subsystem);
        UnmodifiableMapConstructor<Component, Rule> unmodifiableMapConstructor = new UnmodifiableMapConstructor<Component, Rule>();
        for (Component component : subsystem2) {
            unmodifiableMapConstructor.addMapping(component, this._rules.get(component));
        }
        return new AffectedSubsystemAwareSubsystemRule(subsystem, subsystem2, unmodifiableMapConstructor.getMap());
    }

    @Override
    public Subsystem getAffectedComponents() {
        return this._aff;
    }

    @Override
    public void copyAffectedComponents(Collection<Component> collection) {
        collection.addAll(this._aff);
    }

    @Override
    public boolean isAffected(Component component) {
        return this._aff.contains(component);
    }

    @Override
    public boolean isNull() {
        return this._aff.isEmpty();
    }
}

