/*
 * Decompiled with CFR 0.152.
 */
package edu.supercom.csdl;

import edu.supercom.csdl.AlwaysTrue;
import edu.supercom.csdl.Assignment;
import edu.supercom.csdl.TypeState;
import edu.supercom.csdl.TypeStateCondition;
import edu.supercom.csdl.Variable;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class AssignementExpression
extends TypeStateCondition {
    private final Assignment _ass;

    AssignementExpression(Assignment assignment) {
        this._ass = assignment;
    }

    @Override
    public boolean satisfiedVarVal(Map<Variable, Assignment> map) {
        Variable variable = this._ass.getVariable();
        Assignment assignment = map.get(variable);
        if (assignment == null) {
            throw new IllegalArgumentException("The variable " + variable.toString() + " is not assigned in this map " + map.toString() + ".");
        }
        return assignment == this._ass;
    }

    @Override
    protected boolean abstractSatisfiedVarVal(Map<Variable, Assignment> map) throws AlwaysTrue {
        Variable variable = this._ass.getVariable();
        Assignment assignment = map.get(variable);
        if (assignment == null) {
            throw AlwaysTrue.getInstance();
        }
        return assignment == this._ass;
    }

    @Override
    public boolean isAssignement() {
        return true;
    }

    @Override
    public Assignment getAssignement() {
        return this._ass;
    }

    @Override
    public boolean isNegation() {
        return false;
    }

    @Override
    public TypeStateCondition getNegation() {
        return TypeStateCondition.not(this);
    }

    @Override
    public boolean isAnd() {
        return false;
    }

    @Override
    public TypeStateCondition getAndLeftPart() {
        throw new UnsupportedOperationException("Unsupported operation 'getAndLeftPart' since this expression is an assignment.");
    }

    @Override
    public TypeStateCondition getAndRightPart() {
        throw new UnsupportedOperationException("Unsupported operation 'getAndRightPart' since this expression is an assignment.");
    }

    @Override
    public boolean isOr() {
        return false;
    }

    @Override
    public TypeStateCondition getOrLeftPart() {
        throw new UnsupportedOperationException("Unsupported operation 'getOrLeftPart' since this expression is an assignment.");
    }

    @Override
    public TypeStateCondition getOrRightPart() {
        throw new UnsupportedOperationException("Unsupported operation 'getOrRightPart' since this expression is an assignment.");
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    @Override
    public boolean getConstant() {
        throw new UnsupportedOperationException("Unsupported operation 'getConstant' since this expression is an assignment.");
    }

    @Override
    public TypeStateCondition negationOnTheLeaves() {
        return this;
    }

    @Override
    protected TypeStateCondition negToCNF() {
        return this;
    }

    @Override
    protected TypeStateCondition doAbstraction(Set<Variable> set) throws AlwaysTrue {
        if (set.contains(this._ass.getVariable())) {
            return this;
        }
        throw AlwaysTrue.getInstance();
    }

    @Override
    protected boolean abstractSatisfied(TypeState typeState, int n) throws AlwaysTrue {
        Assignment assignment = typeState.getAssignement(this._ass.getVariable());
        if (assignment != null) {
            return assignment == this._ass;
        }
        if (n == 0) {
            throw new IllegalArgumentException("The variable " + this._ass.getVariable() + " is not assigned in the state.");
        }
        throw AlwaysTrue.getInstance();
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof AssignementExpression) {
            return this._ass.equals(((AssignementExpression)object)._ass);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int n = 5;
        n = 31 * n + (this._ass != null ? this._ass.hashCode() : 0);
        return n;
    }

    @Override
    public Set<Assignment> getAssignements() {
        HashSet<Assignment> hashSet = new HashSet<Assignment>();
        hashSet.add(this._ass);
        return hashSet;
    }
}

