/*
 * Decompiled with CFR 0.152.
 */
package edu.supercom.csdl;

import edu.supercom.csdl.Value;
import edu.supercom.csdl.Variable;
import edu.supercom.util.Pair;

public final class Assignment
implements Comparable<Assignment> {
    private final Variable _var;
    private final Value _val;

    Assignment(Variable variable, Value value) {
        if (!variable.contains(value)) {
            throw new IllegalArgumentException("The value " + value.toString() + " is not a possible valuation of " + variable.toString());
        }
        this._var = variable;
        this._val = value;
    }

    public Variable getVariable() {
        return this._var;
    }

    public Value getValue() {
        return this._val;
    }

    public final boolean equals(Object object) {
        return this == object;
    }

    public final int hashCode() {
        return Pair.hashCode(this._var, this._val);
    }

    public String toString() {
        return "(" + this._var.getName() + " = " + this._val.toString() + ")";
    }

    public String toXml() {
        return "<Assignement>" + this._var.shortXml() + this._val.toXml() + "</Assignement>";
    }

    @Override
    public int compareTo(Assignment assignment) {
        int n = this._var.compareTo(assignment._var);
        if (n == 0) {
            n = this._val.compareTo(assignment._val);
        }
        return n;
    }
}

