/*
 * Decompiled with CFR 0.152.
 */
package edu.supercom.csdl;

import edu.supercom.csdl.AlwaysTrue;
import edu.supercom.csdl.Assignment;
import edu.supercom.csdl.TypeState;
import edu.supercom.csdl.TypeStateCondition;
import edu.supercom.csdl.Variable;
import java.util.Map;
import java.util.Set;

class BinaryExpression
extends TypeStateCondition {
    private final boolean _isAnd;
    private final TypeStateCondition _left;
    private final TypeStateCondition _right;

    public BinaryExpression(boolean bl, TypeStateCondition typeStateCondition, TypeStateCondition typeStateCondition2) {
        this._isAnd = bl;
        this._left = typeStateCondition;
        this._right = typeStateCondition2;
    }

    @Override
    public boolean satisfiedVarVal(Map<Variable, Assignment> map) {
        boolean bl = this._left.satisfiedVarVal(map);
        if (bl && !this._isAnd) {
            return true;
        }
        if (!bl && this._isAnd) {
            return false;
        }
        return this._right.satisfiedVarVal(map);
    }

    @Override
    protected boolean abstractSatisfiedVarVal(Map<Variable, Assignment> map) throws AlwaysTrue {
        block7: {
            try {
                boolean bl = this._left.abstractSatisfiedVarVal(map);
                if (bl && !this._isAnd) {
                    this._right.abstractSatisfiedVarVal(map);
                    return true;
                }
                if (!bl && this._isAnd) {
                    return false;
                }
                if (bl && this._isAnd) {
                    try {
                        return this._right.abstractSatisfiedVarVal(map);
                    }
                    catch (AlwaysTrue alwaysTrue) {
                        return true;
                    }
                }
            }
            catch (AlwaysTrue alwaysTrue) {
                if (this._isAnd) break block7;
                throw alwaysTrue;
            }
        }
        return this._right.abstractSatisfiedVarVal(map);
    }

    @Override
    public boolean isAssignement() {
        return false;
    }

    @Override
    public Assignment getAssignement() {
        throw new UnsupportedOperationException("Unsupported operation 'getAssignement' since this expression is a binary operation.");
    }

    @Override
    public boolean isNegation() {
        return false;
    }

    @Override
    public TypeStateCondition getNegation() {
        return TypeStateCondition.not(this);
    }

    @Override
    public boolean isAnd() {
        return this._isAnd;
    }

    @Override
    public TypeStateCondition getAndLeftPart() {
        if (this._isAnd) {
            return this._left;
        }
        throw new UnsupportedOperationException("Unsupported operation 'getAndLeftPart' since this expression is a OR.");
    }

    @Override
    public TypeStateCondition getAndRightPart() {
        if (this._isAnd) {
            return this._right;
        }
        throw new UnsupportedOperationException("Unsupported operation 'getAndRightPart' since this expression is a OR.");
    }

    @Override
    public boolean isOr() {
        return !this._isAnd;
    }

    @Override
    public TypeStateCondition getOrLeftPart() {
        if (this._isAnd) {
            throw new UnsupportedOperationException("Unsupported operation 'getOrLeftPart' since this expression is a AND.");
        }
        return this._left;
    }

    @Override
    public TypeStateCondition getOrRightPart() {
        if (this._isAnd) {
            throw new UnsupportedOperationException("Unsupported operation 'getOrRightPart' since this expression is a AND.");
        }
        return this._right;
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    @Override
    public boolean getConstant() {
        throw new UnsupportedOperationException("Unsupported operation 'getConstant' since this expression is a binary expression.");
    }

    @Override
    public TypeStateCondition negationOnTheLeaves() {
        return new BinaryExpression(this._isAnd, this._left.negationOnTheLeaves(), this._right.negationOnTheLeaves());
    }

    TypeStateCondition firstElement() {
        return this._left;
    }

    TypeStateCondition secondElement() {
        return this._right;
    }

    @Override
    protected TypeStateCondition negToCNF() {
        TypeStateCondition typeStateCondition = this._left.negToCNF();
        if (this._isAnd) {
            if (!typeStateCondition.isAnd()) {
                TypeStateCondition typeStateCondition2 = this._right.negToCNF();
                return TypeStateCondition.and(typeStateCondition, typeStateCondition2);
            }
            TypeStateCondition typeStateCondition3 = typeStateCondition.getAndLeftPart();
            TypeStateCondition typeStateCondition4 = typeStateCondition.getAndRightPart();
            TypeStateCondition typeStateCondition5 = typeStateCondition3;
            TypeStateCondition typeStateCondition6 = TypeStateCondition.and(typeStateCondition4, this._right);
            return TypeStateCondition.and(typeStateCondition5, typeStateCondition6).negToCNF();
        }
        if (typeStateCondition.isAnd()) {
            TypeStateCondition typeStateCondition7 = typeStateCondition.getAndLeftPart();
            TypeStateCondition typeStateCondition8 = typeStateCondition.getAndRightPart();
            TypeStateCondition typeStateCondition9 = TypeStateCondition.or(typeStateCondition7, this._right);
            TypeStateCondition typeStateCondition10 = TypeStateCondition.or(typeStateCondition8, this._right);
            return TypeStateCondition.and(typeStateCondition9, typeStateCondition10).negToCNF();
        }
        TypeStateCondition typeStateCondition11 = this._right.negToCNF();
        if (typeStateCondition11.isAnd()) {
            TypeStateCondition typeStateCondition12 = typeStateCondition11.getAndLeftPart();
            TypeStateCondition typeStateCondition13 = typeStateCondition11.getAndRightPart();
            TypeStateCondition typeStateCondition14 = TypeStateCondition.or(typeStateCondition, typeStateCondition12);
            TypeStateCondition typeStateCondition15 = TypeStateCondition.or(typeStateCondition, typeStateCondition13);
            return TypeStateCondition.and(typeStateCondition14, typeStateCondition15).negToCNF();
        }
        if (typeStateCondition.isOr()) {
            TypeStateCondition typeStateCondition16 = typeStateCondition.getAndLeftPart();
            TypeStateCondition typeStateCondition17 = typeStateCondition.getAndRightPart();
            TypeStateCondition typeStateCondition18 = typeStateCondition16;
            TypeStateCondition typeStateCondition19 = TypeStateCondition.or(typeStateCondition17, typeStateCondition11);
            return TypeStateCondition.and(typeStateCondition18, typeStateCondition19).negToCNF();
        }
        return TypeStateCondition.or(typeStateCondition, typeStateCondition11);
    }

    @Override
    protected TypeStateCondition doAbstraction(Set<Variable> set) throws AlwaysTrue {
        TypeStateCondition typeStateCondition;
        try {
            typeStateCondition = this._left.doAbstraction(set);
        }
        catch (AlwaysTrue alwaysTrue) {
            if (!this._isAnd) {
                throw alwaysTrue;
            }
            return this._right.doAbstraction(set);
        }
        try {
            TypeStateCondition typeStateCondition2 = this._right.doAbstraction(set);
            if (this._isAnd) {
                return TypeStateCondition.and(typeStateCondition, typeStateCondition2);
            }
            return TypeStateCondition.or(typeStateCondition, typeStateCondition2);
        }
        catch (AlwaysTrue alwaysTrue) {
            if (!this._isAnd) {
                throw alwaysTrue;
            }
            return typeStateCondition;
        }
    }

    @Override
    protected boolean abstractSatisfied(TypeState typeState, int n) throws AlwaysTrue {
        boolean bl;
        try {
            bl = this._left.abstractSatisfied(typeState, n);
        }
        catch (AlwaysTrue alwaysTrue) {
            if (!this._isAnd) {
                throw alwaysTrue;
            }
            return this._right.abstractSatisfied(typeState, n);
        }
        if (bl && !this._isAnd) {
            this._right.abstractSatisfied(typeState, n);
            return true;
        }
        if (!bl && this._isAnd) {
            return false;
        }
        if (bl && this._isAnd) {
            try {
                return this._right.abstractSatisfied(typeState, n);
            }
            catch (AlwaysTrue alwaysTrue) {
                return true;
            }
        }
        try {
            return this._right.abstractSatisfied(typeState, n);
        }
        catch (AlwaysTrue alwaysTrue) {
            return true;
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof BinaryExpression) {
            BinaryExpression binaryExpression = (BinaryExpression)object;
            if (this._isAnd != binaryExpression._isAnd) {
                return false;
            }
            return this._left.equals(binaryExpression._left) && this._right.equals(binaryExpression._right);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int n = 3;
        n = 97 * n + (this._isAnd ? 1 : 0);
        n = 97 * n + (this._left != null ? this._left.hashCode() : 0);
        n = 97 * n + (this._right != null ? this._right.hashCode() : 0);
        return n;
    }

    @Override
    public Set<Assignment> getAssignements() {
        Set<Assignment> set = this._left.getAssignements();
        set.addAll(this._right.getAssignements());
        return set;
    }
}

