/*
 * Decompiled with CFR 0.152.
 */
package edu.supercom.csdl;

import edu.supercom.csdl.AbstractOptionable;
import edu.supercom.csdl.AbstractTypeState;
import edu.supercom.csdl.Assignment;
import edu.supercom.csdl.BasicComponentState;
import edu.supercom.csdl.ComponentAssignment;
import edu.supercom.csdl.ComponentEvent;
import edu.supercom.csdl.ComponentPort;
import edu.supercom.csdl.ComponentRule;
import edu.supercom.csdl.ComponentState;
import edu.supercom.csdl.ComponentType;
import edu.supercom.csdl.Event;
import edu.supercom.csdl.MapTypeState;
import edu.supercom.csdl.Optionable;
import edu.supercom.csdl.Port;
import edu.supercom.csdl.Rule;
import edu.supercom.csdl.TypeState;
import edu.supercom.csdl.TypeStateCondition;
import edu.supercom.csdl.Value;
import edu.supercom.csdl.Variable;
import edu.supercom.util.UnmodifiableCollection;
import edu.supercom.util.UnmodifiableListConstructor;
import edu.supercom.util.UnmodifiableMap;
import edu.supercom.util.UnmodifiableMapConstructor;
import edu.supercom.util.UnmodifiableSet;
import edu.supercom.util.UnmodifiableSetConstructor;
import java.util.Collections;
import java.util.Map;

public class Component
extends AbstractOptionable
implements Comparable,
Optionable {
    private final String _name;
    private final ComponentType _type;
    private final UnmodifiableMap<Variable, Value> _initial;
    private final UnmodifiableMap<Port, ComponentPort> _instancedPort;
    private final UnmodifiableMap<Event, ComponentEvent> _componentEvents;
    private final UnmodifiableMap<Assignment, ComponentAssignment> _componentAssignments;
    private final UnmodifiableMap<Rule, ComponentRule> _componentRules;

    public Component(String string, ComponentType componentType) {
        this(string, componentType, null);
    }

    public Component(String string, ComponentType componentType, Map<Variable, Value> map) {
        this(string, componentType, map, Collections.EMPTY_MAP);
    }

    public Component(String string, ComponentType componentType, Map<Variable, Value> map, Map<String, String> map2) {
        super(map2);
        Object object;
        this._name = string;
        this._type = componentType;
        UnmodifiableMapConstructor<Comparable, Object> unmodifiableMapConstructor = new UnmodifiableMapConstructor<Comparable, Object>();
        for (Event abstractOptionable : this._type.events()) {
            object = new ComponentEvent(this, abstractOptionable);
            unmodifiableMapConstructor.addMapping(abstractOptionable, object);
        }
        this._componentEvents = unmodifiableMapConstructor.getMap();
        unmodifiableMapConstructor = new UnmodifiableMapConstructor();
        for (Variable variable : this._type.variables()) {
            for (Assignment assignment : variable.assignments()) {
                ComponentAssignment componentAssignment = new ComponentAssignment(this, assignment);
                unmodifiableMapConstructor.addMapping(assignment, componentAssignment);
            }
        }
        this._componentAssignments = unmodifiableMapConstructor.getMap();
        unmodifiableMapConstructor = new UnmodifiableMapConstructor();
        for (Rule rule : this._type.rules()) {
            object = new ComponentRule(this, rule);
            unmodifiableMapConstructor.addMapping(rule, object);
        }
        this._componentRules = unmodifiableMapConstructor.getMap();
        unmodifiableMapConstructor = new UnmodifiableMapConstructor();
        for (Port port : this._type.ports()) {
            object = new ComponentPort(this, port);
            unmodifiableMapConstructor.addMapping(port, object);
        }
        this._instancedPort = unmodifiableMapConstructor.getMap();
        this._initial = map != null ? new UnmodifiableMapConstructor<Variable, Value>(map).getMap() : null;
    }

    public final String getLabel() {
        return this._name;
    }

    public final String getName() {
        return this._name;
    }

    public final String toString() {
        return this._name;
    }

    public final ComponentType getType() {
        return this._type;
    }

    public final int hashCode() {
        return this.getName().hashCode();
    }

    public final boolean equals(Object object) {
        return this == object;
    }

    public final Variable getVariable(String string) {
        return this._type.getVariable(string);
    }

    public final Port getInputPort(String string) {
        return this._type.getInputPort(string);
    }

    public final Port getOutputPort(String string) {
        return this._type.getOutputPort(string);
    }

    public final boolean isSpontaneousEvent(Event event) {
        return this._type.isSpontaneousEvent(event);
    }

    public final boolean isSpontaneousPort(Port port) {
        return this._type.isSpontaneousPort(port);
    }

    public final boolean isActionEvent(Event event) {
        return this._type.isActionEvent(event);
    }

    public final boolean isActionPort(Port port) {
        return this._type.isActionPort(port);
    }

    public final int numberOfInputPorts() {
        return this._type.numberOfInputPorts();
    }

    public final UnmodifiableSet<Port> inputPorts() {
        return this._type.inputPorts();
    }

    public final int numberOfOutputPorts() {
        return this._type.numberOfOutputPorts();
    }

    public final UnmodifiableSet<Port> outputPorts() {
        return this._type.outputPorts();
    }

    public final UnmodifiableSet<Variable> variables() {
        return this._type.variables();
    }

    public final UnmodifiableSet<Rule> rules() {
        return this._type.rules();
    }

    public final TypeStateCondition getSafetyRule(Port port) {
        return this._type.getSafetyRule(port);
    }

    public final Value getInitialValue(Variable variable) {
        Value value = this._initial.get(variable);
        if (value != null) {
            return value;
        }
        return variable.defaultValue();
    }

    public final Assignment getInitialAssignement(Variable variable) {
        Value value = this.getInitialValue(variable);
        return variable.getAssignement(value);
    }

    public ComponentPort getComponentPort(Port port) {
        return this._instancedPort.get(port);
    }

    public Port getPort(String string) {
        Port port = this.getInputPort(string);
        if (port == null) {
            port = this.getOutputPort(string);
        }
        return port;
    }

    public ComponentEvent getComponentEvent(Event event) {
        return this._componentEvents.get(event);
    }

    public ComponentAssignment getComponentAssignment(Assignment assignment) {
        return this._componentAssignments.get(assignment);
    }

    public ComponentRule getComponentRule(Rule rule) {
        return this._componentRules.get(rule);
    }

    public int compareTo(Object object) {
        Component component = (Component)object;
        return this.hashCode() - component.hashCode();
    }

    public TypeState defaultTypeState() {
        return new TS();
    }

    public ComponentState defaultState() {
        return new BasicComponentState(this, this.defaultTypeState());
    }

    class TS
    extends AbstractTypeState {
        TS() {
        }

        @Override
        public ComponentType getComponentType() {
            return Component.this.getType();
        }

        @Override
        public Value getValue(Variable variable) {
            return Component.this.getInitialValue(variable);
        }

        @Override
        public TypeState apply(Assignment assignment) {
            MapTypeState mapTypeState = new MapTypeState(this);
            return ((TypeState)mapTypeState).apply(assignment);
        }

        @Override
        public UnmodifiableSet<Map.Entry<Variable, Value>> entrySet() {
            UnmodifiableSetConstructor<1> unmodifiableSetConstructor = new UnmodifiableSetConstructor<1>();
            for (final Variable variable : Component.this.variables()) {
                final Value value = this.getValue(variable);
                Map.Entry<Variable, Value> entry = new Map.Entry<Variable, Value>(){

                    @Override
                    public Variable getKey() {
                        return variable;
                    }

                    @Override
                    public Value getValue() {
                        return value;
                    }

                    @Override
                    public Value setValue(Value value2) {
                        throw new UnsupportedOperationException("Not supported.");
                    }
                };
                unmodifiableSetConstructor.add(entry);
            }
            return unmodifiableSetConstructor.getSet();
        }

        @Override
        public UnmodifiableSet<Variable> keySet() {
            return Component.this.variables();
        }

        @Override
        public Value get(Object object) {
            if (object instanceof Variable) {
                Variable variable = (Variable)object;
                return this.getValue(variable);
            }
            return null;
        }

        @Override
        public UnmodifiableCollection<Value> values() {
            UnmodifiableListConstructor<Value> unmodifiableListConstructor = new UnmodifiableListConstructor<Value>();
            for (Variable variable : Component.this.variables()) {
                unmodifiableListConstructor.addElement(this.getValue(variable));
            }
            return unmodifiableListConstructor.getList();
        }

        @Override
        public TypeState putElement(Variable variable, Value value) {
            return new MapTypeState(this, variable.getAssignement(value));
        }
    }
}

