/*
 * Decompiled with CFR 0.152.
 */
package edu.supercom.csdl;

import edu.supercom.csdl.Component;
import edu.supercom.csdl.Event;
import edu.supercom.csdl.Message;
import edu.supercom.csdl.Port;
import edu.supercom.csdl.Topology;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ComponentEvent
implements Comparable<ComponentEvent> {
    private final Component _comp;
    private final Event _event;

    ComponentEvent(Component component, Event event) {
        this._comp = component;
        this._event = event;
    }

    public Component getComponent() {
        return this._comp;
    }

    public Event getEvent() {
        return this._event;
    }

    public static ComponentEvent read(String string, Topology topology) {
        return ComponentEvent.read(string, topology, "\\s");
    }

    public static ComponentEvent read(String string, Topology topology, String string2) {
        String[] stringArray = Pattern.compile(string2);
        Matcher matcher = stringArray.matcher("");
        if (matcher.matches()) {
            throw new IllegalArgumentException("Illegal regex parameter: accepts the empty string.");
        }
        int n = (stringArray = string.split(string2))[0].length() == 0 ? 1 : 0;
        Component component = topology.getComponent(stringArray[n]);
        if (component == null) {
            return null;
        }
        Port port = component.getType().getPort(stringArray[n + 1]);
        if (port == null) {
            return null;
        }
        Message message = port.getMessage(stringArray[n + 2]);
        if (message == null) {
            return null;
        }
        Event event = port.getEvent(message);
        ComponentEvent componentEvent = component.getComponentEvent(event);
        return componentEvent;
    }

    public String toString() {
        return this._comp.getName() + "." + this._event.getPort().getName() + "." + this._event.getMessage().getLabel();
    }

    @Override
    public int compareTo(ComponentEvent componentEvent) {
        int n = this._comp.compareTo(componentEvent._comp);
        if (n == 0) {
            n = this._event.compareTo(componentEvent._event);
        }
        return n;
    }
}

