/*
 * Decompiled with CFR 0.152.
 */
package edu.supercom.csdl;

import edu.supercom.csdl.Component;
import edu.supercom.csdl.ComponentEvent;
import edu.supercom.csdl.Event;
import edu.supercom.csdl.Port;
import edu.supercom.util.UnmodifiableList;
import edu.supercom.util.UnmodifiableListConstructor;

public final class ComponentPort
implements Comparable<ComponentPort> {
    private final Component _comp;
    private final Port _port;
    private final UnmodifiableList<ComponentEvent> _cevents;

    public ComponentPort(Component component, Port port) {
        this._comp = component;
        this._port = port;
        UnmodifiableListConstructor<ComponentEvent> unmodifiableListConstructor = new UnmodifiableListConstructor<ComponentEvent>();
        for (Event event : port.events()) {
            unmodifiableListConstructor.addElement(component.getComponentEvent(event));
        }
        this._cevents = unmodifiableListConstructor.getList();
    }

    public Component getComponent() {
        return this._comp;
    }

    public Port getPort() {
        return this._port;
    }

    public UnmodifiableList<ComponentEvent> getComponentEvents() {
        return this._cevents;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object object) {
        return object == this;
    }

    @Override
    public int compareTo(ComponentPort componentPort) {
        int n = this._comp.compareTo(componentPort._comp);
        if (n != 0) {
            n = this._port.compareTo(componentPort._port);
        }
        return n;
    }

    public String toString() {
        return this._port.getName() + "[" + this._comp.getName() + "]";
    }
}

