/*
 * Decompiled with CFR 0.152.
 */
package edu.supercom.csdl;

import edu.supercom.csdl.AbstractTypeState;
import edu.supercom.csdl.Assignment;
import edu.supercom.csdl.Domain;
import edu.supercom.csdl.Event;
import edu.supercom.csdl.MapTypeState;
import edu.supercom.csdl.Port;
import edu.supercom.csdl.Rule;
import edu.supercom.csdl.TypeState;
import edu.supercom.csdl.TypeStateCondition;
import edu.supercom.csdl.Value;
import edu.supercom.csdl.Variable;
import edu.supercom.util.UnmodifiableCollection;
import edu.supercom.util.UnmodifiableList;
import edu.supercom.util.UnmodifiableListConstructor;
import edu.supercom.util.UnmodifiableMap;
import edu.supercom.util.UnmodifiableMapConstructor;
import edu.supercom.util.UnmodifiableSet;
import edu.supercom.util.UnmodifiableSetConstructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class ComponentType {
    private final String _name;
    private final UnmodifiableSet<Variable> _variables;
    private final UnmodifiableMap<String, Variable> _varMap;
    private final UnmodifiableSet<Rule> _rules;
    private final UnmodifiableSet<Port> _inputPorts;
    private final UnmodifiableMap<String, Port> _inputPortsMap;
    private final UnmodifiableSet<Port> _outputPorts;
    private final UnmodifiableMap<String, Port> _outputPortsMap;
    private final UnmodifiableList<Port> _ports;
    private final Port _spontaneousPort;
    private final Port _actionPort;
    private final UnmodifiableMap<Port, TypeStateCondition> _safetyRules;
    private final UnmodifiableSet<Event> _events;
    private final UnmodifiableMap<Event, UnmodifiableSet<Rule>> _rulesOfEvent;
    private final UnmodifiableMap<Variable, UnmodifiableSet<Rule>> _rulesAffectedByVariable;
    private final UnmodifiableMap<Assignment, UnmodifiableSet<Rule>> _rulesAffectingAssignement;

    public ComponentType(String string, Collection<Variable> collection, Collection<Rule> collection2, Collection<Port> collection3, Collection<Port> collection4, Port port, Port port2, Map<Port, TypeStateCondition> map) {
        if (string == null || string.equals("")) {
            throw new IllegalArgumentException("A component type cannot have such a name " + string);
        }
        this._name = string;
        this._rules = new UnmodifiableSetConstructor<Rule>(collection2).getSet();
        Object object4 = new HashSet<Event>();
        Object object5 = new ArrayList<Port>();
        HashMap<String, Variable> hashMap = new UnmodifiableSetConstructor<Port>(collection3);
        this._inputPorts = ((UnmodifiableSetConstructor)((Object)hashMap)).getSet();
        Object object6 = new UnmodifiableMapConstructor<String, Port>();
        for (Port port3 : collection3) {
            object5.add(port3);
            if (((UnmodifiableMapConstructor)object6).containsKey(port3.getName())) {
                throw new IllegalArgumentException("Two ports with the same name " + port3.getName());
            }
            ((UnmodifiableMapConstructor)object6).put(port3.getName(), port3);
            object4.addAll(port3.events());
        }
        this._inputPortsMap = ((UnmodifiableMapConstructor)object6).getMap();
        hashMap = new UnmodifiableSetConstructor<Port>(collection4);
        this._outputPorts = ((UnmodifiableSetConstructor)((Object)hashMap)).getSet();
        object6 = new UnmodifiableMapConstructor();
        for (Port port4 : collection4) {
            object5.add(port4);
            if (((UnmodifiableMapConstructor)object6).containsKey(port4.getName()) || this._inputPortsMap.containsKey(port4.getName())) {
                throw new IllegalArgumentException("Two ports with the same name " + port4.getName());
            }
            ((UnmodifiableMapConstructor)object6).put(port4.getName(), port4);
            object4.addAll(port4.events());
        }
        this._outputPortsMap = ((UnmodifiableMapConstructor)object6).getMap();
        if (port != null) {
            object5.add(port);
            if (this._outputPortsMap.containsKey(port.getName()) || this._inputPortsMap.containsKey(port.getName())) {
                throw new IllegalArgumentException("Two ports with the same name " + port.getName());
            }
            this._spontaneousPort = port;
            object4.addAll(port.events());
        } else {
            this._spontaneousPort = null;
        }
        if (port2 != null) {
            object5.add(port2);
            if (this._outputPortsMap.containsKey(port2.getName()) || this._inputPortsMap.containsKey(port2.getName())) {
                throw new IllegalArgumentException("Two ports with the same name " + port2.getName());
            }
            this._actionPort = port2;
            object4.addAll(port2.events());
        } else {
            this._actionPort = null;
        }
        hashMap = new UnmodifiableListConstructor(object5);
        this._ports = ((UnmodifiableListConstructor)((Object)hashMap)).getList();
        object6 = new UnmodifiableSetConstructor(object4);
        this._events = ((UnmodifiableSetConstructor)object6).getSet();
        object4 = new UnmodifiableMapConstructor();
        object5 = new UnmodifiableMapConstructor();
        hashMap = new HashMap<String, Variable>();
        for (Variable variable : collection) {
            String string2 = variable.getName();
            if (hashMap.containsKey(string2)) {
                throw new IllegalArgumentException("Two variables with the same name " + string2);
            }
            if ((this._outputPortsMap.containsKey(string2) || this._inputPortsMap.containsKey(string2)) && variable.getDomain() != Domain.portVariablesDomain()) {
                throw new IllegalArgumentException("The domain of the variable " + variable.getName() + " is not correct.");
            }
            hashMap.put(variable.getName(), variable);
            ((UnmodifiableMapConstructor)object4).addMapping(variable, new UnmodifiableSetConstructor());
            for (Assignment assignment : variable.assignments()) {
                ((UnmodifiableMapConstructor)object5).put(assignment, new UnmodifiableSetConstructor());
            }
        }
        object6 = new UnmodifiableSetConstructor<Variable>(collection);
        this._variables = ((UnmodifiableSetConstructor)object6).getSet();
        UnmodifiableMapConstructor unmodifiableMapConstructor = new UnmodifiableMapConstructor(hashMap);
        this._varMap = unmodifiableMapConstructor.getMap();
        UnmodifiableMapConstructor<Port, TypeStateCondition> unmodifiableMapConstructor2 = new UnmodifiableMapConstructor<Port, TypeStateCondition>(map);
        this._safetyRules = unmodifiableMapConstructor2.getMap();
        HashMap hashMap2 = new HashMap();
        for (Event event : this._events) {
            hashMap2.put(event, new UnmodifiableSetConstructor());
        }
        for (Rule rule : this._rules) {
            Event event = rule.getTriggeringEvent();
            ((UnmodifiableSetConstructor)hashMap2.get(event)).add(rule);
            for (Event event2 : rule.outputEvents()) {
                ((UnmodifiableSetConstructor)hashMap2.get(event2)).add(rule);
            }
            Map<Map<Variable, Value>, Map<Variable, Value>> map2 = rule.getEffect().assignments();
            for (Map<Variable, Value> map3 : map2.values()) {
                for (Object object : map3.keySet()) {
                    Value value = map3.get(object);
                    Assignment assignment = ((Variable)object).getAssignement(value);
                    ((UnmodifiableSetConstructor)((UnmodifiableMapConstructor)object4).get(assignment.getVariable())).add(rule);
                    ((UnmodifiableSetConstructor)((UnmodifiableMapConstructor)object5).get(assignment)).add(rule);
                }
            }
        }
        UnmodifiableMapConstructor<Object, Object> unmodifiableMapConstructor3 = new UnmodifiableMapConstructor();
        for (Event event : this._events) {
            UnmodifiableSetConstructor unmodifiableSetConstructor = (UnmodifiableSetConstructor)hashMap2.get(event);
            UnmodifiableSet unmodifiableSet = unmodifiableSetConstructor.getSet();
            unmodifiableMapConstructor3.put(event, unmodifiableSet);
        }
        this._rulesOfEvent = unmodifiableMapConstructor3.getMap();
        unmodifiableMapConstructor3 = new UnmodifiableMapConstructor<Object, Object>();
        for (Variable variable : collection) {
            UnmodifiableSetConstructor unmodifiableSetConstructor = (UnmodifiableSetConstructor)((UnmodifiableMapConstructor)object4).get(variable);
            UnmodifiableSet unmodifiableSet = unmodifiableSetConstructor.getSet();
            unmodifiableMapConstructor3.addMapping(variable, unmodifiableSet);
        }
        this._rulesAffectedByVariable = unmodifiableMapConstructor3.getMap();
        unmodifiableMapConstructor3 = new UnmodifiableMapConstructor();
        for (Variable variable : collection) {
            for (Assignment assignment : variable.assignments()) {
                Object object;
                UnmodifiableSetConstructor unmodifiableSetConstructor = (UnmodifiableSetConstructor)((UnmodifiableMapConstructor)object5).get(assignment);
                object = unmodifiableSetConstructor.getSet();
                unmodifiableMapConstructor3.addMapping(assignment, object);
            }
        }
        this._rulesAffectingAssignement = unmodifiableMapConstructor3.getMap();
    }

    public final String getName() {
        return this._name;
    }

    public final Variable getVariable(String string) {
        return this._varMap.get(string);
    }

    public final Port getInputPort(String string) {
        return this._inputPortsMap.get(string);
    }

    public final Port getOutputPort(String string) {
        return this._outputPortsMap.get(string);
    }

    public final Port getPort(String string) {
        Port port = this.getInputPort(string);
        if (port != null) {
            return port;
        }
        return this.getOutputPort(string);
    }

    public final Port getSpontaneousPort() {
        return this._spontaneousPort;
    }

    public final Port getActionPort() {
        return this._actionPort;
    }

    public final boolean isSpontaneousEvent(Event event) {
        return this.isSpontaneousPort(event.getPort());
    }

    public final boolean isSpontaneousPort(Port port) {
        return this._spontaneousPort == port;
    }

    public final boolean isActionEvent(Event event) {
        return this.isActionPort(event.getPort());
    }

    public final boolean isActionPort(Port port) {
        return this._actionPort == port;
    }

    public final int numberOfInputPorts() {
        return this._inputPortsMap.size();
    }

    public final UnmodifiableSet<Port> inputPorts() {
        return this._inputPorts;
    }

    public final int numberOfOutputPorts() {
        return this._outputPortsMap.size();
    }

    public final UnmodifiableSet<Port> outputPorts() {
        return this._outputPorts;
    }

    public final UnmodifiableCollection<Port> ports() {
        return this._ports;
    }

    public final UnmodifiableSet<Variable> variables() {
        return this._variables;
    }

    public final UnmodifiableSet<Rule> rules() {
        return this._rules;
    }

    public boolean hasRule(Rule rule) {
        return this._rules.contains(rule);
    }

    public final TypeStateCondition getSafetyRule(Port port) {
        return this._safetyRules.get(port);
    }

    public final UnmodifiableSet<Event> events() {
        return this._events;
    }

    public UnmodifiableSet<Rule> triggeringRules(Event event) {
        return this._rulesOfEvent.get(event);
    }

    public UnmodifiableSet<Rule> generatingRules(Event event) {
        return this._rulesOfEvent.get(event);
    }

    public UnmodifiableSet<Rule> rulesOfEvent(Event event) {
        return this._rulesOfEvent.get(event);
    }

    public UnmodifiableSet<TypeState> getStates() {
        Object object;
        Object object3 = new HashSet();
        object3.add(new HashMap());
        for (Variable object22 : this.variables()) {
            object = new HashSet();
            for (Value value : object22.getDomain()) {
                Iterator iterator = object3.iterator();
                while (iterator.hasNext()) {
                    Map map = (Map)iterator.next();
                    HashMap<Variable, Value> hashMap = new HashMap<Variable, Value>(map);
                    hashMap.put(object22, value);
                    object.add(hashMap);
                }
            }
            object3 = object;
        }
        UnmodifiableSetConstructor unmodifiableSetConstructor = new UnmodifiableSetConstructor();
        Iterator iterator = object3.iterator();
        while (iterator.hasNext()) {
            object = (Map)iterator.next();
            unmodifiableSetConstructor.add(new MapTypeState(this, (Map<Variable, Value>)object));
        }
        return unmodifiableSetConstructor.getSet();
    }

    public TypeState defaultTypeState() {
        return new ComponentTypeState();
    }

    public UnmodifiableCollection<Rule> ruleAffecting(Assignment assignment) {
        return this._rulesAffectingAssignement.get(assignment);
    }

    class ComponentTypeState
    extends AbstractTypeState {
        ComponentTypeState() {
        }

        @Override
        public ComponentType getComponentType() {
            return ComponentType.this;
        }

        @Override
        public Value getValue(Variable variable) {
            return variable.defaultValue();
        }

        @Override
        public TypeState apply(Assignment assignment) {
            MapTypeState mapTypeState = new MapTypeState(this);
            TypeState typeState = ((TypeState)mapTypeState).apply(assignment);
            return typeState;
        }

        @Override
        public UnmodifiableSet<Map.Entry<Variable, Value>> entrySet() {
            UnmodifiableSetConstructor<1> unmodifiableSetConstructor = new UnmodifiableSetConstructor<1>();
            for (final Variable variable : ComponentType.this.variables()) {
                final Value value = variable.defaultValue();
                unmodifiableSetConstructor.add(new Map.Entry<Variable, Value>(){

                    @Override
                    public Variable getKey() {
                        return variable;
                    }

                    @Override
                    public Value getValue() {
                        return value;
                    }

                    @Override
                    public Value setValue(Value value2) {
                        throw new UnsupportedOperationException("Not supported.");
                    }
                });
            }
            return unmodifiableSetConstructor.getSet();
        }

        @Override
        public UnmodifiableSet<Variable> keySet() {
            return ComponentType.this.variables();
        }

        @Override
        public Value get(Object object) {
            if (object instanceof Variable) {
                Variable variable = (Variable)object;
                return variable.defaultValue();
            }
            return null;
        }

        @Override
        public UnmodifiableCollection<Value> values() {
            UnmodifiableListConstructor<Value> unmodifiableListConstructor = new UnmodifiableListConstructor<Value>();
            for (Variable variable : ComponentType.this.variables()) {
                Value value = variable.defaultValue();
                unmodifiableListConstructor.addElement(value);
            }
            return unmodifiableListConstructor.getList();
        }

        @Override
        public TypeState putElement(Variable variable, Value value) {
            return new MapTypeState(this, variable.getAssignement(value));
        }
    }
}

