/*
 * Decompiled with CFR 0.152.
 */
package edu.supercom.csdl;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import edu.supercom.csdl.Component;
import edu.supercom.csdl.ComponentEvent;
import edu.supercom.csdl.ComponentType;
import edu.supercom.csdl.Configuration;
import edu.supercom.csdl.Event;
import edu.supercom.csdl.MapSystemState;
import edu.supercom.csdl.Message;
import edu.supercom.csdl.Port;
import edu.supercom.csdl.ReconfigurationPattern;
import edu.supercom.csdl.SystemState;
import edu.supercom.csdl.Topology;
import edu.supercom.csdl.Value;
import edu.supercom.csdl.Variable;
import edu.supercom.csdl.parser.CsdlLexer;
import edu.supercom.csdl.parser.CsdlParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CompositeSystem {
    private final String _name;
    private boolean _init;
    private final Map<String, Message> _labelToMessage;
    private Set<Component> _components;
    private Map<String, Component> _nameToComp;
    private Map<ComponentType, Set<Component>> _typeToComponents;
    private Set<ComponentType> _types;
    private Configuration _initialConfiguration;
    private Set<ReconfigurationPattern> _reconfigurations;
    private Map<String, ReconfigurationPattern> _nameToReconfiguration;
    private Map<ComponentType, Set<Component>> _compsOfType;

    public CompositeSystem(String string) {
        this._name = string;
        this._init = false;
        this._labelToMessage = new HashMap<String, Message>();
    }

    public Message getMessage(String string) {
        Message message = this._labelToMessage.get(string);
        if (message != null) {
            return message;
        }
        if (this._init) {
            throw new IllegalArgumentException("Impossible to create the message " + string + "since the composite system is already initialised.");
        }
        message = new Message(string);
        this._labelToMessage.put(string, message);
        return message;
    }

    public synchronized void init(Collection<Component> collection, Configuration configuration, Collection<ReconfigurationPattern> collection2) {
        if (this._init) {
            throw new UnsupportedOperationException("The initialisation of the composite system has already been performed.");
        }
        Topology topology = configuration.getTopology();
        this._components = Collections.unmodifiableSet(new HashSet<Component>(collection));
        HashMap<Object, Object> hashMap = new HashMap<String, Component>();
        Object object32 = new HashMap<ComponentType, HashSet<Component>>(collection.size());
        HashSet<ComponentType> object22 = new HashSet<ComponentType>();
        for (Component component : collection) {
            if (hashMap.put(component.getName(), component) != null) {
                throw new IllegalArgumentException("Two components have the same name " + component.getName() + ".");
            }
            ComponentType componentType = component.getType();
            HashSet<Component> hashSet = (HashSet<Component>)object32.get(componentType);
            if (hashSet == null) {
                hashSet = new HashSet<Component>();
                object32.put(componentType, hashSet);
            }
            hashSet.add(component);
            object22.add(componentType);
        }
        this._nameToComp = Collections.unmodifiableMap(hashMap);
        this._typeToComponents = Collections.unmodifiableMap(object32);
        this._types = Collections.unmodifiableSet(object22);
        this._initialConfiguration = configuration;
        for (Object object32 : topology.activeSubsystem()) {
            if (this._components.contains(object32)) continue;
            throw new IllegalArgumentException("Component " + ((Component)object32).getName() + " in the initial topology" + " is not a component of the composite system.");
        }
        this._reconfigurations = Collections.unmodifiableSet(new HashSet(collection2.size()));
        hashMap = new HashMap<Object, Object>(collection2.size());
        for (ReconfigurationPattern reconfigurationPattern : collection2) {
            if (hashMap.put(reconfigurationPattern.getName(), reconfigurationPattern) == null) continue;
            throw new IllegalArgumentException("Two reconfigurations have the same name " + reconfigurationPattern.getName() + ".");
        }
        this._nameToReconfiguration = Collections.unmodifiableMap(hashMap);
        hashMap = new HashMap();
        for (ComponentType componentType : this._types) {
            hashMap.put(componentType, new HashSet());
        }
        for (Component component : this._components) {
            ((Set)hashMap.get(component.getType())).add(component);
        }
        for (ComponentType componentType : this._types) {
            hashMap.put(componentType, Collections.unmodifiableSet((Set)hashMap.get(componentType)));
        }
        this._compsOfType = Collections.unmodifiableMap(hashMap);
        this._init = true;
    }

    public Iterator<Component> componentIterator() {
        return this.components().iterator();
    }

    public Set<Component> components() {
        if (this._init) {
            return this._components;
        }
        throw new IllegalArgumentException("The composite system was not initialised.");
    }

    public Component getComponent(String string) {
        if (this._init) {
            return this._nameToComp.get(string);
        }
        throw new IllegalArgumentException("The composite system was not initialised.");
    }

    public Iterator<Component> componentIterator(ComponentType componentType) {
        return this.components().iterator();
    }

    public Set<Component> components(ComponentType componentType) {
        if (this._init) {
            return this._typeToComponents.get(componentType);
        }
        throw new IllegalArgumentException("The composite system was not initialised.");
    }

    public Iterator<ComponentType> typeIterator() {
        return this.types().iterator();
    }

    public Collection<ComponentType> types() {
        if (this._init) {
            return this._types;
        }
        throw new IllegalArgumentException("The composite system was not initialised.");
    }

    public Configuration getInitialConfiguration() {
        return this._initialConfiguration;
    }

    public Topology getInitialTopology() {
        return this._initialConfiguration.getTopology();
    }

    public Iterator<ReconfigurationPattern> reconfigurationIterator() {
        return this.reconfigurations().iterator();
    }

    public Set<ReconfigurationPattern> reconfigurations() {
        if (this._init) {
            return this._reconfigurations;
        }
        throw new IllegalArgumentException("The composite system was not initialised.");
    }

    public ReconfigurationPattern getReconfiguration(String string) {
        return this._nameToReconfiguration.get(string);
    }

    public static CompositeSystem load(String string) throws IOException, RecognitionException, TokenStreamException {
        int n = string.lastIndexOf(File.separator);
        String string2 = n == -1 ? "." + File.separator : string.substring(0, n + File.separator.length());
        CompositeSystem[] compositeSystemArray = new CompositeSystem[1];
        CsdlLexer csdlLexer = new CsdlLexer(new FileReader(string));
        CsdlParser csdlParser = new CsdlParser(csdlLexer);
        csdlParser.compositeSystem(string2, compositeSystemArray);
        return compositeSystemArray[0];
    }

    public Collection<String> componentNames() {
        HashSet<String> hashSet = new HashSet<String>();
        for (Component component : this.components()) {
            hashSet.add(component.getName());
        }
        return hashSet;
    }

    public Collection<String> portNames() {
        HashSet<String> hashSet = new HashSet<String>();
        for (ComponentType componentType : this.types()) {
            for (Port port : componentType.ports()) {
                if (componentType.isSpontaneousPort(port) || componentType.isActionPort(port)) continue;
                hashSet.add(port.getName());
            }
        }
        return hashSet;
    }

    public String name() {
        return this._name;
    }

    public List<ComponentEvent> readEvents(String string, String string2, String string3) throws IOException {
        ArrayList<ComponentEvent> arrayList = new ArrayList<ComponentEvent>();
        if (string2 == null) {
            string2 = "\\.";
        }
        if (string3 == null) {
            string3 = "(\\s)*%";
        }
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        Pattern pattern = Pattern.compile(string3);
        Pattern pattern2 = Pattern.compile(string2);
        while (bufferedReader.ready()) {
            String string4 = bufferedReader.readLine();
            Matcher matcher = pattern.matcher(string4);
            String string5 = matcher.find() ? string4.substring(0, matcher.start()) : string4;
            if (string5.equals("")) continue;
            Matcher matcher2 = pattern2.matcher(string5);
            int n = 0;
            if (!matcher2.find()) {
                throw new IllegalArgumentException(string4);
            }
            int n2 = matcher2.start();
            String string6 = string5.substring(n, n2);
            n = matcher2.end();
            if (!matcher2.find()) {
                throw new IllegalArgumentException(string4);
            }
            n2 = matcher2.start();
            String string7 = string5.substring(n, n2);
            n = matcher2.end();
            String string8 = string5.substring(n);
            Component component = this.getComponent(string6);
            ComponentType componentType = component.getType();
            Port port = componentType.getPort(string7);
            Event event = port.getEvent(port.getMessage(string8));
            ComponentEvent componentEvent = component.getComponentEvent(event);
            arrayList.add(componentEvent);
        }
        return arrayList;
    }

    public SystemState readState(Topology topology, String string) throws IOException {
        HashMap<Component, Map<Variable, Value>> hashMap = new HashMap<Component, Map<Variable, Value>>();
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        Pattern pattern = Pattern.compile("(\\s)*%");
        Pattern pattern2 = Pattern.compile("([^\\s]+)?\\s+([^\\s]+)\\s+([^\\s]+)");
        Component component = null;
        while (bufferedReader.ready()) {
            Matcher matcher;
            String string2 = bufferedReader.readLine();
            Matcher matcher2 = pattern.matcher(string2);
            String string3 = matcher2.find() ? string2.substring(0, matcher2.start()) : string2;
            if (string3.equals("") || !(matcher = pattern2.matcher(string3)).matches()) continue;
            String string4 = matcher.group(1);
            String string5 = matcher.group(2);
            String string6 = matcher.group(3);
            if (!string4.equals("")) {
                component = this.getComponent(string4);
            }
            ComponentType componentType = component.getType();
            Variable variable = componentType.getVariable(string5);
            Value value = variable.getValue(string6);
            HashMap<Variable, Value> hashMap2 = (HashMap<Variable, Value>)hashMap.get(component);
            if (hashMap2 == null) {
                hashMap2 = new HashMap<Variable, Value>();
                hashMap.put(component, hashMap2);
            }
            hashMap2.put(variable, value);
        }
        return new MapSystemState(topology, hashMap);
    }
}

