/*
 * Decompiled with CFR 0.152.
 */
package edu.supercom.csdl;

import edu.supercom.csdl.Component;
import edu.supercom.csdl.ComponentType;
import edu.supercom.csdl.CompositeSystem;
import edu.supercom.csdl.Configuration;
import edu.supercom.csdl.Message;
import edu.supercom.csdl.ReconfigurationPattern;
import edu.supercom.util.UnmodifiableMapConstructor;
import edu.supercom.util.UnmodifiableSetConstructor;
import java.util.HashSet;
import java.util.Set;

public class CompositeSystemGenerator {
    private static final String ACCESSED = " since the composite system was already accessed.";
    private boolean _accessed = false;
    private final UnmodifiableMapConstructor<String, Message> _stringToMess = new UnmodifiableMapConstructor();
    private final UnmodifiableSetConstructor<ComponentType> _types = new UnmodifiableSetConstructor();
    private final Set<String> _typeNames = new HashSet<String>();
    private final UnmodifiableSetConstructor<Component> _comps = new UnmodifiableSetConstructor();
    private final UnmodifiableMapConstructor<String, ReconfigurationPattern> _pats = new UnmodifiableMapConstructor();

    public Message getMessage(String string) {
        Message message = this._stringToMess.get(string);
        if (message != null) {
            return message;
        }
        if (this._accessed) {
            throw new IllegalStateException("Impossible to create the message " + string + ACCESSED);
        }
        message = new Message(string);
        return message;
    }

    public void addComponentType(ComponentType componentType) {
        if (this._types.add(componentType)) {
            String string = componentType.getName();
            if (this._typeNames.add(string)) {
                return;
            }
            this._types.remove(componentType);
            throw new IllegalArgumentException("Cannot add component type " + string + ": a component type with same name already exists");
        }
    }

    public void addComponent(Component component) {
        if (this._accessed) {
            throw new IllegalStateException("Cannot add component " + component.getName() + ACCESSED);
        }
        this.addComponentType(component.getType());
        this._comps.add(component);
    }

    public void addReconfiguration(ReconfigurationPattern reconfigurationPattern) {
        String string = reconfigurationPattern.getName();
        if (this._accessed) {
            throw new IllegalStateException("Cannot add reconfiguration pattern " + string + ACCESSED);
        }
        if (this._pats.containsKey(reconfigurationPattern)) {
            throw new IllegalArgumentException("Cannot add reconfiguration pattern " + string + ACCESSED);
        }
        this._pats.addMapping(string, reconfigurationPattern);
    }

    public CompositeSystem getCompositeSystem(String string, Configuration configuration) {
        CompositeSystem compositeSystem = new CompositeSystem(string);
        compositeSystem.init(this._comps.getSet(), configuration, this._pats.values());
        return compositeSystem;
    }
}

