/*
 * Decompiled with CFR 0.152.
 */
package edu.supercom.csdl;

import edu.supercom.csdl.Component;
import edu.supercom.csdl.Port;

public class Connection
implements Comparable<Connection> {
    private final Component _sourceComp;
    private final Port _sourcePort;
    private final Component _targetComp;
    private final Port _targetPort;
    private final int _hash;

    public Connection(Component component, Port port, Component component2, Port port2) {
        if (port.isInputPort()) {
            throw new IllegalArgumentException("Port " + port + " should be an output port.");
        }
        if (!port2.isInputPort()) {
            throw new IllegalArgumentException("Port " + port2 + " should be an input port.");
        }
        this._sourceComp = component;
        this._sourcePort = port;
        this._targetComp = component2;
        this._targetPort = port2;
        this._hash = this._sourceComp.hashCode() * this._sourcePort.hashCode() + this._targetComp.hashCode() * this._targetPort.hashCode();
    }

    public final int hashCode() {
        return this._hash;
    }

    public boolean equals(Object object) {
        if (object instanceof Connection) {
            Connection connection = (Connection)object;
            return this._sourceComp == connection._sourceComp && this._sourcePort == connection._sourcePort && this._targetComp == connection._targetComp && this._targetPort == connection._targetPort;
        }
        return false;
    }

    public Component getSourceComponent() {
        return this._sourceComp;
    }

    public Component getTargetComponent() {
        return this._targetComp;
    }

    public Port getSourcePort() {
        return this._sourcePort;
    }

    public Port getTargetPort() {
        return this._targetPort;
    }

    public String toString() {
        return this._sourceComp.getLabel() + "." + this._sourcePort.getName() + "-" + this._targetComp.getLabel() + "." + this._targetPort.getName();
    }

    @Override
    public int compareTo(Connection connection) {
        int n = this._sourceComp.compareTo(connection._sourceComp);
        if (n != 0) {
            return n;
        }
        n = this._targetComp.compareTo(connection._targetComp);
        if (n != 0) {
            return n;
        }
        n = this._sourcePort.compareTo(connection._sourcePort);
        if (n != 0) {
            return n;
        }
        n = this._targetPort.compareTo(connection._targetPort);
        if (n != 0) {
            return n;
        }
        return 0;
    }
}

