/*
 * Decompiled with CFR 0.152.
 */
package edu.supercom.csdl;

import edu.supercom.csdl.Component;
import edu.supercom.csdl.CompositeSystem;
import edu.supercom.csdl.Connection;
import edu.supercom.csdl.Port;
import java.util.Collection;
import java.util.Map;

public class ConnectionAction {
    private String _sourceComp = null;
    private String _targetComp = null;
    private String _sourcePort = null;
    private String _targetPort = null;
    private boolean _isSourceCompVariable = false;
    private boolean _isTargetCompVariable = false;
    private boolean _isSourcePortVariable = false;
    private boolean _isTargetPortVariable = false;

    public ConnectionAction(String string, String string2, String string3, String string4, Collection<String> collection) {
        if (string != null) {
            if (collection.contains(string)) {
                this._isSourceCompVariable = true;
            }
            this._sourceComp = string;
        }
        if (string3 != null) {
            if (collection.contains(string3)) {
                this._isTargetCompVariable = true;
            }
            this._targetComp = string3;
        }
        if (string2 != null) {
            if (collection.contains(string2)) {
                this._isSourcePortVariable = true;
            }
            this._sourcePort = string2;
        }
        if (string4 != null) {
            if (collection.contains(string4)) {
                this._isTargetPortVariable = true;
            }
            this._targetPort = string4;
        }
    }

    public String getSourceComponent(Map<String, String> map) {
        String string;
        if (this._isSourceCompVariable) {
            string = map.get(this._sourceComp);
            if (string == null) {
                throw new IllegalArgumentException("The source component " + this._sourceComp + " is not instanciated.");
            }
        } else {
            string = this._sourceComp;
        }
        return string;
    }

    public String getTargetComponent(Map<String, String> map) {
        String string;
        if (this._isTargetCompVariable) {
            string = map.get(this._targetComp);
            if (string == null) {
                throw new IllegalArgumentException("The target component " + this._targetComp + " is not instanciated.");
            }
        } else {
            string = this._targetComp;
        }
        return string;
    }

    public String getSourcePort(Map<String, String> map) {
        String string;
        if (this._isSourcePortVariable) {
            string = map.get(this._sourcePort);
            if (string == null) {
                throw new IllegalArgumentException("The source port " + this._sourcePort + " is not instanciated.");
            }
        } else {
            string = this._sourcePort;
        }
        return string;
    }

    public String getTargetPort(Map<String, String> map) {
        String string;
        if (this._isTargetPortVariable) {
            string = map.get(this._targetPort);
            if (string == null) {
                throw new IllegalArgumentException("The target port " + this._targetPort + " is not instanciated.");
            }
        } else {
            string = this._targetPort;
        }
        return string;
    }

    public String getSourceComponent() {
        return this._sourceComp;
    }

    public String getTargetComponent() {
        return this._targetComp;
    }

    public String getSourcePort() {
        return this._sourcePort;
    }

    public String getTargetPort() {
        return this._targetPort;
    }

    public Connection getConnection(CompositeSystem compositeSystem, Map<String, String> map) {
        String string = this.getSourceComponent(map);
        String string2 = this.getTargetComponent(map);
        String string3 = this.getSourcePort(map);
        String string4 = this.getTargetPort(map);
        if (string == null) {
            throw new IllegalArgumentException("The variable " + this.getSourceComponent() + " is not instanciated.");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("The variable " + this.getTargetComponent() + " is not instanciated.");
        }
        if (string3 == null) {
            throw new IllegalArgumentException("The variable " + this.getSourcePort() + " is not instanciated.");
        }
        if (string4 == null) {
            throw new IllegalArgumentException("The variable " + this.getTargetPort() + " is not instanciated.");
        }
        Component component = compositeSystem.getComponent(string);
        if (component == null) {
            throw new IllegalArgumentException("The component " + string + " is unknown.");
        }
        Component component2 = compositeSystem.getComponent(string2);
        if (component2 == null) {
            throw new IllegalArgumentException("The component " + string2 + " is unknown.");
        }
        Port port = component.getOutputPort(string3);
        if (port == null) {
            throw new IllegalArgumentException("The output port " + string3 + " is unknown.");
        }
        Port port2 = component2.getInputPort(string4);
        if (port2 == null) {
            throw new IllegalArgumentException("The input port " + string4 + " is unknown.");
        }
        Connection connection = new Connection(component, port, component2, port2);
        return connection;
    }
}

