/*
 * Decompiled with CFR 0.152.
 */
package edu.supercom.csdl;

import edu.supercom.csdl.Value;
import edu.supercom.util.UnmodifiableSet;
import edu.supercom.util.UnmodifiableSetConstructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public final class Domain
implements Iterable<Value> {
    private final Map<String, Value> _map;
    private final UnmodifiableSet<Value> _values;
    private final Value _defaultValue;
    private static final Domain _yesAndNo;

    public Domain(Collection<String> collection, String string) {
        ArrayList<Value> arrayList = new ArrayList<Value>();
        HashMap<String, Value> hashMap = new HashMap<String, Value>();
        HashSet<String> hashSet = new HashSet<String>();
        for (String string2 : collection) {
            if (hashSet.contains(string2)) {
                throw new IllegalArgumentException("Two values cannot have the same name.");
            }
            hashSet.add(string2);
            Value value = new Value(string2);
            arrayList.add(value);
            hashMap.put(string2, value);
        }
        UnmodifiableSetConstructor unmodifiableSetConstructor = new UnmodifiableSetConstructor(arrayList);
        this._values = unmodifiableSetConstructor.getSet();
        this._map = Collections.unmodifiableMap(hashMap);
        this._defaultValue = this.getValue(string);
        if (this._defaultValue == null) {
            throw new IllegalArgumentException("The default value is not part of the domain.");
        }
    }

    public Domain(Collection<Value> collection, Value value) {
        ArrayList<Value> arrayList = new ArrayList<Value>();
        this._map = new HashMap<String, Value>();
        HashSet<String> hashSet = new HashSet<String>();
        for (Value value2 : collection) {
            String string = value2.toString();
            if (hashSet.contains(string)) {
                throw new IllegalArgumentException("Two values cannot have the same name.");
            }
            hashSet.add(string);
            arrayList.add(value2);
            this._map.put(string, value2);
        }
        UnmodifiableSetConstructor<Value> unmodifiableSetConstructor = new UnmodifiableSetConstructor<Value>(collection);
        this._values = unmodifiableSetConstructor.getSet();
        this._defaultValue = this.getValue(value.toString());
        if (this._defaultValue != value) {
            throw new IllegalArgumentException("The default value is not part of the domain.");
        }
    }

    public Value getValue(String string) {
        return this._map.get(string);
    }

    public boolean contains(Value value) {
        return this._values.contains(value);
    }

    public boolean contains(String string) {
        return this._map.containsKey(string);
    }

    public UnmodifiableSet<Value> values() {
        return this._values;
    }

    public Value getDefaultValue() {
        return this._defaultValue;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("{");
        Iterator iterator = this._values.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(((Value)iterator.next()).toString());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public String toString(Value value) {
        StringBuffer stringBuffer = new StringBuffer("{").append(value);
        for (Value value2 : this._values) {
            if (value == value2) continue;
            stringBuffer.append(",").append(value2.toString());
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public String toXml() {
        StringBuffer stringBuffer = new StringBuffer("<Domain>");
        for (Value value : this.values()) {
            stringBuffer.append(value.toXml());
        }
        stringBuffer.append("</Domain>");
        return stringBuffer.toString();
    }

    public static Domain portVariablesDomain() {
        return _yesAndNo;
    }

    public int size() {
        return this._values.size();
    }

    @Override
    public Iterator<Value> iterator() {
        return this._values.iterator();
    }

    static {
        HashSet<String> hashSet = new HashSet<String>(2);
        hashSet.add("yes");
        hashSet.add("no");
        _yesAndNo = new Domain(hashSet, "no");
    }
}

