/*
 * Decompiled with CFR 0.152.
 */
package edu.supercom.csdl;

import edu.supercom.csdl.AbstractOptionable;
import edu.supercom.csdl.Message;
import edu.supercom.csdl.Port;
import edu.supercom.util.Pair;
import java.util.Collections;
import java.util.Map;

public final class Event
extends AbstractOptionable
implements Comparable {
    private final Message _message;
    private final Port _port;

    Event(Port port, Message message) {
        this(port, message, Collections.emptyMap());
    }

    Event(Port port, Message message, Map<String, String> map) {
        super(map);
        this._message = message;
        this._port = port;
    }

    public final int hashCode() {
        return Pair.hashCode(this._message, this._port);
    }

    public final boolean equals(Object object) {
        return this == object;
    }

    public final Port getPort() {
        return this._port;
    }

    public final Message getMessage() {
        return this._message;
    }

    public String getLabel() {
        return this._port.getName() + "." + this._message.getLabel();
    }

    public String toXml() {
        return "<Event>" + this._port.shortXml() + this._message.toXml() + "</Event>";
    }

    public int compareTo(Object object) {
        Event event = (Event)object;
        int n = this._port.compareTo(event._port);
        if (n == 0) {
            n = this._message.compareTo(event._message);
        }
        return n;
    }
}

