/*
 * Decompiled with CFR 0.152.
 */
package edu.supercom.csdl;

import edu.supercom.csdl.AbstractSubsystemRule;
import edu.supercom.csdl.Component;
import edu.supercom.csdl.ComponentRule;
import edu.supercom.csdl.Configuration;
import edu.supercom.csdl.Connection;
import edu.supercom.csdl.Event;
import edu.supercom.csdl.ExplicitSubsystem;
import edu.supercom.csdl.Message;
import edu.supercom.csdl.Port;
import edu.supercom.csdl.Rule;
import edu.supercom.csdl.Subsystem;
import edu.supercom.csdl.SubsystemRule;
import edu.supercom.csdl.Topology;
import edu.supercom.util.UnmodifiableMap;
import edu.supercom.util.UnmodifiableMapConstructor;
import java.util.HashMap;
import java.util.Map;

public class ExplicitSubsystemRule
extends AbstractSubsystemRule
implements SubsystemRule {
    private final UnmodifiableMap<Component, ComponentRule> _map;
    private final Subsystem _ss;

    public ExplicitSubsystemRule() {
        this._ss = new ExplicitSubsystem();
        this._map = new UnmodifiableMapConstructor().getMap();
    }

    private ExplicitSubsystemRule(Subsystem subsystem, UnmodifiableMap<Component, ComponentRule> unmodifiableMap) {
        this._ss = subsystem;
        this._map = unmodifiableMap;
    }

    private ExplicitSubsystemRule(Subsystem subsystem, Map<Component, ComponentRule> map) {
        this._ss = subsystem;
        this._map = new UnmodifiableMapConstructor<Component, ComponentRule>(map).getMap();
    }

    public static ExplicitSubsystemRule createSubsystemRule(Subsystem subsystem, Map<Component, ComponentRule> map) {
        ExplicitSubsystemRule explicitSubsystemRule = new ExplicitSubsystemRule(subsystem, new HashMap<Component, ComponentRule>(map));
        return explicitSubsystemRule;
    }

    public static ExplicitSubsystemRule createSubsystemRule(Configuration configuration, Subsystem subsystem, Map<Component, ComponentRule> map) {
        ExplicitSubsystemRule explicitSubsystemRule;
        Topology topology = configuration.getTopology();
        if (!topology.checkConsistency(explicitSubsystemRule = ExplicitSubsystemRule.createSubsystemRule(subsystem, map))) {
            return null;
        }
        return explicitSubsystemRule;
    }

    public static ExplicitSubsystemRule merge(SubsystemRule subsystemRule, SubsystemRule subsystemRule2) {
        Subsystem subsystem = subsystemRule.getSubsystem();
        Subsystem subsystem2 = subsystemRule2.getSubsystem();
        Subsystem subsystem3 = subsystem.merge(subsystem2);
        return ExplicitSubsystemRule.merge(subsystem3, subsystemRule, subsystemRule2);
    }

    public static ExplicitSubsystemRule merge(Subsystem subsystem, SubsystemRule subsystemRule, SubsystemRule subsystemRule2) {
        Subsystem subsystem2 = subsystemRule.getSubsystem();
        Subsystem subsystem3 = subsystemRule2.getSubsystem();
        UnmodifiableMapConstructor<Component, ComponentRule> unmodifiableMapConstructor = new UnmodifiableMapConstructor<Component, ComponentRule>();
        for (Component component : subsystem2.getComponents()) {
            unmodifiableMapConstructor.put(component, subsystemRule.getComponentRule(component));
        }
        for (Component component : subsystem3.getComponents()) {
            unmodifiableMapConstructor.put(component, subsystemRule2.getComponentRule(component));
        }
        ExplicitSubsystemRule explicitSubsystemRule = new ExplicitSubsystemRule(subsystem, unmodifiableMapConstructor.getMap());
        return explicitSubsystemRule;
    }

    public static ExplicitSubsystemRule merge(Configuration configuration, SubsystemRule subsystemRule, SubsystemRule subsystemRule2) {
        Comparable<ComponentRule> comparable;
        Comparable<ComponentRule> comparable2;
        Subsystem subsystem = subsystemRule.getSubsystem();
        Subsystem subsystem2 = subsystemRule2.getSubsystem();
        for (Component comparable3 : subsystem.getComponents()) {
            if (!subsystem2.containsComponent(comparable3) || (comparable2 = subsystemRule.getComponentRule(comparable3)) == (comparable = subsystemRule2.getComponentRule(comparable3))) continue;
            return null;
        }
        for (Connection connection : subsystem.getExternalConnections(configuration.getTopology())) {
            Message message;
            Port port;
            Comparable<ComponentRule> comparable3;
            Port port2;
            Comparable<ComponentRule> comparable4;
            comparable2 = connection.getSourceComponent();
            comparable = connection.getTargetComponent();
            boolean bl = subsystem.containsComponent((Component)comparable2);
            boolean bl2 = subsystem2.containsComponent((Component)comparable2);
            boolean bl3 = subsystem.containsComponent((Component)comparable);
            boolean bl4 = subsystem2.containsComponent((Component)comparable);
            if (bl == bl2 || bl3 == bl4) continue;
            if (bl) {
                comparable4 = comparable2;
                port2 = connection.getSourcePort();
                comparable3 = comparable;
                port = connection.getTargetPort();
            } else {
                comparable4 = comparable;
                port2 = connection.getTargetPort();
                comparable3 = comparable2;
                port = connection.getSourcePort();
            }
            Event event = subsystemRule.getComponentRule((Component)comparable4).getRule().getEvent(port2);
            Event event2 = subsystemRule2.getComponentRule((Component)comparable3).getRule().getEvent(port);
            if (event == null || event2 == null) {
                if (event == null && event2 == null) continue;
                return null;
            }
            Message message2 = event.getMessage();
            if (message2.equals(message = event2.getMessage())) continue;
            return null;
        }
        return ExplicitSubsystemRule.merge(subsystemRule, subsystemRule2);
    }

    @Override
    public Subsystem getSubsystem() {
        return this._ss;
    }

    @Override
    public ComponentRule getComponentRule(Component component) {
        return this._map.get(component);
    }

    @Override
    public Rule getRule(Component component) {
        ComponentRule componentRule = this.getComponentRule(component);
        if (componentRule == null) {
            return null;
        }
        return componentRule.getRule();
    }

    @Override
    public SubsystemRule project(Subsystem subsystem) {
        ExplicitSubsystemRule explicitSubsystemRule = new ExplicitSubsystemRule(subsystem, this._map);
        return explicitSubsystemRule;
    }

    @Override
    public SubsystemRule merge(SubsystemRule subsystemRule) {
        return ExplicitSubsystemRule.merge(this, subsystemRule);
    }

    @Override
    public SubsystemRule merge(Subsystem subsystem, SubsystemRule subsystemRule) {
        return ExplicitSubsystemRule.merge(subsystem, (SubsystemRule)this, subsystemRule);
    }

    @Override
    public boolean isAffected(Component component) {
        return this.getSubsystem().containsComponent(component) && this.getRule(component) != null;
    }
}

