/*
 * Decompiled with CFR 0.152.
 */
package edu.supercom.csdl;

import edu.supercom.csdl.AbstractTopology;
import edu.supercom.csdl.ActivationAction;
import edu.supercom.csdl.Component;
import edu.supercom.csdl.ComponentPort;
import edu.supercom.csdl.ComponentType;
import edu.supercom.csdl.CompositeSystem;
import edu.supercom.csdl.Connection;
import edu.supercom.csdl.ConnectionAction;
import edu.supercom.csdl.Event;
import edu.supercom.csdl.ExplicitSubsystem;
import edu.supercom.csdl.NotApplicableReconfiguration;
import edu.supercom.csdl.ObservableAction;
import edu.supercom.csdl.Port;
import edu.supercom.csdl.ReconfigurationPattern;
import edu.supercom.csdl.Subsystem;
import edu.supercom.csdl.Topology;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class FastAccessTopology
extends AbstractTopology
implements Topology {
    private Subsystem _sub;
    private final Map<String, Component> _nameToComponent;
    private final Set<Connection> _connections;
    private final Map<Component, Set<Connection>> _compToConnections;
    private final Map<Component, Set<Connection>> _targetCompToConnections;
    private final Map<Component, Set<Connection>> _sourceCompToConnections;
    private final Map<Component, Map<Port, Set<Connection>>> _compPortToConnections;
    private final Map<Component, Map<Port, Connection>> _compPortToConnection;
    private final Set<ComponentPort> _observable;
    private final Map<Component, Set<Port>> _compToObservable;
    private final int _hash;

    protected FastAccessTopology(FastAccessTopology fastAccessTopology) {
        this._sub = fastAccessTopology._sub;
        this._nameToComponent = new HashMap<String, Component>(fastAccessTopology._nameToComponent);
        this._connections = new HashSet<Connection>(fastAccessTopology._connections);
        this._compToConnections = new HashMap<Component, Set<Connection>>(fastAccessTopology._compToConnections.size());
        this._targetCompToConnections = new HashMap<Component, Set<Connection>>(fastAccessTopology._targetCompToConnections.size());
        this._sourceCompToConnections = new HashMap<Component, Set<Connection>>(fastAccessTopology._sourceCompToConnections.size());
        this._compPortToConnections = new HashMap<Component, Map<Port, Set<Connection>>>(fastAccessTopology._connections.size());
        this._compPortToConnection = new HashMap<Component, Map<Port, Connection>>(fastAccessTopology._connections.size());
        this._observable = new HashSet<ComponentPort>(fastAccessTopology._observable);
        this._compToObservable = new HashMap<Component, Set<Port>>(fastAccessTopology._compToObservable);
        for (Component component : fastAccessTopology._sub) {
            Map<Port, Connection> map = fastAccessTopology._compToConnections.get(component);
            Cloneable cloneable = new HashSet<Connection>((Collection<Connection>)((Object)map));
            this._compToConnections.put(component, (Set<Connection>)((Object)cloneable));
            map = fastAccessTopology._targetCompToConnections.get(component);
            cloneable = new HashSet<Connection>((Collection<Connection>)((Object)map));
            this._targetCompToConnections.put(component, (Set<Connection>)((Object)cloneable));
            map = fastAccessTopology._sourceCompToConnections.get(component);
            cloneable = new HashSet<Connection>((Collection<Connection>)((Object)map));
            this._sourceCompToConnections.put(component, (Set<Connection>)((Object)cloneable));
            map = fastAccessTopology._compPortToConnections.get(component);
            cloneable = new HashMap();
            for (Port port : component.outputPorts()) {
                Set set = (Set)map.get(port);
                HashSet hashSet = new HashSet(set);
                cloneable.put(port, hashSet);
            }
            this._compPortToConnections.put(component, (Map<Port, Set<Connection>>)((Object)cloneable));
            map = fastAccessTopology._compPortToConnection.get(component);
            cloneable = new HashMap<Port, Connection>(map);
            this._compPortToConnection.put(component, (Map<Port, Connection>)((Object)cloneable));
        }
        this._hash = super.hashCode();
    }

    public FastAccessTopology(Collection<Component> collection, Collection<Connection> collection2, Collection<ComponentPort> collection3) {
        Set set;
        Object object;
        Object object2;
        HashMap<String, Component> hashMap = new HashMap<String, Component>(collection.size());
        HashMap<Component, Set<Object>> hashMap2 = new HashMap<Component, Set<Object>>(collection.size());
        HashMap<Component, Set<Object>> hashMap3 = new HashMap<Component, Set<Object>>(collection.size());
        HashMap<Component, Set<Object>> hashMap4 = new HashMap<Component, Set<Object>>(collection.size());
        HashMap<Component, Object> hashMap5 = new HashMap<Component, Object>(collection.size());
        HashMap hashMap6 = new HashMap(collection.size());
        HashMap<Component, Set<Object>> hashMap7 = new HashMap<Component, Set<Object>>(collection.size());
        this._sub = new ExplicitSubsystem(collection);
        for (Component comparable : collection) {
            hashMap.put(comparable.getName(), comparable);
            hashMap2.put(comparable, new HashSet());
            hashMap3.put(comparable, new HashSet());
            hashMap4.put(comparable, new HashSet());
            object2 = new HashMap(comparable.numberOfOutputPorts());
            hashMap5.put(comparable, object2);
            for (Port port : comparable.outputPorts()) {
                object2.put(port, new HashSet());
            }
            object = new HashMap();
            hashMap6.put(comparable, object);
            hashMap7.put(comparable, new HashSet());
        }
        this._nameToComponent = Collections.unmodifiableMap(hashMap);
        this._connections = Collections.unmodifiableSet(new HashSet<Connection>(collection2));
        for (Connection connection : collection2) {
            object2 = connection.getSourceComponent();
            object = connection.getSourcePort();
            Set set2 = (Set)hashMap2.get(object2);
            if (set2 == null) {
                throw new IllegalArgumentException("Component of connection " + connection + " is not active.");
            }
            set2.add(connection);
            set = (Set)hashMap4.get(object2);
            set.add(connection);
            Map map = (Map)hashMap5.get(object2);
            Set set3 = (Set)map.get(object);
            set3.add(connection);
            object2 = connection.getTargetComponent();
            object = connection.getTargetPort();
            Set set4 = (Set)hashMap2.get(object2);
            if (set4 == null) {
                throw new IllegalArgumentException("Component of connection " + connection + " is not active.");
            }
            set4.add(connection);
            set = (Set)hashMap3.get(object2);
            set.add(connection);
            map = (Map)hashMap6.get(object2);
            if (map.put(object, connection) == null) continue;
            throw new IllegalArgumentException("Two or more connections for the input port " + ((Port)object).getName() + " of component " + ((Component)object2).getName());
        }
        for (Component component : collection) {
            hashMap2.put(component, Collections.unmodifiableSet((Set)hashMap2.get(component)));
            hashMap3.put(component, Collections.unmodifiableSet((Set)hashMap3.get(component)));
            hashMap4.put(component, Collections.unmodifiableSet((Set)hashMap4.get(component)));
            object2 = (Map)hashMap5.get(component);
            for (Port port : component.outputPorts()) {
                set = (Set)object2.get(port);
                object2.put(port, Collections.unmodifiableSet(set));
            }
            hashMap5.put(component, Collections.unmodifiableMap(object2));
            hashMap6.put(component, Collections.unmodifiableMap((Map)hashMap6.get(component)));
        }
        this._compToConnections = Collections.unmodifiableMap(hashMap2);
        this._targetCompToConnections = Collections.unmodifiableMap(hashMap3);
        this._sourceCompToConnections = Collections.unmodifiableMap(hashMap4);
        this._compPortToConnections = Collections.unmodifiableMap(hashMap5);
        this._compPortToConnection = Collections.unmodifiableMap(hashMap6);
        this._observable = Collections.unmodifiableSet(new HashSet<ComponentPort>(collection3));
        for (ComponentPort componentPort : collection3) {
            ((Set)hashMap7.get(componentPort.getComponent())).add(componentPort.getPort());
        }
        for (Component component : collection) {
            hashMap7.put(component, Collections.unmodifiableSet((Set)hashMap7.get(component)));
        }
        this._compToObservable = Collections.unmodifiableMap(hashMap7);
        this._hash = super.hashCode();
    }

    @Override
    public Component getComponent(String string) {
        return this._nameToComponent.get(string);
    }

    @Override
    public boolean isActive(Component component) {
        return this._sub.containsComponent(component);
    }

    @Override
    public Collection<Connection> connections() {
        return this._connections;
    }

    @Override
    public Collection<Connection> connections(Component component) {
        Set<Connection> set = this._compToConnections.get(component);
        if (set == null) {
            throw new Error("Internal error: null set of connections for component " + component.toString() + ".");
        }
        return set;
    }

    @Override
    public Collection<Connection> targetConnections(Component component) {
        Set<Connection> set = this._targetCompToConnections.get(component);
        if (set == null) {
            throw new Error("Internal error: null set of connections for component " + component.toString() + ".");
        }
        return set;
    }

    @Override
    public Collection<Connection> sourceConnections(Component component) {
        Set<Connection> set = this._sourceCompToConnections.get(component);
        if (set == null) {
            throw new Error("Internal error: null set of connections for component " + component.toString() + ".");
        }
        return set;
    }

    @Override
    public Collection<Connection> connections(Component component, Port port) {
        if (port.isInputPort()) {
            throw new IllegalArgumentException("The port " + port.toString() + " is not an output port.");
        }
        Map<Port, Set<Connection>> map = this._compPortToConnections.get(component);
        if (map == null) {
            throw new Error("Internal error: null set of connections for component " + component.toString() + ".");
        }
        Set<Connection> set = map.get(port);
        if (set == null) {
            throw new Error("Internal error: null set of connections for component " + component.toString() + "and port " + port.toString() + ".");
        }
        return set;
    }

    @Override
    public Connection getConnection(Component component, Port port) {
        Map<Port, Connection> map;
        if (!port.isInputPort()) {
            throw new IllegalArgumentException("The port " + port.toString() + " is not an input port.");
        }
        try {
            map = this._compPortToConnection.get(component);
        }
        catch (ClassCastException classCastException) {
            throw new Error("Internal error: _compPortToConnection.get(" + component.toString() + ") should be a Map" + " but is a " + this._compPortToConnection.get(component).getClass().toString());
        }
        if (map == null) {
            throw new Error("Internal error: null set of connections for component " + component.toString() + ".");
        }
        return map.get(port);
    }

    @Override
    public Collection<ComponentPort> observablePorts() {
        return this._observable;
    }

    @Override
    public Collection<Port> observablePorts(Component component) {
        return this._compToObservable.get(component);
    }

    @Override
    public boolean isObservable(Component component, Port port) {
        Set<Port> set = this._compToObservable.get(component);
        return set.contains(port);
    }

    public Topology newApply(CompositeSystem compositeSystem, ReconfigurationPattern reconfigurationPattern, Map<String, String> map) {
        HashMap hashMap;
        Set<Object> set;
        Component component;
        Comparable<Connection> comparable;
        Subsystem subsystem = this._sub;
        Map<String, Component> map2 = this._nameToComponent;
        Set<Connection> set2 = this._connections;
        Map<Component, Set<Connection>> map3 = this._compToConnections;
        Map<Component, Set<Connection>> map4 = this._sourceCompToConnections;
        Map<Component, Set<Connection>> map5 = this._targetCompToConnections;
        Map<Component, Map<Port, Set<Connection>>> map6 = this._compPortToConnections;
        Map<Component, Map<Port, Connection>> map7 = this._compPortToConnection;
        Set<ComponentPort> set3 = this._observable;
        Map<Component, Set<Port>> map8 = this._compToObservable;
        for (ConnectionAction object : reconfigurationPattern.deconnections()) {
            Port port;
            comparable = object.getConnection(compositeSystem, map);
            if (set2 == this._connections) {
                set2 = new HashSet<Connection>(set2);
                map3 = new HashMap<Component, Set<Connection>>(map3);
                map4 = new HashMap<Component, Set<Connection>>(map4);
                map5 = new HashMap<Component, Set<Connection>>(map5);
                map6 = new HashMap<Component, Map<Port, Set<Connection>>>(map6);
                map7 = new HashMap<Component, Map<Port, Connection>>(map7);
            }
            set2.remove(comparable);
            component = ((Connection)comparable).getSourceComponent();
            set = map3.get(component);
            if (set == this._compToConnections.get(component)) {
                set = new HashSet(set);
                map3.put(component, set);
            }
            set.remove(comparable);
            set = map4.get(component);
            if (set == this._sourceCompToConnections.get(component)) {
                set = new HashSet<Object>(set);
                map4.put(component, (Set<Connection>)set);
            }
            set.remove(comparable);
            hashMap = map6.get(component);
            if (hashMap == this._compPortToConnections.get(component)) {
                hashMap = new HashMap(hashMap);
                map6.put(component, hashMap);
            }
            if ((set = (Set)hashMap.get(port = ((Connection)comparable).getSourcePort())) == this._compPortToConnections.get(component).get(port)) {
                set = new HashSet(set);
                hashMap.put(port, set);
            }
            set.remove(comparable);
            component = ((Connection)comparable).getTargetComponent();
            set = map3.get(component);
            if (set == this._compToConnections.get(component)) {
                set = new HashSet<Object>(set);
                map3.put(component, set);
            }
            set.remove(comparable);
            set = map5.get(component);
            if (set == this._targetCompToConnections.get(component)) {
                set = new HashSet<Object>(set);
                map5.put(component, set);
            }
            set.remove(comparable);
            hashMap = map7.get(component);
            if (hashMap == this._compPortToConnection.get(component)) {
                hashMap = new HashMap(hashMap);
                map7.put(component, hashMap);
            }
            port = ((Connection)comparable).getTargetPort();
            hashMap.remove(port);
        }
        for (ObservableAction observableAction : reconfigurationPattern.unobservationActions()) {
            comparable = observableAction.getComponentPort(compositeSystem, map);
            if (set3 == this._observable) {
                set3 = new HashSet<ComponentPort>(this._observable);
                map8 = new HashMap<Component, Set<Port>>(this._compToObservable);
            }
            set3.remove(comparable);
            component = ((ComponentPort)comparable).getComponent();
            set = ((ComponentPort)comparable).getPort();
            hashMap = map8.get(component);
            if (hashMap == this._compToObservable.get(set)) {
                hashMap = new HashSet<Port>((Collection)this._compToObservable.get(set));
                map8.put(component, (Set<Port>)((Object)hashMap));
            }
            hashMap.remove(set);
        }
        for (ActivationAction activationAction : reconfigurationPattern.deactivations()) {
            comparable = activationAction.getComponent(compositeSystem, map);
            if (!map3.get(comparable).isEmpty()) {
                throw new IllegalArgumentException("Cannot deactivate component " + comparable + ": still connected.");
            }
            if (!map8.get(comparable).isEmpty()) {
                throw new IllegalArgumentException("Cannot deactivate component " + comparable + ": still observed.");
            }
            if (subsystem == this._sub) {
                map2 = new HashMap<String, Component>(map2);
            }
            map2.remove(((Component)comparable).getName());
        }
        for (ActivationAction activationAction : reconfigurationPattern.activations()) {
            comparable = activationAction.getComponent(compositeSystem, map);
            if (subsystem == this._sub) {
                map2 = new HashMap<String, Component>(map2);
            }
            subsystem.addElement((Component)comparable);
            map2.put(((Component)comparable).getName(), (Component)comparable);
        }
        for (ObservableAction observableAction : reconfigurationPattern.observationActions()) {
            comparable = observableAction.getComponentPort(compositeSystem, map);
            if (set3 == this._observable) {
                set3 = new HashSet<ComponentPort>(this._observable);
                map8 = new HashMap<Component, Set<Port>>(this._compToObservable);
            }
            set3.add((ComponentPort)comparable);
            component = ((ComponentPort)comparable).getComponent();
            set = ((ComponentPort)comparable).getPort();
            hashMap = map8.get(component);
            if (hashMap == this._compToObservable.get(set)) {
                hashMap = new HashSet(this._compToObservable.get(set));
                map8.put(component, (Set<Port>)((Object)hashMap));
            }
            hashMap.add((Port)((Object)set));
        }
        return null;
    }

    @Override
    public Topology apply(CompositeSystem compositeSystem, ReconfigurationPattern reconfigurationPattern, Map<String, String> map) {
        Connection connection;
        Port port;
        Port port2;
        Component component;
        Object object;
        Object object2;
        Object object3;
        String string;
        FastAccessTopology fastAccessTopology = new FastAccessTopology(this);
        for (ConnectionAction object4 : reconfigurationPattern.deconnections()) {
            string = object4.getSourceComponent(map);
            object3 = object4.getTargetComponent(map);
            object2 = object4.getSourcePort(map);
            object = object4.getTargetPort(map);
            if (string == null) {
                throw new IllegalArgumentException("The variable " + object4.getSourceComponent() + " is not instanciated.");
            }
            if (object3 == null) {
                throw new IllegalArgumentException("The variable " + object4.getTargetComponent() + " is not instanciated.");
            }
            if (object2 == null) {
                throw new IllegalArgumentException("The variable " + object4.getSourcePort() + " is not instanciated.");
            }
            if (object == null) {
                throw new IllegalArgumentException("The variable " + object4.getTargetPort() + " is not instanciated.");
            }
            Component component2 = compositeSystem.getComponent(string);
            if (component2 == null) {
                throw new IllegalArgumentException("The component " + string + " is unknown.");
            }
            component = compositeSystem.getComponent((String)object3);
            if (component == null) {
                throw new IllegalArgumentException("The component " + (String)object3 + " is unknown.");
            }
            port2 = component2.getOutputPort((String)object2);
            if (port2 == null) {
                throw new IllegalArgumentException("The output port " + (String)object2 + " is unknown.");
            }
            port = component.getInputPort((String)object);
            if (port == null) {
                throw new IllegalArgumentException("The input port " + (String)object + " is unknown.");
            }
            connection = new Connection(component2, port2, component, port);
            if (!fastAccessTopology._connections.remove(connection)) {
                throw new IllegalArgumentException("The connection " + connection.toString() + " does not exist.");
            }
            fastAccessTopology._compToConnections.get(component2).remove(connection);
            fastAccessTopology._compToConnections.get(component).remove(connection);
            fastAccessTopology._targetCompToConnections.get(component).remove(connection);
            fastAccessTopology._sourceCompToConnections.get(component2).remove(connection);
            fastAccessTopology._compPortToConnections.get(component2).get(port2).remove(connection);
            fastAccessTopology._compPortToConnection.get(component).remove(port);
        }
        for (ObservableAction observableAction : reconfigurationPattern.unobservationActions()) {
            string = observableAction.getCompName(map);
            if (string == null) {
                throw new IllegalArgumentException("The variable " + observableAction.getCompName() + " is not instanciated.");
            }
            object3 = compositeSystem.getComponent(string);
            if (object3 == null) {
                throw new IllegalArgumentException("The component " + string + " does not exist.");
            }
            object2 = observableAction.getPortName(map);
            if (object2 == null) {
                throw new IllegalArgumentException("The port " + observableAction.getPortName() + " is not instanciated.");
            }
            object = ((Component)object3).getPort((String)object2);
            if (object == null) {
                throw new IllegalArgumentException("The port " + (String)object2 + " does not exist on the component " + string + ".");
            }
            if (!fastAccessTopology._observable.remove(new ComponentPort((Component)object3, (Port)object))) {
                throw new IllegalArgumentException("The port " + (String)object2 + " of component " + string + " cannot be set to unobservable (is not observable).");
            }
            fastAccessTopology._compToObservable.get(object3).remove(object);
        }
        for (ActivationAction activationAction : reconfigurationPattern.deactivations()) {
            string = activationAction.getName(map);
            if (string == null) {
                throw new IllegalArgumentException("The variable " + activationAction.getName() + " is not instanciated.");
            }
            object3 = compositeSystem.getComponent(string);
            if (object3 == null) {
                throw new IllegalArgumentException("The component " + string + " does not exist.");
            }
            if (!fastAccessTopology._sub.containsComponent((Component)object3)) {
                object2 = "The component " + ((Component)object3).toString() + " could not be deactivated" + " (is not active in the current topology).";
                throw new NotApplicableReconfiguration(this, reconfigurationPattern, map, (String)object2);
            }
            fastAccessTopology._sub = fastAccessTopology._sub.removeElement((Component)object3);
            fastAccessTopology._nameToComponent.remove(string);
            if (fastAccessTopology._compToConnections.remove(object3).size() != 0) {
                throw new IllegalArgumentException("Component " + string + " cannot be removed as it still contain connections.");
            }
            fastAccessTopology._targetCompToConnections.remove(object3);
            fastAccessTopology._sourceCompToConnections.remove(object3);
            fastAccessTopology._compPortToConnections.remove(object3);
            fastAccessTopology._compPortToConnection.remove(object3);
            if (fastAccessTopology._compToObservable.remove(object3).size() == 0) continue;
            throw new IllegalArgumentException("Component " + string + " cannot be removed as some ports are still observable.");
        }
        for (ActivationAction activationAction : reconfigurationPattern.activations()) {
            string = activationAction.getName(map);
            if (string == null) {
                throw new IllegalArgumentException("The variable " + activationAction.getName() + " is not instanciated.");
            }
            object3 = compositeSystem.getComponent(string);
            if (object3 == null) {
                throw new IllegalArgumentException("The component " + string + " does not exist.");
            }
            if (fastAccessTopology._sub.containsComponent((Component)object3)) {
                object2 = "The component " + ((Component)object3).toString() + " could not be activated" + " (is already active in the current topology).";
                throw new NotApplicableReconfiguration(this, reconfigurationPattern, map, (String)object2);
            }
            fastAccessTopology._sub = fastAccessTopology._sub.addElement((Component)object3);
            fastAccessTopology._nameToComponent.put(string, (Component)object3);
            fastAccessTopology._compToConnections.put((Component)object3, new HashSet());
            fastAccessTopology._targetCompToConnections.put((Component)object3, new HashSet());
            fastAccessTopology._sourceCompToConnections.put((Component)object3, new HashSet());
            object2 = new HashMap();
            for (Port port3 : ((Component)object3).outputPorts()) {
                object2.put(port3, new HashSet());
            }
            fastAccessTopology._compPortToConnections.put((Component)object3, (Map<Port, Set<Connection>>)object2);
            fastAccessTopology._compPortToConnection.put((Component)object3, new HashMap());
            fastAccessTopology._compToObservable.put((Component)object3, new HashSet());
        }
        for (ObservableAction observableAction : reconfigurationPattern.observationActions()) {
            string = observableAction.getCompName(map);
            if (string == null) {
                throw new IllegalArgumentException("The variable " + observableAction.getCompName() + " is not instanciated.");
            }
            object3 = fastAccessTopology.getComponent(string);
            if (object3 == null) {
                throw new IllegalArgumentException("The component " + string + " does not exist.");
            }
            object2 = observableAction.getPortName(map);
            if (object2 == null) {
                throw new IllegalArgumentException("The port " + observableAction.getPortName() + " is not instanciated.");
            }
            object = ((Component)object3).getPort((String)object2);
            if (object == null) {
                throw new IllegalArgumentException("The port " + (String)object2 + " does not exist on the component " + string + ".");
            }
            if (!fastAccessTopology._observable.add(new ComponentPort((Component)object3, (Port)object))) {
                throw new IllegalArgumentException("The port " + (String)object2 + " of component " + string + " cannot be set to observable (is already observable).");
            }
            fastAccessTopology._compToObservable.get(object3).add((Port)object);
        }
        for (ConnectionAction connectionAction : reconfigurationPattern.connections()) {
            string = connectionAction.getSourceComponent(map);
            object3 = connectionAction.getTargetComponent(map);
            object2 = connectionAction.getSourcePort(map);
            object = connectionAction.getTargetPort(map);
            if (string == null) {
                throw new IllegalArgumentException("The variable " + connectionAction.getSourceComponent() + " is not instanciated.");
            }
            if (object3 == null) {
                throw new IllegalArgumentException("The variable " + connectionAction.getTargetComponent() + " is not instanciated.");
            }
            if (object2 == null) {
                throw new IllegalArgumentException("The variable " + connectionAction.getSourcePort() + " is not instanciated.");
            }
            if (object == null) {
                throw new IllegalArgumentException("The variable " + connectionAction.getTargetPort() + " is not instanciated.");
            }
            Component component3 = fastAccessTopology.getComponent(string);
            if (component3 == null) {
                throw new IllegalArgumentException("The component " + string + " is unknown.");
            }
            component = fastAccessTopology.getComponent((String)object3);
            if (component == null) {
                throw new IllegalArgumentException("The component " + (String)object3 + " is unknown.");
            }
            if (component3 == component) {
                throw new IllegalArgumentException("Cannot connect the same component");
            }
            port2 = component3.getOutputPort((String)object2);
            if (port2 == null) {
                throw new IllegalArgumentException("The output port " + (String)object2 + " is unknown.");
            }
            port = component.getInputPort((String)object);
            if (port == null) {
                throw new IllegalArgumentException("The input port " + object + " is unknown.");
            }
            connection = new Connection(component3, port2, component, port);
            if (!fastAccessTopology._connections.add(connection)) {
                throw new IllegalArgumentException("The connection " + connection.toString() + " already exists.");
            }
            fastAccessTopology._compToConnections.get(component3).add(connection);
            fastAccessTopology._compToConnections.get(component).add(connection);
            fastAccessTopology._targetCompToConnections.get(component).add(connection);
            fastAccessTopology._sourceCompToConnections.get(component3).add(connection);
            fastAccessTopology._compPortToConnections.get(component3).get(port2).add(connection);
            fastAccessTopology._compPortToConnection.get(component).put(port, connection);
        }
        return null;
    }

    @Override
    public boolean canBeTriggered(Component component, Event event) {
        Port port;
        ComponentType componentType = component.getType();
        if (componentType.isActionPort(port = event.getPort()) || componentType.isSpontaneousPort(port)) {
            return true;
        }
        if (port.isInputPort()) {
            Connection connection = this.getConnection(component, port);
            if (connection == null) {
                return false;
            }
            Port port2 = connection.getSourcePort();
            if (!port2.mayOccur(event.getMessage())) {
                return false;
            }
        } else {
            for (Connection connection : this.connections(component, port)) {
                Port port3 = connection.getTargetPort();
                if (port3.mayOccur(event.getMessage())) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public Subsystem activeSubsystem() {
        return this._sub;
    }

    @Override
    public int hashCode() {
        return this._hash;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        return super.equals(object);
    }
}

