/*
 * Decompiled with CFR 0.152.
 */
package edu.supercom.csdl;

import edu.supercom.csdl.AbstractTopology;
import edu.supercom.csdl.ActivationAction;
import edu.supercom.csdl.Component;
import edu.supercom.csdl.ComponentPort;
import edu.supercom.csdl.CompositeSystem;
import edu.supercom.csdl.Connection;
import edu.supercom.csdl.ConnectionAction;
import edu.supercom.csdl.ExplicitSubsystem;
import edu.supercom.csdl.NotApplicableReconfiguration;
import edu.supercom.csdl.ObservableAction;
import edu.supercom.csdl.Port;
import edu.supercom.csdl.ReconfigurationPattern;
import edu.supercom.csdl.Subsystem;
import edu.supercom.csdl.Topology;
import edu.supercom.util.UnmodifiableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;

public class FastReconfigTopology
extends AbstractTopology
implements Topology {
    private Subsystem _comps;
    private Collection<Connection> _connections;
    private Collection<ComponentPort> _obs;

    private FastReconfigTopology() {
        this._comps = new ExplicitSubsystem();
        this._connections = new HashSet<Connection>();
        this._obs = new HashSet<ComponentPort>();
    }

    public FastReconfigTopology(Topology topology) {
        this._comps = topology.activeSubsystem();
        this._connections = new HashSet<Connection>();
        for (Connection comparable : topology.connections()) {
            this._connections.add(comparable);
        }
        this._obs = new HashSet<ComponentPort>();
        for (ComponentPort componentPort : topology.observablePorts()) {
            this._obs.add(componentPort);
        }
    }

    @Override
    public Topology apply(CompositeSystem compositeSystem, ReconfigurationPattern reconfigurationPattern, Map<String, String> map) {
        Connection connection;
        Port port;
        Port port2;
        Component component;
        Component component2;
        Object object;
        String string;
        Object object2;
        String string2;
        FastReconfigTopology fastReconfigTopology = new FastReconfigTopology(this);
        for (ConnectionAction object3 : reconfigurationPattern.deconnections()) {
            string2 = object3.getSourceComponent(map);
            object2 = object3.getTargetComponent(map);
            string = object3.getSourcePort(map);
            object = object3.getTargetPort(map);
            if (string2 == null) {
                throw new IllegalArgumentException("The variable " + object3.getSourceComponent() + " is not instanciated.");
            }
            if (object2 == null) {
                throw new IllegalArgumentException("The variable " + object3.getTargetComponent() + " is not instanciated.");
            }
            if (string == null) {
                throw new IllegalArgumentException("The variable " + object3.getSourcePort() + " is not instanciated.");
            }
            if (object == null) {
                throw new IllegalArgumentException("The variable " + object3.getTargetPort() + " is not instanciated.");
            }
            component2 = compositeSystem.getComponent(string2);
            if (component2 == null) {
                throw new IllegalArgumentException("The component " + string2 + " is unknown.");
            }
            component = compositeSystem.getComponent((String)object2);
            if (component == null) {
                throw new IllegalArgumentException("The component " + (String)object2 + " is unknown.");
            }
            port2 = component2.getOutputPort(string);
            if (port2 == null) {
                throw new IllegalArgumentException("The output port " + string + " is unknown.");
            }
            port = component.getInputPort((String)object);
            if (port == null) {
                throw new IllegalArgumentException("The input port " + (String)object + " is unknown.");
            }
            connection = new Connection(component2, port2, component, port);
            if (this._connections.remove(connection)) continue;
            throw new IllegalArgumentException("The connection " + connection.toString() + " does not exist.");
        }
        for (ObservableAction observableAction : reconfigurationPattern.unobservationActions()) {
            string2 = observableAction.getCompName(map);
            if (string2 == null) {
                throw new IllegalArgumentException("The variable " + observableAction.getCompName() + " is not instanciated.");
            }
            object2 = compositeSystem.getComponent(string2);
            if (object2 == null) {
                throw new IllegalArgumentException("The component " + string2 + " does not exist.");
            }
            string = observableAction.getPortName(map);
            if (string == null) {
                throw new IllegalArgumentException("The port " + observableAction.getPortName() + " is not instanciated.");
            }
            object = ((Component)object2).getPort(string);
            if (object == null) {
                throw new IllegalArgumentException("The port " + string + " does not exist on the component " + string2 + ".");
            }
            if (fastReconfigTopology._obs.remove(new ComponentPort((Component)object2, (Port)object))) continue;
            throw new IllegalArgumentException("The port " + string + " of component " + string2 + " cannot be set to unobservable (is not observable).");
        }
        for (ActivationAction activationAction : reconfigurationPattern.deactivations()) {
            string2 = activationAction.getName(map);
            if (string2 == null) {
                throw new IllegalArgumentException("The variable " + activationAction.getName() + " is not instanciated.");
            }
            object2 = compositeSystem.getComponent(string2);
            if (object2 == null) {
                throw new IllegalArgumentException("The component " + string2 + " does not exist.");
            }
            if (!fastReconfigTopology._comps.containsComponent((Component)object2)) {
                string = "The component " + ((Component)object2).toString() + " could not be deactivated" + " (is not active in the current topology).";
                throw new NotApplicableReconfiguration(this, reconfigurationPattern, map, string);
            }
            if (!fastReconfigTopology.connections((Component)object2).isEmpty()) {
                throw new IllegalArgumentException("Component " + string2 + " cannot be removed as it still contain connections.");
            }
            if (!fastReconfigTopology.observablePorts((Component)object2).isEmpty()) {
                throw new IllegalArgumentException("Component " + string2 + " cannot be removed as some ports are still observable.");
            }
            fastReconfigTopology._comps = fastReconfigTopology._comps.removeElement((Component)object2);
        }
        for (ActivationAction activationAction : reconfigurationPattern.activations()) {
            string2 = activationAction.getName(map);
            if (string2 == null) {
                throw new IllegalArgumentException("The variable " + activationAction.getName() + " is not instanciated.");
            }
            object2 = compositeSystem.getComponent(string2);
            if (object2 == null) {
                throw new IllegalArgumentException("The component " + string2 + " does not exist.");
            }
            if (fastReconfigTopology._comps.containsComponent((Component)object2)) {
                string = "The component " + ((Component)object2).toString() + " could not be activated" + " (is already active in the current topology).";
                throw new NotApplicableReconfiguration(this, reconfigurationPattern, map, string);
            }
            fastReconfigTopology._comps = fastReconfigTopology._comps.addElement((Component)object2);
        }
        for (ObservableAction observableAction : reconfigurationPattern.observationActions()) {
            string2 = observableAction.getCompName(map);
            if (string2 == null) {
                throw new IllegalArgumentException("The variable " + observableAction.getCompName() + " is not instanciated.");
            }
            object2 = fastReconfigTopology.getComponent(string2);
            if (object2 == null) {
                throw new IllegalArgumentException("The component " + string2 + " does not exist.");
            }
            string = observableAction.getPortName(map);
            if (string == null) {
                throw new IllegalArgumentException("The port " + observableAction.getPortName() + " is not instanciated.");
            }
            object = ((Component)object2).getPort(string);
            if (object == null) {
                throw new IllegalArgumentException("The port " + string + " does not exist on the component " + string2 + ".");
            }
            if (fastReconfigTopology._obs.add(new ComponentPort((Component)object2, (Port)object))) continue;
            throw new IllegalArgumentException("The port " + string + " of component " + string2 + " cannot be set to observable (is already observable).");
        }
        for (ConnectionAction connectionAction : reconfigurationPattern.connections()) {
            string2 = connectionAction.getSourceComponent(map);
            object2 = connectionAction.getTargetComponent(map);
            string = connectionAction.getSourcePort(map);
            object = connectionAction.getTargetPort(map);
            if (string2 == null) {
                throw new IllegalArgumentException("The variable " + connectionAction.getSourceComponent() + " is not instanciated.");
            }
            if (object2 == null) {
                throw new IllegalArgumentException("The variable " + connectionAction.getTargetComponent() + " is not instanciated.");
            }
            if (string == null) {
                throw new IllegalArgumentException("The variable " + connectionAction.getSourcePort() + " is not instanciated.");
            }
            if (object == null) {
                throw new IllegalArgumentException("The variable " + connectionAction.getTargetPort() + " is not instanciated.");
            }
            component2 = fastReconfigTopology.getComponent(string2);
            if (component2 == null) {
                throw new IllegalArgumentException("The component " + string2 + " is unknown.");
            }
            component = fastReconfigTopology.getComponent((String)object2);
            if (component == null) {
                throw new IllegalArgumentException("The component " + (String)object2 + " is unknown.");
            }
            if (component2 == component) {
                throw new IllegalArgumentException("Cannot connect the same component");
            }
            port2 = component2.getOutputPort(string);
            if (port2 == null) {
                throw new IllegalArgumentException("The output port " + string + " is unknown.");
            }
            port = component.getInputPort((String)object);
            if (port == null) {
                throw new IllegalArgumentException("The input port " + (String)object + " is unknown.");
            }
            connection = new Connection(component2, port2, component, port);
            if (fastReconfigTopology._connections.add(connection)) continue;
            throw new IllegalArgumentException("The connection " + connection.toString() + " already exists.");
        }
        return null;
    }

    @Override
    @Deprecated
    public UnmodifiableSet<Component> activeComponents() {
        return this._comps.getComponents();
    }

    @Override
    public Collection<Connection> connections() {
        return Collections.unmodifiableCollection(this._connections);
    }

    @Override
    public Collection<ComponentPort> observablePorts() {
        return Collections.unmodifiableCollection(this._obs);
    }

    @Override
    public Subsystem activeSubsystem() {
        return this._comps;
    }
}

