/*
 * Decompiled with CFR 0.152.
 */
package edu.supercom.csdl;

import edu.supercom.csdl.AbstractSystemState;
import edu.supercom.csdl.Assignment;
import edu.supercom.csdl.Component;
import edu.supercom.csdl.ComponentType;
import edu.supercom.csdl.MapSubsystemState;
import edu.supercom.csdl.MapTypeState;
import edu.supercom.csdl.Rule;
import edu.supercom.csdl.RuleEffect;
import edu.supercom.csdl.SubsystemRule;
import edu.supercom.csdl.SubsystemState;
import edu.supercom.csdl.SystemState;
import edu.supercom.csdl.Topology;
import edu.supercom.csdl.TypeState;
import edu.supercom.csdl.TypeStateCondition;
import edu.supercom.csdl.Value;
import edu.supercom.csdl.Variable;
import edu.supercom.util.UnmodifiableMap;
import edu.supercom.util.UnmodifiableMapConstructor;
import java.util.Collections;
import java.util.Map;

public class MapSystemState
extends AbstractSystemState
implements SystemState {
    private final UnmodifiableMap<Component, TypeState> _map;
    private final Topology _top;

    public MapSystemState(Topology topology) {
        this(topology, Collections.emptyMap());
    }

    public MapSystemState(Topology topology, Map<Component, Map<Variable, Value>> map) {
        this._top = topology;
        UnmodifiableMapConstructor<Component, MapTypeState> unmodifiableMapConstructor = new UnmodifiableMapConstructor<Component, MapTypeState>();
        for (Component component : map.keySet()) {
            Map<Variable, Value> map2 = map.get(component);
            MapTypeState mapTypeState = new MapTypeState(component.getType(), map2);
            unmodifiableMapConstructor.addMapping(component, mapTypeState);
        }
        this._map = unmodifiableMapConstructor.getMap();
    }

    public MapSystemState(Topology topology, UnmodifiableMap<Component, TypeState> unmodifiableMap) {
        this._top = topology;
        this._map = unmodifiableMap;
    }

    private MapSystemState(SystemState systemState) {
        this._top = systemState.getTopology();
        UnmodifiableMapConstructor<Component, TypeState> unmodifiableMapConstructor = new UnmodifiableMapConstructor<Component, TypeState>();
        for (Component component : this._top.activeSubsystem()) {
            unmodifiableMapConstructor.addMapping(component, systemState.getSubsystemState().getComponentState(component).getTypeState());
        }
        this._map = unmodifiableMapConstructor.getMap();
    }

    public MapSystemState(MapSystemState mapSystemState, Component component, Variable variable, Assignment assignment) {
        this._top = mapSystemState.getTopology();
        TypeState typeState = mapSystemState.getTypeState(component);
        TypeState typeState2 = typeState.apply(assignment);
        this._map = mapSystemState._map.putElement(component, typeState2);
    }

    public MapSystemState(SystemState systemState, Component component, Variable variable, Assignment assignment) {
        Object object2;
        this._top = systemState.getTopology();
        UnmodifiableMapConstructor<Component, Object> unmodifiableMapConstructor = new UnmodifiableMapConstructor<Component, Object>();
        for (Object object2 : systemState.getTopology().activeSubsystem()) {
            unmodifiableMapConstructor.put((Component)object2, systemState.getSubsystemState().getComponentState(component).getTypeState());
        }
        TypeState typeState = systemState.getSubsystemState().getComponentState(component).getTypeState();
        object2 = typeState.apply(assignment);
        unmodifiableMapConstructor.addMapping(component, object2);
        this._map = unmodifiableMapConstructor.getMap();
    }

    public MapSystemState add(Component component, Variable variable, Assignment assignment) {
        return new MapSystemState(this, component, variable, assignment);
    }

    public MapSystemState add(Map<Component, Map<Variable, Assignment>> map) {
        MapSystemState mapSystemState = new MapSystemState(this);
        for (Map.Entry<Component, Map<Variable, Assignment>> entry : map.entrySet()) {
            Component component = entry.getKey();
            TypeState typeState = mapSystemState.getTypeState(component);
            Map<Variable, Assignment> map2 = map.get(component);
            for (Variable variable : map2.keySet()) {
                Assignment assignment = map2.get(variable);
                typeState = typeState.apply(assignment);
            }
            mapSystemState._map.put(component, typeState);
        }
        return mapSystemState;
    }

    @Override
    public Assignment getAssignement(Component component, Variable variable) {
        TypeState typeState = this.getTypeState(component);
        return typeState.getAssignement(variable);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (Map.Entry entry : this._map.entrySet()) {
            Component component = (Component)entry.getKey();
            ComponentType componentType = component.getType();
            TypeState typeState = (TypeState)entry.getValue();
            for (Variable variable : componentType.variables()) {
                Assignment assignment = typeState.getAssignement(variable);
                stringBuffer.append(component.getName()).append("\t").append(variable.getName()).append("\t").append(assignment.getValue().getLabel()).append("\n");
            }
        }
        return stringBuffer.toString();
    }

    @Override
    public SystemState apply(SubsystemRule subsystemRule) {
        UnmodifiableMapConstructor<Component, TypeState> unmodifiableMapConstructor = new UnmodifiableMapConstructor<Component, TypeState>(this._map);
        for (Component component : this._top.activeSubsystem()) {
            Rule rule = subsystemRule.getRule(component);
            if (rule == null) continue;
            TypeState typeState = this.getTypeState(component);
            RuleEffect ruleEffect = rule.getEffect();
            TypeState typeState2 = ruleEffect.modify(typeState);
            unmodifiableMapConstructor.put(component, typeState2);
        }
        return new MapSystemState(this._top, unmodifiableMapConstructor.getMap());
    }

    @Override
    public SystemState checkAndApply(SubsystemRule subsystemRule) {
        MapSystemState mapSystemState = new MapSystemState(this);
        for (Component component : this._top.activeSubsystem()) {
            Rule rule = subsystemRule.getRule(component);
            if (rule == null) continue;
            TypeState typeState = mapSystemState.getTypeState(component);
            TypeStateCondition typeStateCondition = rule.getPrecondition();
            if (!typeStateCondition.satisfied(typeState, 0)) {
                return null;
            }
            RuleEffect ruleEffect = rule.getEffect();
            TypeState typeState2 = ruleEffect.modify(typeState);
            mapSystemState._map.put(component, typeState2);
        }
        return mapSystemState;
    }

    @Override
    public Topology getTopology() {
        return this._top;
    }

    @Override
    public boolean checkApplicability(SubsystemRule subsystemRule) {
        MapSystemState mapSystemState = new MapSystemState(this);
        for (Component component : this._top.activeSubsystem()) {
            Rule rule = subsystemRule.getRule(component);
            if (rule == null) continue;
            TypeState typeState = mapSystemState.getTypeState(component);
            TypeStateCondition typeStateCondition = rule.getPrecondition();
            if (typeStateCondition.satisfied(typeState, 0)) continue;
            return false;
        }
        return true;
    }

    @Override
    @Deprecated
    public TypeState getTypeState(Component component) {
        return this._map.get(component);
    }

    @Override
    public SubsystemState getSubsystemState() {
        return new MapSubsystemState(this._map);
    }
}

