/*
 * Decompiled with CFR 0.152.
 */
package edu.supercom.csdl;

import edu.supercom.csdl.AbstractTypeState;
import edu.supercom.csdl.Assignment;
import edu.supercom.csdl.ComponentType;
import edu.supercom.csdl.TypeState;
import edu.supercom.csdl.Value;
import edu.supercom.csdl.Variable;
import edu.supercom.util.UnmodifiableCollection;
import edu.supercom.util.UnmodifiableMap;
import edu.supercom.util.UnmodifiableMapConstructor;
import edu.supercom.util.UnmodifiableSet;
import java.util.Collection;
import java.util.Map;

public class MapTypeState
extends AbstractTypeState {
    private final ComponentType _type;
    private final UnmodifiableMap<Variable, Value> _assMap;

    public MapTypeState(ComponentType componentType, Map<Variable, Value> map) {
        this._type = componentType;
        UnmodifiableMapConstructor<Variable, Value> unmodifiableMapConstructor = new UnmodifiableMapConstructor<Variable, Value>();
        for (Variable variable : componentType.variables()) {
            Value value = map.get(variable);
            if (value == null) {
                value = variable.defaultValue();
            }
            unmodifiableMapConstructor.put(variable, value);
        }
        this._assMap = unmodifiableMapConstructor.getMap();
    }

    public MapTypeState(TypeState typeState) {
        this._type = typeState.getComponentType();
        UnmodifiableMapConstructor<Variable, Value> unmodifiableMapConstructor = new UnmodifiableMapConstructor<Variable, Value>();
        for (Variable variable : this._type.variables()) {
            Value value = typeState.getValue(variable);
            unmodifiableMapConstructor.put(variable, value);
        }
        this._assMap = unmodifiableMapConstructor.getMap();
    }

    public MapTypeState(TypeState typeState, Assignment assignment) {
        this._type = typeState.getComponentType();
        UnmodifiableMapConstructor<Variable, Value> unmodifiableMapConstructor = new UnmodifiableMapConstructor<Variable, Value>();
        for (Variable variable : this._type.variables()) {
            Value value = typeState.getValue(variable);
            unmodifiableMapConstructor.put(variable, value);
        }
        unmodifiableMapConstructor.put(assignment.getVariable(), assignment.getValue());
        this._assMap = unmodifiableMapConstructor.getMap();
    }

    public MapTypeState(MapTypeState mapTypeState, Variable variable, Value value) {
        this._assMap = mapTypeState._assMap.putElement(variable, value);
        this._type = mapTypeState._type;
    }

    @Override
    public Assignment getAssignement(Variable variable) {
        return variable.getAssignement(this.getValue(variable));
    }

    @Override
    public Value getValue(Variable variable) {
        Value value = this._assMap.get(variable);
        if (value == null) {
            return variable.defaultValue();
        }
        return value;
    }

    @Override
    public MapTypeState apply(Assignment assignment) {
        return this.putElement(assignment.getVariable(), assignment.getValue());
    }

    public UnmodifiableMap<Variable, Value> getAssignements() {
        return this._assMap;
    }

    @Override
    public TypeState apply(Collection<Assignment> collection) {
        MapTypeState mapTypeState = this;
        for (Assignment assignment : collection) {
            mapTypeState = mapTypeState.apply(assignment);
        }
        return mapTypeState;
    }

    @Override
    public ComponentType getComponentType() {
        return this._type;
    }

    @Override
    public UnmodifiableSet<Map.Entry<Variable, Value>> entrySet() {
        return this._assMap.entrySet();
    }

    @Override
    public UnmodifiableSet<Variable> keySet() {
        return this._assMap.keySet();
    }

    @Override
    public Value get(Object object) {
        if (object instanceof Variable) {
            Variable variable = (Variable)object;
            return this.getValue(variable);
        }
        return null;
    }

    @Override
    public UnmodifiableCollection<Value> values() {
        return this._assMap.values();
    }

    @Override
    public MapTypeState putElement(Variable variable, Value value) {
        Value value2 = this.getValue(variable);
        if (value == value2) {
            return this;
        }
        return new MapTypeState(this, variable, value);
    }
}

